/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.analysis.callsite;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.analysis.callsite.CallsiteIterator;
import org.eclipse.tracecompass.internal.tmf.core.analysis.callsite.CallsiteStateProvider;
import org.eclipse.tracecompass.internal.tmf.core.analysis.callsite.StateSystemStringInterner;
import org.eclipse.tracecompass.tmf.core.analysis.callsite.ITmfCallsiteIterator;
import org.eclipse.tracecompass.tmf.core.analysis.callsite.ITmfCallsiteResolver;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCallsiteAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfDeviceAspect;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CallsiteAnalysis
extends TmfStateSystemAnalysisModule
implements ITmfCallsiteResolver {
    public static final String ID = "org.eclipse.tracecompass.tmf.core.analysis.callsite";
    private final StateSystemStringInterner fSSInterner = new StateSystemStringInterner();

    @Override
    public boolean canExecute(ITmfTrace trace) {
        Iterable<ITmfEventAspect<?>> devices = TmfTraceUtils.getEventAspects(trace, TmfDeviceAspect.class);
        Iterable<ITmfEventAspect<?>> callsites = TmfTraceUtils.getEventAspects(trace, TmfCallsiteAspect.class);
        return trace.getUUID() != null && !Iterables.isEmpty(devices) && !Iterables.isEmpty(callsites) && super.canExecute(trace);
    }

    @Override
    protected @NonNull ITmfStateProvider createStateProvider() {
        ITmfTrace trace = this.getTrace();
        return new CallsiteStateProvider(Objects.requireNonNull(trace), ID, this.fSSInterner);
    }

    @Override
    public List<ITmfCallsite> getCallsites(String traceId, String deviceType, String deviceId, long time) {
        ITmfCallsiteIterator iterator = this.iterator(traceId, deviceType, deviceId, time);
        if (iterator.hasPrevious()) {
            return Collections.singletonList(iterator.previous().getCallsite());
        }
        return Collections.emptyList();
    }

    @Override
    public ITmfCallsiteIterator iterator(String traceId, String deviceType, String deviceId, long initialTime) {
        return new CallsiteIterator(this.getStateSystem(), traceId, deviceType, deviceId, initialTime, this.fSSInterner);
    }

    protected StateSystemStringInterner getStringInterner() {
        return this.fSSInterner;
    }
}

