/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.callstack;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.callstack.LttngUstCallStackAnalysisRequirement;
import org.eclipse.tracecompass.internal.lttng2.ust.core.callstack.LttngUstCallStackProvider;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class LttngUstCallStackAnalysis
extends CallStackAnalysis {
    public static final String ID = "org.eclipse.linuxtools.lttng2.ust.analysis.callstack";
    private @Nullable Set<@NonNull TmfAbstractAnalysisRequirement> fAnalysisRequirements = null;

    public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (!(trace instanceof LttngUstTrace)) {
            return false;
        }
        return super.setTrace(trace);
    }

    public LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    protected ITmfStateProvider createStateProvider() {
        return new LttngUstCallStackProvider((ITmfTrace)NonNullUtils.checkNotNull((Object)((Object)this.getTrace())));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        @NonNull ImmutableSet requirements = this.fAnalysisRequirements;
        if (requirements == null) {
            LttngUstTrace trace = this.getTrace();
            ILttngUstEventLayout layout = ILttngUstEventLayout.DEFAULT_LAYOUT;
            if (trace != null) {
                layout = trace.getEventLayout();
            }
            this.fAnalysisRequirements = requirements = ImmutableSet.of((Object)((Object)new LttngUstCallStackAnalysisRequirement(layout)));
        }
        return requirements;
    }
}

