/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.QueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.TableColumnHeader;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.TreeModelWrapper;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.VirtualTableModelWrapper;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ExperimentManagerService;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.TraceAnnotationProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableModel;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlOutputElement;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.XmlDataProviderManager;
import org.eclipse.tracecompass.internal.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.w3c.dom.Element;

@Path(value="/experiments/{expUUID}/outputs")
public class DataProviderService {
    private static final String WRONG_PARAMETERS = "Wrong query parameters";
    private static final String NO_PROVIDER = "Analysis cannot run";
    private static final String NO_SUCH_TRACE = "No Such Trace";
    private static final String MISSING_OUTPUTID = "Missing parameter outputId";
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(DataProviderService.class);
    private final DataProviderManager manager = DataProviderManager.getInstance();

    @GET
    @Produces(value={"application/json"})
    public Response getProviders(@PathParam(value="expUUID") UUID expUUID) {
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List list = DataProviderManager.getInstance().getAvailableProviders((ITmfTrace)experiment);
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.TIME_GRAPH)));
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.XY)));
        return Response.ok((Object)list).build();
    }

    @GET
    @Path(value="/{outputId}")
    @Produces(value={"application/json"})
    public Response getProvider(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId) {
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List list = DataProviderManager.getInstance().getAvailableProviders((ITmfTrace)experiment);
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.TIME_GRAPH)));
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.XY)));
        Optional<IDataProviderDescriptor> provider = list.stream().filter(p -> p.getId().equals(outputId)).findFirst();
        if (provider.isPresent()) {
            return Response.ok((Object)provider.get()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    @Path(value="/XY/{outputId}/tree")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getXYTree(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        return this.getTree(expUUID, outputId, queryParameters);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/XY/{outputId}/xy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getXY(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)MISSING_OUTPUTID).build();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getXY", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)NO_SUCH_TRACE).build();
            }
            @NonNull ITmfTreeXYDataProvider provider = (ITmfTreeXYDataProvider)this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfTreeXYDataProvider.class);
            if (provider == null) {
                provider = (ITmfTreeXYDataProvider)DataProviderService.getXmlProvider((ITmfTrace)experiment, outputId, EnumSet.of(XmlUtils.OutputType.XY));
            }
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)NO_PROVIDER).build();
            }
            SelectionTimeQueryFilter selectionTimeQueryFilter = FetchParametersUtils.createSelectionTimeQuery(queryParameters.getParameters());
            if (selectionTimeQueryFilter == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)WRONG_PARAMETERS).build();
            }
            @NonNull TmfModelResponse response = provider.fetchXY(queryParameters.getParameters(), null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @GET
    @Path(value="/XY/{outputId}/tooltip")
    @Produces(value={"application/json"})
    public Response getXYTooltip(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, @QueryParam(value="xValue") long xValue, @QueryParam(value="yValue") long yValue, @QueryParam(value="entryId") long entryId) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)"XY tooltip are not implemented yet").build();
    }

    @POST
    @Path(value="/timeGraph/{outputId}/tree")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getTimeGraphTree(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        return this.getTree(expUUID, outputId, queryParameters);
    }

    @POST
    @Path(value="/timeGraph/{outputId}/states")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getStates(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)MISSING_OUTPUTID).build();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getStates", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)NO_SUCH_TRACE).build();
            }
            ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> provider = this.getTimeGraphProvider((ITmfTrace)experiment, outputId);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)NO_PROVIDER).build();
            }
            SelectionTimeQueryFilter selectionTimeQueryFilter = FetchParametersUtils.createSelectionTimeQuery(queryParameters.getParameters());
            if (selectionTimeQueryFilter == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)WRONG_PARAMETERS).build();
            }
            TmfModelResponse response = provider.fetchRowModel(queryParameters.getParameters(), null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/timeGraph/{outputId}/arrows")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getArrows(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)MISSING_OUTPUTID).build();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getArrows", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)NO_SUCH_TRACE).build();
            }
            ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> provider = this.getTimeGraphProvider((ITmfTrace)experiment, outputId);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)NO_PROVIDER).build();
            }
            TimeQueryFilter timeQueryFilter = FetchParametersUtils.createTimeQuery(queryParameters.getParameters());
            if (timeQueryFilter == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)WRONG_PARAMETERS).build();
            }
            @NonNull @NonNull TmfModelResponse response = provider.fetchArrows(queryParameters.getParameters(), null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @GET
    @Path(value="/{outputId}/annotations")
    @Produces(value={"application/json"})
    public Response getAnnotationCategories(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)MISSING_OUTPUTID).build();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getAnnotationCategories", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)NO_SUCH_TRACE).build();
            }
            @NonNull ITmfTreeDataProvider provider = this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)NO_PROVIDER).build();
            }
            boolean isComplete = true;
            AnnotationCategoriesModel model = null;
            TraceAnnotationProvider traceAnnotationProvider = ExperimentManagerService.getTraceAnnotationProvider(expUUID);
            @NonNull Map<@NonNull K, @NonNull V> params = Collections.emptyMap();
            if (traceAnnotationProvider != null) {
                @NonNull TmfModelResponse traceAnnotations = traceAnnotationProvider.fetchAnnotationCategories(params, null);
                if (traceAnnotations.getStatus() == ITmfResponse.Status.CANCELLED || traceAnnotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationCategoriesModel(Collections.emptyList()), traceAnnotations.getStatus(), traceAnnotations.getStatusMessage())).build();
                }
                isComplete &= traceAnnotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = (AnnotationCategoriesModel)traceAnnotations.getModel();
            }
            if (provider instanceof IOutputAnnotationProvider) {
                @NonNull TmfModelResponse annotations = ((IOutputAnnotationProvider)provider).fetchAnnotationCategories(params, null);
                if (annotations.getStatus() == ITmfResponse.Status.CANCELLED || annotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationCategoriesModel(Collections.emptyList()), annotations.getStatus(), annotations.getStatusMessage())).build();
                }
                isComplete &= annotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = AnnotationCategoriesModel.of((AnnotationCategoriesModel[])new AnnotationCategoriesModel[]{model, (AnnotationCategoriesModel)annotations.getModel()});
            }
            if (isComplete) {
                return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED)).build();
            }
            return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING)).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/{outputId}/annotations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAnnotations(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)MISSING_OUTPUTID).build();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getAnnotations", new Object[0]).setCategory(outputId).build();){
            Set selectedCategories;
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)NO_SUCH_TRACE).build();
            }
            @NonNull ITmfTreeDataProvider provider = this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)NO_PROVIDER).build();
            }
            boolean isComplete = true;
            AnnotationModel model = null;
            TraceAnnotationProvider traceAnnotationProvider = ExperimentManagerService.getTraceAnnotationProvider(expUUID);
            if (traceAnnotationProvider != null) {
                @NonNull TmfModelResponse traceAnnotations = traceAnnotationProvider.fetchAnnotations(queryParameters.getParameters(), null);
                if (traceAnnotations.getStatus() == ITmfResponse.Status.CANCELLED || traceAnnotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationModel(Collections.emptyMap()), traceAnnotations.getStatus(), traceAnnotations.getStatusMessage())).build();
                }
                isComplete &= traceAnnotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = (AnnotationModel)traceAnnotations.getModel();
            }
            if (provider instanceof IOutputAnnotationProvider) {
                @NonNull TmfModelResponse annotations = ((IOutputAnnotationProvider)provider).fetchAnnotations(queryParameters.getParameters(), null);
                if (annotations.getStatus() == ITmfResponse.Status.CANCELLED || annotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationModel(Collections.emptyMap()), annotations.getStatus(), annotations.getStatusMessage())).build();
                }
                isComplete &= annotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = AnnotationModel.of((AnnotationModel[])new AnnotationModel[]{model, (AnnotationModel)annotations.getModel()});
            }
            if ((selectedCategories = DataProviderParameterUtils.extractSelectedCategories(queryParameters.getParameters())) != null && model != null) {
                @NonNull LinkedHashMap<@NonNull K, @NonNull @NonNull V> allAnnotations = new LinkedHashMap(model.getAnnotations());
                allAnnotations.keySet().removeIf(cat -> !selectedCategories.contains(cat));
                model = new AnnotationModel(allAnnotations);
            }
            if (isComplete) {
                return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED)).build();
            }
            return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING)).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/timeGraph/{outputId}/tooltip")
    @Produces(value={"application/json"})
    public Response getTimeGraphTooltip(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)MISSING_OUTPUTID).build();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getTimeGraphTooltip", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)NO_SUCH_TRACE).build();
            }
            ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> provider = this.getTimeGraphProvider((ITmfTrace)experiment, outputId);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)NO_PROVIDER).build();
            }
            @NonNull @NonNull @NonNull TmfModelResponse response = provider.fetchTooltip(queryParameters.getParameters(), null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> getTimeGraphProvider(@NonNull ITmfTrace trace, String outputId) {
        @NonNull ITimeGraphDataProvider provider = (ITimeGraphDataProvider)this.manager.getDataProvider(trace, outputId, ITimeGraphDataProvider.class);
        if (provider == null && outputId != null) {
            provider = (ITimeGraphDataProvider)DataProviderService.getXmlProvider(trace, outputId, EnumSet.of(XmlUtils.OutputType.TIME_GRAPH));
        }
        return provider;
    }

    @POST
    @Path(value="/table/{outputId}/columns")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getColumns(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        Response response = this.getTree(expUUID, outputId, queryParameters);
        Object entity = response.getEntity();
        if (!(entity instanceof TmfModelResponse)) {
            return response;
        }
        Object model = ((TmfModelResponse)entity).getModel();
        if (!(model instanceof TreeModelWrapper)) {
            return response;
        }
        List<@NonNull ITmfTreeDataModel> entries = ((TreeModelWrapper)model).getEntries();
        ArrayList<TableColumnHeader> columns = new ArrayList<TableColumnHeader>();
        for (ITmfTreeDataModel dataModel : entries) {
            columns.add(new TableColumnHeader(dataModel));
        }
        return Response.ok((Object)new TmfModelResponse(columns, ((TmfModelResponse)entity).getStatus(), ((TmfModelResponse)entity).getStatusMessage())).build();
    }

    @POST
    @Path(value="/table/{outputId}/lines")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getLines(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)MISSING_OUTPUTID).build();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getLines", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)NO_SUCH_TRACE).build();
            }
            ITmfVirtualTableDataProvider provider = (ITmfVirtualTableDataProvider)this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfVirtualTableDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)NO_PROVIDER).build();
            }
            TmfModelResponse response = provider.fetchLines(queryParameters.getParameters(), null);
            if (response.getStatus() == ITmfResponse.Status.FAILED) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)response.getStatusMessage()).build();
            }
            return Response.ok((Object)new TmfModelResponse((Object)new VirtualTableModelWrapper((ITmfVirtualTableModel)response.getModel()), response.getStatus(), response.getStatusMessage())).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static <P extends ITmfTreeDataProvider<? extends ITmfTreeDataModel>> P getXmlProvider(@NonNull ITmfTrace trace, @NonNull String id, EnumSet<XmlUtils.OutputType> types) {
        for (XmlUtils.OutputType viewType : types) {
            for (XmlOutputElement element2 : Iterables.filter((Iterable)XmlUtils.getXmlOutputElements().values(), element -> element.getXmlElem().equals(viewType.getXmlElem()) && id.equals(element.getId()))) {
                Element viewElement = TmfXmlUtils.getElementInFile((String)element2.getPath(), (String)viewType.getXmlElem(), (String)id);
                if (viewElement != null && viewType == XmlUtils.OutputType.XY) {
                    return (P)XmlDataProviderManager.getInstance().getXyProvider(trace, viewElement);
                }
                if (viewElement == null || viewType != XmlUtils.OutputType.TIME_GRAPH) continue;
                return (P)XmlDataProviderManager.getInstance().getTimeGraphProvider(trace, viewElement);
            }
        }
        return null;
    }

    private static @NonNull List<IDataProviderDescriptor> getXmlDataProviderDescriptors(@NonNull ITmfTrace trace, EnumSet<XmlUtils.OutputType> types) {
        ArrayList<IDataProviderDescriptor> descriptors = new ArrayList<IDataProviderDescriptor>();
        Map modules = TmfAnalysisManager.getAnalysisModules(trace.getClass());
        for (XmlUtils.OutputType viewType : types) {
            block1: for (XmlOutputElement element2 : Iterables.filter((Iterable)XmlUtils.getXmlOutputElements().values(), element -> element.getXmlElem().equals(viewType.getXmlElem()))) {
                DataProviderDescriptor.Builder builder = new DataProviderDescriptor.Builder();
                String label = String.valueOf(element2.getLabel());
                String elemId = element2.getId();
                if (elemId == null) continue;
                builder.setId(elemId).setName(label).setDescription(label);
                if (viewType == XmlUtils.OutputType.XY) {
                    builder.setProviderType(IDataProviderDescriptor.ProviderType.TREE_TIME_XY);
                } else if (viewType == XmlUtils.OutputType.TIME_GRAPH) {
                    builder.setProviderType(IDataProviderDescriptor.ProviderType.TIME_GRAPH);
                }
                for (String id : element2.getAnalyses()) {
                    if (!modules.containsKey(id)) continue;
                    descriptors.add(builder.build());
                    continue block1;
                }
            }
        }
        return descriptors;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response getTree(UUID expUUID, String outputId, QueryParameters queryParameters) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)MISSING_OUTPUTID).build();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getTree", new Object[0]).setCategory(outputId).build();){
            TmfModelResponse tmfModelResponse;
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)NO_SUCH_TRACE).build();
            }
            @NonNull Object provider = this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                provider = DataProviderService.getXmlProvider((ITmfTrace)experiment, outputId, EnumSet.allOf(XmlUtils.OutputType.class));
            }
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)NO_PROVIDER).build();
            }
            TimeQueryFilter timeQueryFilter = FetchParametersUtils.createTimeQuery(queryParameters.getParameters());
            if (timeQueryFilter == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)WRONG_PARAMETERS).build();
            }
            TmfModelResponse treeResponse = provider.fetchTree(queryParameters.getParameters(), null);
            Object model = treeResponse.getModel();
            if (model instanceof TmfTreeModel) {
                tmfModelResponse = new TmfModelResponse((Object)new TreeModelWrapper((TmfTreeModel<ITmfTreeDataModel>)((TmfTreeModel)model)), treeResponse.getStatus(), treeResponse.getStatusMessage());
                return Response.ok((Object)tmfModelResponse).build();
            }
            tmfModelResponse = treeResponse;
            return Response.ok((Object)tmfModelResponse).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/{outputId}/style")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getStyles(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)MISSING_OUTPUTID).build();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getStyles", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)NO_SUCH_TRACE).build();
            }
            @NonNull ITmfTreeDataProvider provider = this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)NO_PROVIDER).build();
            }
            if (provider instanceof IOutputStyleProvider) {
                @NonNull TmfModelResponse styleModelResponse = ((IOutputStyleProvider)provider).fetchStyle(queryParameters.getParameters(), null);
                return Response.ok((Object)styleModelResponse).build();
            }
            return Response.ok((Object)new TmfModelResponse((Object)new OutputStyleModel(Collections.emptyMap()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED)).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

