/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.doxygen.internal.core;

import java.util.Objects;
import org.eclipse.cdt.core.options.OptionStorage;
import org.eclipse.cdt.core.options.OsgiPreferenceStorage;
import org.eclipse.cdt.doxygen.DoxygenMetadata;
import org.eclipse.cdt.doxygen.DoxygenOptions;
import org.eclipse.cdt.doxygen.core.DoxygenConfiguration;
import org.eclipse.cdt.doxygen.core.DoxygenPreferences;
import org.eclipse.cdt.doxygen.internal.core.DoxygenCoreMessages;
import org.eclipse.cdt.doxygen.internal.core.DoxygenMetadataDefaults;
import org.eclipse.cdt.doxygen.internal.core.DoxygenOptionsAccess;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.prefs.Preferences;

@Component
public class DoxygenPreferenceAccess
implements DoxygenConfiguration,
DoxygenPreferences {
    private final DoxygenMetadata doxygenMetadata = new DoxygenMetadataDefaults();

    @Override
    public OptionStorage workspaceStorage() {
        return new OsgiPreferenceStorage(this.preferences(InstanceScope.INSTANCE));
    }

    @Override
    public OptionStorage projectStorage(IProject project) {
        Objects.requireNonNull(DoxygenCoreMessages.DoxygenPreferenceAccess_e_null_project);
        return new OsgiPreferenceStorage(this.preferences((IScopeContext)new ProjectScope(project)));
    }

    @Override
    public DoxygenMetadata metadata() {
        return this.doxygenMetadata;
    }

    @Override
    public DoxygenOptions workspaceOptions() {
        return new DoxygenOptionsAccess(this.workspaceStorage(), this.doxygenMetadata);
    }

    @Override
    public DoxygenOptions projectOptions(IProject project) {
        Objects.requireNonNull(DoxygenCoreMessages.DoxygenPreferenceAccess_e_null_project);
        return new DoxygenOptionsAccess(this.projectStorage(project), this.doxygenMetadata);
    }

    private Preferences preferences(IScopeContext scope) {
        return scope.getNode(this.nodeQualifier()).node(this.nodePath());
    }

    private String nodeQualifier() {
        return "org.eclipse.cdt.core";
    }

    private String nodePath() {
        return "doxygen";
    }
}

