/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMPartialSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPArgumentList;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassTemplate;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassTemplatePartialSpecialization
extends PDOMCPPClassTemplate
implements IPDOMPartialSpecialization,
IPDOMOverloader,
ICPPClassTemplatePartialSpecialization {
    private static final int ARGUMENTS = 84;
    private static final int SIGNATURE_HASH = 88;
    private static final int PRIMARY = 92;
    private static final int NEXT_PARTIAL = 96;
    protected static final int RECORD_SIZE = 100;

    public PDOMCPPClassTemplatePartialSpecialization(PDOMCPPLinkage linkage, PDOMNode parent, ICPPClassTemplatePartialSpecialization partial, PDOMCPPClassTemplate primary) throws CoreException, DOMException {
        super(linkage, parent, partial, false);
        this.getDB().putRecPtr(this.record + 92L, primary.getRecord());
        primary.addPartial(this);
        try {
            Integer sigHash = IndexCPPSignatureUtil.getSignatureHash(partial);
            this.getDB().putInt(this.record + 88L, sigHash != null ? sigHash : 0);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
        PDOMCPPLinkage pDOMCPPLinkage = linkage;
        pDOMCPPLinkage.getClass();
        new PDOMCPPLinkage.ConfigurePartialSpecialization(pDOMCPPLinkage, this, partial);
    }

    public PDOMCPPClassTemplatePartialSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    public int getSignatureHash() throws CoreException {
        return this.getDB().getInt(this.record + 88L);
    }

    @Override
    protected int getRecordSize() {
        return 100;
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public PDOMCPPClassTemplatePartialSpecialization getNextPartial() throws CoreException {
        long value = this.getDB().getRecPtr(this.record + 96L);
        return value != 0L ? new PDOMCPPClassTemplatePartialSpecialization((PDOMLinkage)this.getLinkage(), value) : null;
    }

    public void setNextPartial(PDOMCPPClassTemplatePartialSpecialization partial) throws CoreException {
        long value = partial != null ? partial.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 96L, value);
    }

    @Override
    public ICPPClassTemplate getPrimaryClassTemplate() {
        try {
            return new PDOMCPPClassTemplate((PDOMLinkage)this.getLinkage(), this.getDB().getRecPtr(this.record + 92L));
        }
        catch (CoreException e) {
            CCorePlugin.log("Failed to load primary template for " + this.getName(), e);
            return null;
        }
    }

    @Override
    public void setTemplateArguments(ICPPTemplateArgument[] templateArguments) throws CoreException {
        Database db = this.getPDOM().getDB();
        long oldRec = db.getRecPtr(this.record + 84L);
        long rec = PDOMCPPArgumentList.putArguments(this, templateArguments);
        db.putRecPtr(this.record + 84L, rec);
        if (oldRec != 0L) {
            PDOMCPPArgumentList.clearArguments(this, oldRec);
        }
    }

    @Override
    public ICPPTemplateArgument[] getTemplateArguments() {
        try {
            long rec = this.getPDOM().getDB().getRecPtr(this.record + 84L);
            return PDOMCPPArgumentList.getArguments(this, rec);
        }
        catch (CoreException e) {
            CCorePlugin.log("Failed to load template arguments for " + this.getName(), e);
            return ICPPTemplateArgument.EMPTY_ARGUMENTS;
        }
    }

    @Override
    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        if (cmp == 0) {
            if (other instanceof PDOMCPPClassTemplatePartialSpecialization) {
                try {
                    PDOMCPPClassTemplatePartialSpecialization otherSpec = (PDOMCPPClassTemplatePartialSpecialization)other;
                    int mySM = this.getSignatureHash();
                    int otherSM = otherSpec.getSignatureHash();
                    return mySM == otherSM ? 0 : (mySM < otherSM ? -1 : 1);
                }
                catch (CoreException e) {
                    CCorePlugin.log("Comparison failure for " + this.getName(), e);
                }
            } else {
                assert (false);
                CCorePlugin.log((Throwable)((Object)new AssertionError((Object)("Assertion failure for " + this.getName()))));
            }
        }
        return cmp;
    }

    @Override
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (!(type instanceof ICPPClassTemplatePartialSpecialization)) {
            return false;
        }
        ICPPClassTemplatePartialSpecialization rhs = (ICPPClassTemplatePartialSpecialization)type;
        return CPPClassTemplatePartialSpecialization.isSamePartialClassSpecialization(this, rhs);
    }

    @Override
    public ICPPTemplateDefinition getPrimaryTemplate() {
        return this.getPrimaryClassTemplate();
    }
}

