/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.IPropertyTester;
import org.eclipse.core.internal.expressions.ExpressionPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Property {
    private final Class<?> fType;
    private final String fNamespace;
    private final String fName;
    private IPropertyTester fTester;

    Property(Class<?> type, String namespace, String name) {
        Assert.isNotNull(type);
        Assert.isNotNull((Object)namespace);
        Assert.isNotNull((Object)name);
        this.fType = type;
        this.fNamespace = namespace;
        this.fName = name;
    }

    void setPropertyTester(IPropertyTester tester) {
        Assert.isNotNull((Object)tester);
        this.fTester = tester;
    }

    public boolean isInstantiated() {
        return this.fTester.isInstantiated();
    }

    public boolean isDeclaringPluginActive() {
        return this.fTester.isDeclaringPluginActive();
    }

    public boolean isValidCacheEntry(boolean forcePluginActivation) {
        if (forcePluginActivation) {
            return this.isInstantiated() && this.isDeclaringPluginActive();
        }
        return this.isInstantiated() && this.isDeclaringPluginActive() || !this.isInstantiated() && !this.isDeclaringPluginActive();
    }

    public boolean test(Object receiver, Object[] args, Object expectedValue) throws CoreException {
        try {
            return this.fTester.test(receiver, this.fName, args, expectedValue);
        }
        catch (Exception e) {
            String message = "Error evaluating " + this;
            throw new CoreException((IStatus)new Status(4, ExpressionPlugin.getPluginId(), message, (Throwable)e));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property)obj;
        return this.fType.equals(other.fType) && this.fNamespace.equals(other.fNamespace) && this.fName.equals(other.fName);
    }

    public int hashCode() {
        return this.fType.hashCode() << 16 | this.fNamespace.hashCode() << 8 | this.fName.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Property [");
        builder.append(this.fNamespace);
        builder.append(".");
        builder.append(this.fName);
        builder.append(", type=");
        builder.append(this.fType);
        if (this.fTester != null) {
            builder.append(", tester=");
            builder.append(this.fTester);
        }
        builder.append("]");
        return builder.toString();
    }
}

