/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.QueryParameters;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IAnnotation;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;

public class QueryParametersDeserializer
extends StdDeserializer<QueryParameters> {
    private static final long serialVersionUID = 4511735530369955327L;
    private static final String DESTINATION_ID = "destinationId";
    private static final String DURATION = "duration";
    private static final String ELEMENT_TYPE = "elementType";
    private static final String ENTRY_ID = "entryId";
    private static final String FILTERS = "filters";
    private static final String PARAMETERS = "parameters";
    private static final String TIME = "time";
    private static final @NonNull OutputElementStyle EMPTY_STYLE = new OutputElementStyle(null, Collections.emptyMap());

    protected QueryParametersDeserializer() {
        super(QueryParameters.class);
    }

    public QueryParameters deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec codec = jp.getCodec();
        JsonNode node = (JsonNode)codec.readTree(jp);
        Map<String, Object> parameters = new HashMap<String, Object>();
        JsonNode parametersNode = node.get(PARAMETERS);
        if (parametersNode != null) {
            JsonParser parametersParser = parametersNode.traverse(codec);
            parametersParser.nextToken();
            parameters = (Map)ctxt.readValue(parametersParser, Map.class);
            parameters.computeIfPresent("requested_element", (k, v) -> {
                if (v instanceof Map) {
                    Map map = (Map)v;
                    Object elementType = map.get(ELEMENT_TYPE);
                    long time = ((Number)map.getOrDefault(TIME, 0L)).longValue();
                    long duration = ((Number)map.getOrDefault(DURATION, 0L)).longValue();
                    if ("state".equals(elementType)) {
                        return new TimeGraphState(time, duration, null, null);
                    }
                    if ("annotation".equals(elementType)) {
                        long entryId = ((Number)map.getOrDefault(ENTRY_ID, -1L)).longValue();
                        return new Annotation(time, duration, entryId, IAnnotation.AnnotationType.CHART, null, EMPTY_STYLE);
                    }
                    if ("arrow".equals(elementType)) {
                        long sourceId = ((Number)map.getOrDefault(ENTRY_ID, -1L)).longValue();
                        long destinationId = ((Number)map.getOrDefault(DESTINATION_ID, -1L)).longValue();
                        return new TimeGraphArrow(sourceId, destinationId, time, duration, EMPTY_STYLE);
                    }
                }
                return null;
            });
        }
        List filters = null;
        JsonNode filtersNode = node.get(FILTERS);
        if (filtersNode != null) {
            JsonParser filtersParser = filtersNode.traverse(codec);
            filtersParser.nextToken();
            filters = (List)ctxt.readValue(filtersParser, List.class);
        }
        return new QueryParameters(parameters, filters);
    }

    private static interface ElementType {
        public static final String STATE = "state";
        public static final String ANNOTATION = "annotation";
        public static final String ARROW = "arrow";
    }
}

