/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.common.core.process.ProcessUtils;
import org.eclipse.tracecompass.internal.analysis.lami.core.Activator;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.ShellUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiDurationAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiEmptyAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiIRQNameAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiIRQNumberAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiIRQTypeAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiMixedAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiProcessNameAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiProcessPIDAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiProcessTIDAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTimeRangeBeginAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTimeRangeDurationAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTimeRangeEndAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTimestampAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiChartModel;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableClass;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.Messages;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysis;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LamiAnalysis
implements IOnDemandAnalysis {
    private static final Logger LOGGER = TraceCompassLog.getLogger(LamiAnalysis.class);
    private static final String DOUBLE_QUOTES = "\"";
    private static final String MI_VERSION_FLAG = "--mi-version";
    private static final String TEST_COMPATIBILITY_FLAG = "--test-compatibility";
    private static final String METADATA_FLAG = "--metadata";
    private static final String PROGRESS_FLAG = "--output-progress";
    private static final String BEGIN_FLAG = "--begin";
    private static final String END_FLAG = "--end";
    private static final String LOG_VERSION = "LamiAnalysis:MIVersionReport";
    private static final String VERSION = "version";
    private static final String INVALID_MI_VERSION = "No specific or invalid MI version";
    private static final String LOG_NO_MI_VERSION = "LamiAnalysis:InvalidMIVersionReport";
    private static final String LOG_RUNNING_MESSAGE = "LamiAnalysis:RunningCommand";
    private static final String ERROR_PARSING_METADATA = "LamiAnalysis:ErrorParsingMetadata";
    private static final String RUNNING_METADATA_COMMAND = "LamiAnalysis:RunningMetadataCommand";
    private static final String COMMAND = "command";
    private static final String ERROR_PARSING_EXECUTION_OUTPUT = "LamiAnalysis:ErrorParsingExecutionOutput";
    private static final String RUNNING_EXECUTE_COMMAND = "LamiAnalysis:RunningExecuteCommand";
    private final List<String> fScriptCommand;
    private int fMiVersion = 0;
    private final String fName;
    private final boolean fIsUserDefined;
    private final Predicate<ITmfTrace> fAppliesTo;
    private @Nullable String fAnalysisTitle;
    private @Nullable Map<String, LamiTableClass> fTableClasses;
    private boolean fInitialized = false;
    private final Map<ITmfTrace, Boolean> fTraceCompatibilityCache = new WeakHashMap<ITmfTrace, Boolean>();
    private final EnumSet<Features> fFeatures = (EnumSet)NonNullUtils.checkNotNull(EnumSet.noneOf(Features.class));
    private static final ProcessUtils.OutputReaderFunction OUTPUT_READER = (reader, monitor) -> {
        double workedSoFar = 0.0;
        String line = reader.readLine();
        while (line != null && !line.matches("\\s*\\{.*")) {
            String[] elems = (line = line.trim()).split(" ", 2);
            if (elems[0].matches("\\d.*")) {
                try {
                    double cumulativeWork = Double.parseDouble(elems[0]) * 1000.0;
                    double workedThisLoop = cumulativeWork - workedSoFar;
                    if (workedThisLoop > 0.0) {
                        monitor.internalWorked(workedThisLoop);
                        workedSoFar = cumulativeWork;
                    }
                    if (elems.length >= 2) {
                        monitor.setTaskName(elems[1].trim());
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            line = reader.readLine();
        }
        ArrayList<String> results = new ArrayList<String>();
        while (line != null) {
            results.add(line);
            line = reader.readLine();
        }
        return results;
    };

    public LamiAnalysis(String name, boolean isUserDefined, Predicate<ITmfTrace> appliesTo, List<String> args) {
        this.fScriptCommand = ImmutableList.copyOf(args);
        this.fName = name;
        this.fIsUserDefined = isUserDefined;
        this.fAppliesTo = appliesTo;
    }

    protected Multimap<String, LamiChartModel> getPredefinedCharts() {
        return ImmutableMultimap.of();
    }

    public final boolean appliesTo(ITmfTrace trace) {
        return this.fAppliesTo.test(trace);
    }

    private boolean testCompatibility(ITmfTrace trace) {
        @NonNull String tracePath = (String)NonNullUtils.checkNotNull((Object)trace.getPath());
        ImmutableList commandLine = ImmutableList.builder().addAll(this.fScriptCommand).add((Object)TEST_COMPATIBILITY_FLAG).add((Object)tracePath).build();
        boolean isCompatible = this.getOutputFromCommand((List<String>)commandLine) != null;
        this.fTraceCompatibilityCache.put(trace, isCompatible);
        return isCompatible;
    }

    private boolean isSupported() {
        this.initialize();
        return this.fFeatures.contains((Object)Features.SUPPORTED);
    }

    public boolean canExecute(ITmfTrace trace) {
        if (!this.isSupported()) {
            return false;
        }
        if (!this.fFeatures.contains((Object)Features.TEST_COMPATIBILITY)) {
            return true;
        }
        if (this.fTraceCompatibilityCache.getOrDefault(trace, false).booleanValue()) {
            return true;
        }
        return this.testCompatibility(trace);
    }

    private void setFeatures() {
        if (this.fMiVersion == 0) {
            this.fFeatures.add(Features.VERSION_IS_SUPPORTED);
            return;
        }
        if (this.fMiVersion >= 100 && this.fMiVersion < 200) {
            this.fFeatures.add(Features.VERSION_IS_SUPPORTED);
            this.fFeatures.add(Features.OUTPUT_PROGRESS);
            this.fFeatures.add(Features.TEST_COMPATIBILITY);
        }
    }

    private void readVersion() {
        String command = this.fScriptCommand.get(0);
        ImmutableList commandLine = ImmutableList.builder().add((Object)command).add((Object)MI_VERSION_FLAG).build();
        String output = this.getOutputFromCommand((List<String>)commandLine);
        if (output == null) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.INFO, (String)LOG_NO_MI_VERSION, (Object[])new Object[]{INVALID_MI_VERSION, command});
            return;
        }
        String versionString = output.trim();
        if (!versionString.matches("\\d{1,3}\\.\\d{1,3}")) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.INFO, (String)LOG_NO_MI_VERSION, (Object[])new Object[]{COMMAND, command, VERSION, versionString});
            return;
        }
        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)LOG_VERSION, (Object[])new Object[]{COMMAND, command, VERSION, versionString});
        String[] parts = versionString.split("\\.");
        int major = Integer.valueOf(parts[0]);
        int minor = Integer.valueOf(parts[1]);
        this.fMiVersion = major * 100 + minor;
    }

    private static boolean executableExists(String name) {
        if (name.contains(File.separator)) {
            return Files.isExecutable(Paths.get(name, new String[0]));
        }
        String pathEnv = System.getenv("PATH");
        String[] exeDirs = pathEnv.split((String)NonNullUtils.checkNotNull((Object)Pattern.quote(File.pathSeparator)));
        return Stream.of(exeDirs).map(string -> Paths.get(string, new String[0])).anyMatch(path -> Files.isExecutable(path.resolve(name)));
    }

    @VisibleForTesting
    protected synchronized void initialize() {
        if (this.fInitialized) {
            return;
        }
        this.fInitialized = true;
        String executable = this.fScriptCommand.get(0);
        boolean executableExists = LamiAnalysis.executableExists(executable);
        if (!executableExists) {
            return;
        }
        this.readVersion();
        this.setFeatures();
        if (!this.fFeatures.contains((Object)Features.VERSION_IS_SUPPORTED)) {
            return;
        }
        if (this.checkMetadata()) {
            this.fFeatures.add(Features.SUPPORTED);
        }
    }

    @VisibleForTesting
    protected boolean checkMetadata() {
        ImmutableList command = ImmutableList.builder().addAll(this.fScriptCommand).add((Object)METADATA_FLAG).build();
        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.INFO, (String)RUNNING_METADATA_COMMAND, (Object[])new Object[]{COMMAND, command});
        String output = this.getOutputFromCommand((List<String>)command);
        if (output == null || output.isEmpty()) {
            return false;
        }
        try {
            JSONObject obj = new JSONObject(output);
            this.fAnalysisTitle = obj.getString("title");
            JSONObject tableClasses = obj.getJSONObject("table-classes");
            @NonNull String[] tableClassNames = (String[])NonNullUtils.checkNotNullContents((Object[])JSONObject.getNames((JSONObject)tableClasses));
            ImmutableMap.Builder tablesBuilder = ImmutableMap.builder();
            String[] stringArray = tableClassNames;
            int n = tableClassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String tableClassName = stringArray[n2];
                JSONObject tableClass = tableClasses.getJSONObject(tableClassName);
                String tableTitle = (String)NonNullUtils.checkNotNull((Object)tableClass.getString("title"));
                @NonNull JSONArray columnDescriptions = (JSONArray)NonNullUtils.checkNotNull((Object)tableClass.getJSONArray("column-descriptions"));
                List<LamiTableEntryAspect> aspects = LamiAnalysis.getAspectsFromColumnDescriptions(columnDescriptions);
                Collection chartModels = this.getPredefinedCharts().get((Object)tableClassName);
                tablesBuilder.put((Object)tableClassName, (Object)new LamiTableClass(tableClassName, tableTitle, aspects, chartModels));
                ++n2;
            }
            try {
                this.fTableClasses = tablesBuilder.build();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JSONException("Duplicate table class entry in " + this.fAnalysisTitle);
            }
        }
        catch (JSONException e) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)ERROR_PARSING_METADATA, (Object[])new Object[]{e.getMessage()});
            return false;
        }
        return true;
    }

    private static List<LamiTableEntryAspect> getAspectsFromColumnDescriptions(JSONArray columnDescriptions) throws JSONException {
        ImmutableList.Builder aspectsBuilder = new ImmutableList.Builder();
        int j = 0;
        while (j < columnDescriptions.length()) {
            JSONObject column = columnDescriptions.getJSONObject(j);
            String columnClass = column.optString("class", null);
            LamiData.DataType columnDataType = columnClass == null ? LamiData.DataType.MIXED : LamiAnalysis.getDataTypeFromString(columnClass);
            String columnTitle = column.optString("title", null);
            if (columnTitle == null) {
                columnTitle = String.format("%s #%d", columnDataType.getTitle(), j + 1);
            }
            int colIndex = j;
            switch (columnDataType) {
                case TIME_RANGE: {
                    aspectsBuilder.add((Object)new LamiTimeRangeBeginAspect(columnTitle, colIndex));
                    aspectsBuilder.add((Object)new LamiTimeRangeEndAspect(columnTitle, colIndex));
                    aspectsBuilder.add((Object)new LamiTimeRangeDurationAspect(columnTitle, colIndex));
                    break;
                }
                case TIMESTAMP: {
                    aspectsBuilder.add((Object)new LamiTimestampAspect(columnTitle, colIndex));
                    break;
                }
                case PROCESS: {
                    aspectsBuilder.add((Object)new LamiProcessNameAspect(columnTitle, colIndex));
                    aspectsBuilder.add((Object)new LamiProcessPIDAspect(columnTitle, colIndex));
                    aspectsBuilder.add((Object)new LamiProcessTIDAspect(columnTitle, colIndex));
                    break;
                }
                case IRQ: {
                    aspectsBuilder.add((Object)new LamiIRQTypeAspect(columnTitle, colIndex));
                    aspectsBuilder.add((Object)new LamiIRQNameAspect(columnTitle, colIndex));
                    aspectsBuilder.add((Object)new LamiIRQNumberAspect(columnTitle, colIndex));
                    break;
                }
                case DURATION: {
                    aspectsBuilder.add((Object)new LamiDurationAspect(columnTitle, colIndex));
                    break;
                }
                case MIXED: {
                    aspectsBuilder.add((Object)new LamiMixedAspect(columnTitle, colIndex));
                    break;
                }
                default: {
                    String units = column.optString("unit", null);
                    if (units == null) {
                        units = columnDataType.getUnits();
                    }
                    LamiGenericAspect aspect = new LamiGenericAspect(columnTitle, units, colIndex, columnDataType.isContinuous(), false);
                    aspectsBuilder.add((Object)aspect);
                }
            }
            ++j;
        }
        aspectsBuilder.add((Object)LamiEmptyAspect.INSTANCE);
        return aspectsBuilder.build();
    }

    private static LamiData.DataType getDataTypeFromString(String value) throws JSONException {
        try {
            return LamiData.DataType.fromString(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException("Unrecognized data type: " + value);
        }
    }

    public @Nullable String getAnalysisTitle() {
        return this.fAnalysisTitle;
    }

    public @Nullable Map<String, LamiTableClass> getTableClasses() {
        return this.fTableClasses;
    }

    public String getFullCommandAsString(ITmfTrace trace, @Nullable TmfTimeRange range) {
        String tracePath = (String)NonNullUtils.checkNotNull((Object)trace.getPath());
        ImmutableList.Builder<String> builder = this.getBaseCommand(range);
        builder.add((Object)(DOUBLE_QUOTES + tracePath + DOUBLE_QUOTES));
        return Objects.requireNonNull(String.join((CharSequence)" ", (Iterable<? extends CharSequence>)builder.build()));
    }

    private ImmutableList.Builder<String> getBaseCommand(@Nullable TmfTimeRange range) {
        long begin = 0L;
        long end = 0L;
        if (range != null) {
            begin = range.getStartTime().getValue();
            end = range.getEndTime().getValue();
            if (range.getStartTime().compareTo(range.getEndTime()) > 0) {
                begin = range.getEndTime().getValue();
                end = range.getStartTime().getValue();
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.fScriptCommand);
        if (this.fFeatures.contains((Object)Features.OUTPUT_PROGRESS)) {
            builder.add((Object)PROGRESS_FLAG);
        }
        if (range != null) {
            builder.add((Object)BEGIN_FLAG).add((Object)String.valueOf(begin));
            builder.add((Object)END_FLAG).add((Object)String.valueOf(end));
        }
        return builder;
    }

    public List<LamiResultTable> execute(ITmfTrace trace, @Nullable TmfTimeRange timeRange, String extraParamsString, IProgressMonitor monitor) throws CoreException {
        this.initialize();
        @NonNull String tracePath = (String)NonNullUtils.checkNotNull((Object)trace.getPath());
        @NonNull String trimmedExtraParamsString = (String)NonNullUtils.checkNotNull((Object)extraParamsString.trim());
        List<String> extraParams = ShellUtils.commandStringToArgs(trimmedExtraParamsString);
        ImmutableList.Builder<String> builder = this.getBaseCommand(timeRange);
        builder.addAll(extraParams);
        builder.add((Object)tracePath);
        ImmutableList command = builder.build();
        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.INFO, (String)RUNNING_EXECUTE_COMMAND, (Object[])new Object[]{COMMAND, command});
        String output = this.getResultsFromCommand((List<String>)command, monitor);
        if (output.isEmpty()) {
            Status status = new Status(1, Activator.instance().getPluginId(), Messages.LamiAnalysis_NoResults);
            throw new CoreException((IStatus)status);
        }
        ImmutableList.Builder resultsBuilder = new ImmutableList.Builder();
        try {
            JSONObject obj = new JSONObject(output);
            JSONArray results = obj.getJSONArray("results");
            if (results.length() == 0) {
                Status status = new Status(1, Activator.instance().getPluginId(), Messages.LamiAnalysis_NoResults);
                throw new CoreException((IStatus)status);
            }
            int i = 0;
            while (i < results.length()) {
                LamiTableClass tableClass;
                JSONObject result = results.getJSONObject(i);
                JSONObject trObject = (JSONObject)NonNullUtils.checkNotNull((Object)result.getJSONObject("time-range"));
                LamiData trData = LamiData.createFromObject(trObject);
                if (!(trData instanceof LamiTimeRange)) {
                    throw new JSONException("Time range did not have expected class type.");
                }
                LamiTimeRange tr = (LamiTimeRange)trData;
                JSONObject tableClassObject = result.optJSONObject("class");
                if (tableClassObject == null) {
                    @NonNull String tableClassName = (String)NonNullUtils.checkNotNull((Object)result.getString("class"));
                    tableClass = this.getTableClassFromName(tableClassName);
                } else if (tableClassObject.has("inherit")) {
                    String baseTableName = (String)NonNullUtils.checkNotNull((Object)tableClassObject.getString("inherit"));
                    LamiTableClass baseTableClass = this.getTableClassFromName(baseTableName);
                    String newTitle = (String)NonNullUtils.checkNotNull((Object)tableClassObject.getString("title"));
                    tableClass = new LamiTableClass(baseTableClass, newTitle);
                } else {
                    String title = (String)NonNullUtils.checkNotNull((Object)tableClassObject.getString("title"));
                    JSONArray columnDescriptions = (JSONArray)NonNullUtils.checkNotNull((Object)tableClassObject.getJSONArray("column-descriptions"));
                    List<LamiTableEntryAspect> aspects = LamiAnalysis.getAspectsFromColumnDescriptions(columnDescriptions);
                    tableClass = new LamiTableClass(NonNullUtils.nullToEmptyString((Object)Messages.LamiAnalysis_DefaultDynamicTableName), title, aspects, Collections.emptySet());
                }
                JSONArray data = result.getJSONArray("data");
                ImmutableList.Builder dataBuilder = new ImmutableList.Builder();
                int j = 0;
                while (j < data.length()) {
                    JSONArray row = data.getJSONArray(j);
                    ImmutableList.Builder rowBuilder = ImmutableList.builder();
                    int k = 0;
                    while (k < row.length()) {
                        Object cellObject = NonNullUtils.checkNotNull((Object)row.get(k));
                        LamiData cellValue = LamiData.createFromObject(cellObject);
                        rowBuilder.add((Object)cellValue);
                        ++k;
                    }
                    dataBuilder.add((Object)new LamiTableEntry((List<LamiData>)rowBuilder.build()));
                    ++j;
                }
                resultsBuilder.add((Object)new LamiResultTable(tr, tableClass, (Iterable<LamiTableEntry>)dataBuilder.build()));
                ++i;
            }
        }
        catch (JSONException e) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)ERROR_PARSING_EXECUTION_OUTPUT, (Object[])new Object[]{e.getMessage()});
            Status status = new Status(4, Activator.instance().getPluginId(), e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        return resultsBuilder.build();
    }

    private LamiTableClass getTableClassFromName(String tableClassName) throws JSONException {
        Map map = (Map)NonNullUtils.checkNotNull(this.fTableClasses);
        LamiTableClass tableClass = (LamiTableClass)map.get(tableClassName);
        if (tableClass == null) {
            throw new JSONException("Table class " + tableClassName + " was not declared in the metadata");
        }
        return tableClass;
    }

    @VisibleForTesting
    protected @Nullable String getOutputFromCommand(List<String> command) {
        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)LOG_RUNNING_MESSAGE, (Object[])new Object[]{COMMAND, command});
        List lines = ProcessUtils.getOutputFromCommand(command);
        if (lines == null) {
            return null;
        }
        return String.join((CharSequence)"", lines);
    }

    @VisibleForTesting
    protected String getResultsFromCommand(List<String> command, IProgressMonitor monitor) throws CoreException {
        List lines = ProcessUtils.getOutputFromCommandCancellable(command, (IProgressMonitor)monitor, (String)NonNullUtils.nullToEmptyString((Object)Messages.LamiAnalysis_MainTaskName), (ProcessUtils.OutputReaderFunction)OUTPUT_READER);
        return (String)NonNullUtils.checkNotNull((Object)String.join((CharSequence)"", lines));
    }

    public @NonNull String getName() {
        return this.fName;
    }

    public boolean isUserDefined() {
        return this.fIsUserDefined;
    }

    private static enum Features {
        VERSION_IS_SUPPORTED,
        SUPPORTED,
        OUTPUT_PROGRESS,
        TEST_COMPATIBILITY;

    }
}

