/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.incubator.analysis.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.analysis.core.model.ModelManager;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackGroupDescriptor;
import org.eclipse.tracecompass.incubator.callstack.core.flamechart.CallStack;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.CallStackDepth;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.ICalledFunction;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.CallStackHostUtils;
import org.eclipse.tracecompass.incubator.internal.callstack.core.Activator;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.InstrumentedCallStackElement;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.InstrumentedGroupDescriptor;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.CalledFunctionFactory;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class CallStackSeries
implements ISegmentStore<ISegment> {
    private final InstrumentedGroupDescriptor fRootGroup;
    private final String fName;
    private final @Nullable IThreadIdResolver fResolver;
    private final CallStackHostUtils.IHostIdResolver fHostResolver;
    private final ITmfStateSystem fStateSystem;
    private final Map<Integer, ICallStackElement> fRootElements = new HashMap<Integer, ICallStackElement>();

    public CallStackSeries(ITmfStateSystem ss, List<String[]> patternPaths, int symbolKeyLevelIndex, String name, CallStackHostUtils.IHostIdResolver hostResolver, @Nullable IThreadIdResolver threadResolver) {
        int startIndex;
        if (patternPaths.isEmpty()) {
            throw new IllegalArgumentException("State system callstack: the list of paths should not be empty");
        }
        InstrumentedGroupDescriptor prevLevel = new InstrumentedGroupDescriptor(ss, patternPaths.get(startIndex), null, symbolKeyLevelIndex == (startIndex = patternPaths.size() - 1));
        int i = startIndex - 1;
        while (i >= 0) {
            InstrumentedGroupDescriptor level;
            prevLevel = level = new InstrumentedGroupDescriptor(ss, patternPaths.get(i), prevLevel, symbolKeyLevelIndex == i);
            --i;
        }
        this.fStateSystem = ss;
        this.fRootGroup = prevLevel;
        this.fName = name;
        this.fResolver = threadResolver;
        this.fHostResolver = hostResolver;
    }

    public Collection<ICallStackElement> getRootElements() {
        return InstrumentedCallStackElement.getRootElements(this.fRootGroup, this.fHostResolver, this.fResolver, this.fRootElements);
    }

    public ICallStackGroupDescriptor getRootGroup() {
        return this.fRootGroup;
    }

    public String getName() {
        return this.fName;
    }

    public Multimap<CallStackDepth, ISegment> queryCallStacks(Collection<CallStackDepth> callstacks, Collection<Long> times) {
        ImmutableMap quarks = Maps.uniqueIndex(callstacks, cs -> cs.getQuark());
        Multimap map = (Multimap)Objects.requireNonNull(ArrayListMultimap.create());
        Collection<Long> queryTimes = CallStackSeries.getTimes(this.fStateSystem, times);
        try {
            Iterable query2d = this.fStateSystem.query2D(quarks.keySet(), queryTimes);
            for (ITmfStateInterval callInterval : query2d) {
                CallStackDepth callStackDepth = Objects.requireNonNull((CallStackDepth)quarks.get(callInterval.getAttribute()));
                if (callInterval.getValue() != null) {
                    map.put((Object)callStackDepth, (Object)callStackDepth.getCallStack().getFunctionFromInterval(callInterval));
                    continue;
                }
                map.put((Object)callStackDepth, (Object)new BasicSegment(callInterval.getStartTime(), callInterval.getEndTime() + 1L));
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            e.printStackTrace();
        }
        return map;
    }

    private static Collection<Long> getTimes(ITmfStateSystem ss, Collection<Long> times) {
        long start = ss.getStartTime();
        long end = ss.getCurrentEndTime();
        HashSet<Long> queryTimes = new HashSet<Long>();
        for (long t : times) {
            if (t < start || t > end) continue;
            queryTimes.add(t);
        }
        return queryTimes;
    }

    private Collection<ICallStackElement> getLeafElements(ICallStackElement element) {
        if (element.isLeaf()) {
            return Collections.singleton(element);
        }
        ArrayList<ICallStackElement> list = new ArrayList<ICallStackElement>();
        element.getChildrenElements().forEach(e -> {
            boolean bl = list.addAll(this.getLeafElements((ICallStackElement)e));
        });
        return list;
    }

    public int size() {
        return Iterators.size(this.iterator());
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean contains(@Nullable Object o) {
        if (o instanceof ICalledFunction) {
            ICalledFunction seg = (ICalledFunction)o;
            @NonNull Iterable iterable = this.getIntersectingElements(seg.getStart());
            return Iterables.contains((Iterable)iterable, (Object)seg);
        }
        return false;
    }

    public Iterator<ISegment> iterator() {
        ITmfStateSystem stateSystem = this.fRootGroup.getStateSystem();
        long start = stateSystem.getStartTime();
        long end = stateSystem.getCurrentEndTime();
        return this.getIntersectingElements(start, end).iterator();
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException("This segment store can potentially cause OutOfMemoryExceptions");
    }

    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("This segment store can potentially cause OutOfMemoryExceptions");
    }

    public boolean add(ISegment e) {
        throw new UnsupportedOperationException("This segment store does not support adding new segments");
    }

    public boolean containsAll(@Nullable Collection<?> c) {
        ICalledFunction seg;
        if (c == null) {
            return false;
        }
        long minEnd = Long.MAX_VALUE;
        long maxStart = Long.MIN_VALUE;
        for (Object o : c) {
            if (o instanceof ICalledFunction) {
                seg = (ICalledFunction)o;
                minEnd = Math.min(minEnd, seg.getEnd());
                maxStart = Math.max(maxStart, seg.getStart());
                continue;
            }
            return false;
        }
        if (minEnd > maxStart) {
            minEnd = maxStart;
        }
        Iterator<@NonNull ISegment> iterator = this.getIntersectingElements(minEnd, maxStart).iterator();
        int unFound = c.size();
        while (iterator.hasNext() && unFound > 0) {
            seg = iterator.next();
            for (Object o : c) {
                if (!Objects.equals(o, seg)) continue;
                --unFound;
            }
        }
        return unFound == 0;
    }

    public boolean addAll(@Nullable Collection<? extends ISegment> c) {
        throw new UnsupportedOperationException("This segment store does not support adding new segments");
    }

    public void clear() {
        throw new UnsupportedOperationException("This segment store does not support clearing the data");
    }

    private Map<Integer, CallStack> getCallStackQuarks() {
        HashMap<Integer, CallStack> quarkToElement = new HashMap<Integer, CallStack>();
        this.getRootElements().stream().flatMap(e -> this.getLeafElements((ICallStackElement)e).stream()).filter(e -> e instanceof InstrumentedCallStackElement).map(e -> (InstrumentedCallStackElement)e).forEach(e -> e.getStackQuarks().forEach(c -> {
            CallStack callStack = quarkToElement.put((Integer)c, e.getCallStack());
        }));
        return quarkToElement;
    }

    public Iterable<ISegment> getIntersectingElements(long start, long end) {
        long endTime;
        ITmfStateSystem stateSystem = this.fRootGroup.getStateSystem();
        long startTime = Math.max(Math.max(1L, start) - 1L, stateSystem.getStartTime());
        if (startTime > (endTime = Math.min(end, stateSystem.getCurrentEndTime()))) {
            return Collections.emptyList();
        }
        Map<Integer, CallStack> quarksToElement = this.getCallStackQuarks();
        try {
            Iterable query2d = stateSystem.query2D(quarksToElement.keySet(), startTime, endTime);
            query2d = Iterables.filter((Iterable)query2d, interval -> !interval.getStateValue().isNull());
            Function fct = interval -> {
                CallStack callstack = (CallStack)quarksToElement.get(interval.getAttribute());
                if (callstack == null) {
                    throw new NullPointerException("The quark was in that map in the first place, there must be a callstack to go with it!");
                }
                HostThread hostThread = callstack.getHostThread(interval.getStartTime());
                int pid = callstack.getSymbolKeyAt(interval.getStartTime());
                if (pid == -1 && hostThread != null) {
                    pid = ModelManager.getModelFor((String)hostThread.getHost()).getProcessId(hostThread.getTid().intValue(), interval.getStartTime());
                }
                if (hostThread == null) {
                    hostThread = new HostThread("", Integer.valueOf(-1));
                }
                return CalledFunctionFactory.create(interval.getStartTime(), interval.getEndTime() + 1L, interval.getValue(), pid, (int)hostThread.getTid(), null, ModelManager.getModelFor((String)hostThread.getHost()));
            };
            return Iterables.transform((Iterable)query2d, (Function)fct);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            Activator.getInstance().logError("Error getting intersecting elements: StateSystemDisposed");
            return Collections.emptyList();
        }
    }

    public void dispose() {
    }

    private static final class AttributeNameThreadProvider
    implements IThreadIdProvider {
        private final int fTid;

        public AttributeNameThreadProvider(ITmfStateSystem ss, int quark) {
            int tid = -1;
            try {
                String attributeName = ss.getAttributeName(quark);
                tid = Integer.valueOf(attributeName);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                tid = -1;
            }
            this.fTid = tid;
        }

        @Override
        public int getThreadId(long time) {
            return this.fTid;
        }

        @Override
        public boolean variesInTime() {
            return false;
        }
    }

    public static final class AttributeNameThreadResolver
    implements IThreadIdResolver {
        private int fLevel;

        public AttributeNameThreadResolver(int level) {
            this.fLevel = level;
        }

        @Override
        public @Nullable IThreadIdProvider resolve(CallStackHostUtils.IHostIdProvider hostProvider, ICallStackElement element) {
            if (!(element instanceof InstrumentedCallStackElement)) {
                throw new IllegalArgumentException();
            }
            InstrumentedCallStackElement insElement = (InstrumentedCallStackElement)element;
            ArrayList<InstrumentedCallStackElement> elements = new ArrayList<InstrumentedCallStackElement>();
            InstrumentedCallStackElement el = insElement;
            while (el != null) {
                elements.add(el);
                el = el.getParentElement();
            }
            Collections.reverse(elements);
            if (elements.size() <= this.fLevel) {
                return null;
            }
            InstrumentedCallStackElement stackElement = (InstrumentedCallStackElement)elements.get(this.fLevel);
            return new AttributeNameThreadProvider(stackElement.getStateSystem(), stackElement.getQuark());
        }
    }

    private static final class AttributeValueThreadProvider
    implements IThreadIdProvider {
        private final ITmfStateSystem fSs;
        private final int fQuark;
        private @Nullable ITmfStateInterval fInterval;
        private int fLastThreadId = -1;
        private boolean fVariesInTime = true;

        public AttributeValueThreadProvider(ITmfStateSystem ss, int quark) {
            this.fSs = ss;
            this.fQuark = quark;
            this.getThreadId(this.fSs.getStartTime());
        }

        @Override
        public int getThreadId(long time) {
            ITmfStateInterval interval = this.fInterval;
            int tid = this.fLastThreadId;
            if (interval != null && (!this.fVariesInTime || interval.intersects(time))) {
                return tid;
            }
            try {
                interval = this.fSs.querySingleState(time, this.fQuark);
                switch (interval.getStateValue().getType()) {
                    case INTEGER: {
                        tid = interval.getStateValue().unboxInt();
                        break;
                    }
                    case LONG: {
                        tid = (int)interval.getStateValue().unboxLong();
                        break;
                    }
                    case STRING: {
                        try {
                            tid = Integer.valueOf(interval.getStateValue().unboxStr());
                        }
                        catch (NumberFormatException numberFormatException) {
                            tid = -1;
                        }
                        break;
                    }
                }
                if (this.fSs.waitUntilBuilt(0L) && interval.intersects(this.fSs.getStartTime()) && interval.intersects(this.fSs.getCurrentEndTime() - 1L)) {
                    this.fVariesInTime = false;
                }
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                interval = null;
                tid = -1;
            }
            this.fInterval = interval;
            this.fLastThreadId = tid;
            return tid;
        }

        @Override
        public boolean variesInTime() {
            return this.fVariesInTime;
        }
    }

    public static final class AttributeValueThreadResolver
    implements IThreadIdResolver {
        private int fLevel;

        public AttributeValueThreadResolver(int level) {
            this.fLevel = level;
        }

        @Override
        public @Nullable IThreadIdProvider resolve(CallStackHostUtils.IHostIdProvider hostProvider, ICallStackElement element) {
            if (!(element instanceof InstrumentedCallStackElement)) {
                throw new IllegalArgumentException();
            }
            InstrumentedCallStackElement insElement = (InstrumentedCallStackElement)element;
            ArrayList<InstrumentedCallStackElement> elements = new ArrayList<InstrumentedCallStackElement>();
            InstrumentedCallStackElement el = insElement;
            while (el != null) {
                elements.add(el);
                el = el.getParentElement();
            }
            Collections.reverse(elements);
            if (elements.size() <= this.fLevel) {
                return null;
            }
            InstrumentedCallStackElement stackElement = (InstrumentedCallStackElement)elements.get(this.fLevel);
            return new AttributeValueThreadProvider(stackElement.getStateSystem(), stackElement.getQuark());
        }
    }

    public static final class CpuResolver
    implements IThreadIdResolver {
        private String[] fPath;

        public CpuResolver(String[] path) {
            this.fPath = path;
        }

        @Override
        public @Nullable IThreadIdProvider resolve(CallStackHostUtils.IHostIdProvider hostProvider, ICallStackElement element) {
            if (!(element instanceof InstrumentedCallStackElement)) {
                throw new IllegalArgumentException();
            }
            InstrumentedCallStackElement insElement = (InstrumentedCallStackElement)element;
            return new CpuThreadProvider(hostProvider, insElement.getStateSystem(), insElement.getQuark(), this.fPath);
        }
    }

    private static final class CpuThreadProvider
    implements IThreadIdProvider {
        private final ITmfStateSystem fSs;
        private final int fCpuQuark;
        private final CallStackHostUtils.IHostIdProvider fHostProvider;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public CpuThreadProvider(CallStackHostUtils.IHostIdProvider hostProvider, ITmfStateSystem ss, int quark, String[] path) {
            this.fSs = ss;
            this.fHostProvider = hostProvider;
            @NonNull List quarks = ss.getQuarks(quark, path);
            this.fCpuQuark = quarks.isEmpty() ? -2 : (Integer)quarks.get(0);
        }

        @Override
        public int getThreadId(long time) {
            ITmfStateInterval querySingleState;
            block4: {
                if (this.fCpuQuark == -2) {
                    return -1;
                }
                try {
                    querySingleState = this.fSs.querySingleState(time, this.fCpuQuark);
                    if (!querySingleState.getStateValue().isNull()) break block4;
                    return -1;
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    return -1;
                }
            }
            int cpu = querySingleState.getStateValue().unboxInt();
            long startTime = querySingleState.getStartTime();
            IHostModel model = ModelManager.getModelFor((String)((String)this.fHostProvider.apply(startTime)));
            return model.getThreadOnCpu(cpu, startTime);
        }

        @Override
        public boolean variesInTime() {
            return true;
        }
    }

    public static interface IThreadIdProvider {
        public int getThreadId(long var1);

        public boolean variesInTime();
    }

    public static interface IThreadIdResolver {
        public @Nullable IThreadIdProvider resolve(CallStackHostUtils.IHostIdProvider var1, ICallStackElement var2);
    }
}

