/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.format;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;

public final class SubSecondTimeWithUnitFormat
extends Format {
    private static final @NonNull Format INSTANCE = new SubSecondTimeWithUnitFormat();
    private static final long serialVersionUID = -5147827135781459548L;
    private static final Pattern UNIT_PATTERN = Pattern.compile("^[\\s]*([nmu\u00b5]?s)");
    private static final String SECONDS = "s";
    private static final String NANOSECONDS = "ns";
    private static final String MILLISECONDS = "ms";
    private static final String MICROSECONDS = "\u00b5s";
    private static final String MICROSECONDS_FORMAT = "us";
    private static final int NANOS_PER_SEC = 1000000000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int NANOS_PER_MICRO = 1000;
    private final DecimalFormat fDecimalFormat = new DecimalFormat("#.###");

    protected SubSecondTimeWithUnitFormat() {
    }

    public static @NonNull Format getInstance() {
        return INSTANCE;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        Number number = NumberFormat.getInstance().parse(source, pos);
        if (number == null) {
            return null;
        }
        String remaining = source.substring(pos.getIndex()).toLowerCase();
        Matcher matcher = UNIT_PATTERN.matcher(remaining);
        long multiplier = 1L;
        if (matcher.find()) {
            String unitString = matcher.group();
            String prefix = matcher.group(1);
            if (prefix.equals(SECONDS)) {
                multiplier = 1000000000L;
            } else if (prefix.equals(MILLISECONDS)) {
                multiplier = 1000000L;
            } else if (prefix.equals(MICROSECONDS)) {
                multiplier = 1000L;
            } else if (prefix.equals(MICROSECONDS_FORMAT)) {
                multiplier = 1000L;
            }
            pos.setIndex(pos.getIndex() + unitString.length());
        }
        if (multiplier != 1L && Double.isFinite(number.doubleValue())) {
            BigDecimal bd = new BigDecimal(number.toString());
            if ((bd = bd.multiply(BigDecimal.valueOf(multiplier))).abs().compareTo(new BigDecimal(Long.MAX_VALUE)) < 0) {
                return bd.longValue();
            }
            return bd.doubleValue();
        }
        return number;
    }

    @Override
    public StringBuffer format(@Nullable Object obj, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
        StringBuffer appender = toAppendTo;
        if (obj != null && obj instanceof Number) {
            double formattedTime = ((Number)obj).doubleValue();
            if (Double.isNaN(formattedTime)) {
                return appender == null ? new StringBuffer() : NonNullUtils.checkNotNull(appender.append("---"));
            }
            String unit = NANOSECONDS;
            double absFormattedTime = Math.abs(formattedTime);
            if (absFormattedTime >= 1.0E9) {
                unit = SECONDS;
                formattedTime /= 1.0E9;
            } else if (absFormattedTime >= 1000000.0) {
                unit = MILLISECONDS;
                formattedTime /= 1000000.0;
            } else if (absFormattedTime >= 1000.0) {
                unit = MICROSECONDS;
                formattedTime /= 1000.0;
            }
            if (formattedTime == 0.0) {
                return appender == null ? new StringBuffer() : NonNullUtils.checkNotNull(appender.append(0));
            }
            String timeString = unit.equals(NANOSECONDS) ? Long.toString((long)formattedTime) : this.fDecimalFormat.format(formattedTime);
            return appender == null ? new StringBuffer() : NonNullUtils.checkNotNull(appender.append(timeString).append(' ').append(unit));
        }
        return new StringBuffer();
    }
}

