/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceAdapterManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class TraceAnnotationProvider
implements IOutputAnnotationProvider {
    private CopyOnWriteArrayList<IOutputAnnotationProvider> fTraceAnnotations = new CopyOnWriteArrayList();

    public TraceAnnotationProvider(ITmfTrace trace) {
        this.init(trace);
    }

    private void init(ITmfTrace trace) {
        if (trace instanceof TmfExperiment) {
            @NonNull Collection<@NonNull ITmfTrace> traces = TmfTraceManager.getTraceSet(trace);
            for (ITmfTrace child : traces) {
                this.init(child);
            }
            return;
        }
        List<@NonNull IOutputAnnotationProvider> adapters = TmfTraceAdapterManager.getAdapters(trace, IOutputAnnotationProvider.class);
        this.fTraceAnnotations.addAll(adapters);
    }

    @Override
    public TmfModelResponse<AnnotationCategoriesModel> fetchAnnotationCategories(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        AnnotationCategoriesModel model = new AnnotationCategoriesModel(Collections.emptyList());
        for (IOutputAnnotationProvider dataProvider : this.fTraceAnnotations) {
            TmfModelResponse<AnnotationCategoriesModel> response = dataProvider.fetchAnnotationCategories(fetchParameters, monitor);
            model = AnnotationCategoriesModel.of(model, response.getModel());
        }
        if (model.getAnnotationCategories().isEmpty()) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<AnnotationCategoriesModel>(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    @Override
    public TmfModelResponse<AnnotationModel> fetchAnnotations(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        boolean isComplete = true;
        AnnotationModel model = new AnnotationModel(Collections.emptyMap());
        for (IOutputAnnotationProvider dataProvider : this.fTraceAnnotations) {
            TmfModelResponse<AnnotationModel> response = dataProvider.fetchAnnotations(fetchParameters, monitor);
            isComplete &= response.getStatus() == ITmfResponse.Status.COMPLETED;
            model = AnnotationModel.of(model, response.getModel());
            if (monitor == null || !monitor.isCanceled()) continue;
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        if (isComplete) {
            return new TmfModelResponse<AnnotationModel>(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<AnnotationModel>(model, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }
}

