/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.traceevent.core.trace;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.Activator;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.TraceEventAspects;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.TraceEventEvent;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.TraceEventField;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.trace.TraceEventSortingJob;
import org.eclipse.tracecompass.internal.provisional.jsontrace.core.trace.JsonTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public class TraceEventTrace
extends JsonTrace {
    private static final String TID_PREFIX = "tid-";
    private static final String PID_LABEL_PREFIX = "pidLabel-";
    private static final String PID_PREFIX = "pid-";
    private static final String NAME_ARG = "name";
    private static final String LABELS = "labels";
    private static final String SORT_INDEX = "sort_index";
    private static final String PROCESS_NAME = "process_name";
    private static final String PROCESS_LABELS = "process_labels";
    private static final String PROCESS_SORT_INDEX = "process_sort_index";
    private static final String THREAD_NAME = "thread_name";
    private static final String THREAD_SORT_INDEX = "thread_sort_index";
    private final @NonNull Map<Object, String> fPidNames = new HashMap<Object, String>();
    private final @NonNull NavigableMap<Integer, String> fTidNames = new TreeMap<Integer, String>();
    private final @NonNull Iterable<@NonNull ITmfEventAspect<?>> fEventAspects;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public TraceEventTrace() {
        @NonNull ArrayList aspects = Lists.newArrayList(TraceEventAspects.getAspects());
        aspects.add(new ProcessNameAspect());
        aspects.add(new ThreadNameAspect());
        this.fEventAspects = aspects;
    }

    public IStatus validate(IProject project, String path) {
        File file = new File(path);
        if (!file.exists()) {
            return new Status(4, "org.eclipse.tracecompass.incubator.traceevent.core", "File not found: " + path);
        }
        if (!file.isFile()) {
            return new Status(4, "org.eclipse.tracecompass.incubator.traceevent.core", "Not a file. It's a directory: " + path);
        }
        int confidence = 0;
        try {
            if (!TmfTraceUtils.isText((File)file)) {
                return new Status(4, "org.eclipse.tracecompass.incubator.traceevent.core", "Trace events are text only");
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
            return new Status(4, "org.eclipse.tracecompass.incubator.traceevent.core", "IOException validating file: " + path, (Throwable)e);
        }
        try {
            Throwable e = null;
            Object var6_9 = null;
            try (BufferedRandomAccessFile rafile = new BufferedRandomAccessFile(path, "r");){
                TraceEventTrace.goToCorrectStart((RandomAccessFile)rafile);
                int lineCount = 0;
                int matches = 0;
                String line = TraceEventTrace.readNextEventString(() -> rafile.read());
                while (line != null && lineCount++ < 100) {
                    try {
                        TraceEventField field = TraceEventField.parseJson(line);
                        if (field != null) {
                            ++matches;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        confidence = Integer.MIN_VALUE;
                    }
                    confidence = 100 * matches / lineCount;
                    line = TraceEventTrace.readNextEventString(() -> rafile.read());
                }
                if (matches == 0) {
                    return new Status(4, "org.eclipse.tracecompass.incubator.traceevent.core", "Most assuredly NOT a Trace-Event trace");
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
            return new Status(4, "org.eclipse.tracecompass.incubator.traceevent.core", "IOException validating file: " + path, (Throwable)e);
        }
        return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.incubator.traceevent.core");
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        super.initTrace(resource, path, type);
        this.fProperties.put("Type", "Trace-Event");
        String dir = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)this);
        this.fFile = new File(String.valueOf(dir) + new File(path).getName());
        if (!this.fFile.exists()) {
            TraceEventSortingJob sortJob = new TraceEventSortingJob((ITmfTrace)this, path);
            sortJob.schedule();
            while (sortJob.getResult() == null) {
                try {
                    sortJob.join();
                }
                catch (InterruptedException e) {
                    throw new TmfTraceException(e.getMessage(), (Throwable)e);
                }
            }
            IStatus result = sortJob.getResult();
            if (!result.isOK()) {
                throw new TmfTraceException("Job failed " + result.getMessage());
            }
        }
        try {
            this.fFileInput = new BufferedRandomAccessFile(this.fFile, "r");
            TraceEventTrace.goToCorrectStart(this.fFileInput);
            ITmfContext ctx = this.seekEvent(0L);
            if (ctx == null) {
                return;
            }
            ITmfEvent event = this.getNext(ctx);
            if (event != null) {
                ITmfTimestamp curTime = event.getTimestamp();
                this.setStartTime(curTime);
                this.setEndTime(curTime);
            }
            ctx.dispose();
        }
        catch (IOException e) {
            throw new TmfTraceException(e.getMessage(), (Throwable)e);
        }
    }

    protected static void goToCorrectStart(RandomAccessFile rafile) throws IOException {
        String traceEventsKey = "\"traceEvents\"";
        StringBuilder sb = new StringBuilder();
        int val = rafile.read();
        HashSet<Integer> skipList = new HashSet<Integer>();
        skipList.add(58);
        skipList.add(9);
        skipList.add(10);
        skipList.add(13);
        skipList.add(32);
        skipList.add(8);
        skipList.add(12);
        while (val != -1 && val != 58 && sb.length() < 14) {
            if (!skipList.contains(val)) {
                sb.append((char)val);
            }
            val = rafile.read();
        }
        if (!sb.toString().startsWith(String.valueOf('{') + traceEventsKey) || rafile.length() <= 14L) {
            rafile.seek(0L);
        }
    }

    public Iterable<@NonNull ITmfEventAspect<?>> getEventAspects() {
        return this.fEventAspects;
    }

    public ITmfEvent parseEvent(ITmfContext context) {
        @Nullable ITmfLocation location = context.getLocation();
        if (location instanceof TmfLongLocation) {
            TmfLongLocation tmfLongLocation = (TmfLongLocation)location;
            Long locationInfo = tmfLongLocation.getLocationInfo();
            if (location.equals(NULL_LOCATION)) {
                locationInfo = 0L;
            }
            if (locationInfo != null) {
                try {
                    if (!locationInfo.equals(this.fFileInput.getFilePointer())) {
                        this.fFileInput.seek(locationInfo);
                    }
                    String nextJson = TraceEventTrace.readNextEventString(() -> this.fFileInput.read());
                    while (nextJson != null) {
                        TraceEventField field = TraceEventField.parseJson(nextJson);
                        if (field == null) {
                            nextJson = TraceEventTrace.readNextEventString(() -> this.fFileInput.read());
                            continue;
                        }
                        if (field.getPhase() != 'M') {
                            return new TraceEventEvent((ITmfTrace)this, context.getRank(), field);
                        }
                        this.parseMetadata(field);
                        nextJson = TraceEventTrace.readNextEventString(() -> this.fFileInput.read());
                    }
                }
                catch (IOException e) {
                    Activator.getInstance().logError("Error parsing event", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void parseMetadata(TraceEventField field) {
        Map<@NonNull String, @NonNull Object> args = field.getArgs();
        String name = field.getName();
        if (args == null) {
            return;
        }
        @NonNull @NonNull Map properties = this.fProperties;
        switch (name) {
            case "process_name": {
                String procName = (String)args.get(NAME_ARG);
                this.fPidNames.put(field.getPid(), procName);
                if (procName == null) break;
                properties.put(PID_PREFIX + field.getPid(), procName);
                break;
            }
            case "process_labels": {
                String procLabels = (String)args.get(LABELS);
                if (procLabels == null) break;
                properties.put(PID_LABEL_PREFIX + field.getPid(), procLabels);
                break;
            }
            case "process_sort_index": {
                String sortIndex = (String)args.get(SORT_INDEX);
                if (sortIndex == null) break;
                properties.put(String.valueOf(name) + '-' + field.getPid(), sortIndex);
                break;
            }
            case "thread_name": {
                String threadName = (String)args.get(NAME_ARG);
                this.fTidNames.put(field.getTid(), threadName);
                if (threadName == null) break;
                properties.put(TID_PREFIX + field.getTid(), threadName);
                break;
            }
            case "thread_sort_index": {
                String sortIndex = (String)args.get(SORT_INDEX);
                if (sortIndex == null) break;
                properties.put(String.valueOf(name) + '-' + field.getTid(), sortIndex);
                break;
            }
            default: {
                properties.put(name, String.valueOf(args));
            }
        }
    }

    public class ProcessNameAspect
    extends org.eclipse.tracecompass.incubator.analysis.core.aspects.ProcessNameAspect {
        public @Nullable String resolve(@NonNull ITmfEvent event) {
            TraceEventField field;
            if (event instanceof TraceEventEvent && (field = ((TraceEventEvent)event).getField()).getPid() != null) {
                return (String)TraceEventTrace.this.fPidNames.get(field.getPid());
            }
            return null;
        }
    }

    public class ThreadNameAspect
    extends org.eclipse.tracecompass.incubator.analysis.core.aspects.ThreadNameAspect {
        public @Nullable String resolve(@NonNull ITmfEvent event) {
            TraceEventField field;
            if (event instanceof TraceEventEvent && (field = ((TraceEventEvent)event).getField()).getTid() != null) {
                return (String)TraceEventTrace.this.fTidNames.get(field.getTid());
            }
            return null;
        }
    }
}

