/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.Activator;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.QueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.Experiment;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.QueryParametersUtil;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.TraceManagerService;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.TraceAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

@Path(value="/experiments")
public class ExperimentManagerService {
    private static final Map<UUID, List<UUID>> TRACE_UUIDS = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, IResource> EXPERIMENT_RESOURCES = Collections.synchronizedMap(ExperimentManagerService.initExperimentResources());
    private static final Map<UUID, TmfExperiment> EXPERIMENTS = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, TraceAnnotationProvider> TRACE_ANNOTATION_PROVIDERS = Collections.synchronizedMap(new HashMap());
    private static final String EXPERIMENTS_FOLDER = "Experiments";
    private static final String TRACES_FOLDER = "Traces";
    private static final String SUFFIX = "_exp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    public Response getExperiments() {
        Map<UUID, IResource> map = EXPERIMENT_RESOURCES;
        synchronized (map) {
            List experiments = Lists.transform(new ArrayList<Map.Entry<UUID, IResource>>(EXPERIMENT_RESOURCES.entrySet()), e -> {
                UUID expUUID = (UUID)e.getKey();
                TmfExperiment experiment = EXPERIMENTS.get(expUUID);
                if (experiment != null) {
                    return Experiment.from(experiment, expUUID);
                }
                IResource experimentResource = (IResource)e.getValue();
                return Experiment.from(experimentResource, expUUID);
            });
            return Response.ok((Object)experiments).build();
        }
    }

    private static Map<UUID, IResource> initExperimentResources() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        HashMap<UUID, IResource> experimentResources = new HashMap<UUID, IResource>();
        try {
            project.refreshLocal(2, null);
            IFolder experimentsFolder = project.getFolder(EXPERIMENTS_FOLDER);
            experimentsFolder.accept(resource -> {
                if (resource.equals((Object)experimentsFolder)) {
                    return true;
                }
                if (resource instanceof IFolder) {
                    UUID expUUID = UUID.nameUUIDFromBytes(Objects.requireNonNull(resource.getName().getBytes(Charset.defaultCharset())));
                    experimentResources.put(expUUID, resource);
                    List<UUID> traceUUIDs = ExperimentManagerService.getTraceUUIDs((IFolder)resource);
                    TRACE_UUIDS.put(expUUID, traceUUIDs);
                }
                return false;
            }, 1, 0);
        }
        catch (CoreException coreException) {}
        return experimentResources;
    }

    private static List<UUID> getTraceUUIDs(IFolder experimentResource) throws CoreException {
        ArrayList<UUID> traceUUIDs = new ArrayList<UUID>();
        experimentResource.accept(resource -> {
            if (resource instanceof IFile) {
                IPath path = resource.getProjectRelativePath().makeRelativeTo(experimentResource.getProjectRelativePath());
                IResource traceResource = experimentResource.getProject().getFolder(TRACES_FOLDER).findMember(path);
                if (traceResource != null) {
                    traceUUIDs.add(TraceManagerService.getTraceUUID(traceResource));
                }
                return false;
            }
            return true;
        });
        return traceUUIDs;
    }

    @GET
    @Path(value="/{expUUID}")
    @Produces(value={"application/json"})
    public Response getExperiment(@PathParam(value="expUUID") UUID expUUID) {
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment != null) {
            return Response.ok((Object)Experiment.from(experiment, expUUID)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{expUUID}/outputs")
    @Produces(value={"application/json"})
    public Response getOutputs(@PathParam(value="expUUID") UUID expUUID) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)("Not implemented for " + expUUID)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{expUUID}")
    @Produces(value={"application/json"})
    public Response deleteExperiment(@PathParam(value="expUUID") UUID expUUID) {
        IResource resource = EXPERIMENT_RESOURCES.remove(expUUID);
        if (resource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Experiment experimentModel = Experiment.from(resource, expUUID);
        TmfExperiment experiment = EXPERIMENTS.remove(expUUID);
        if (experiment != null) {
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceClosedSignal((Object)this, (ITmfTrace)experiment));
            experiment.dispose();
        }
        TRACE_ANNOTATION_PROVIDERS.remove(expUUID);
        TRACE_UUIDS.remove(expUUID);
        boolean deleteResources = true;
        Map<UUID, TmfExperiment> map = EXPERIMENTS;
        synchronized (map) {
            for (TmfExperiment e : EXPERIMENTS.values()) {
                if (!resource.equals((Object)e.getResource())) continue;
                deleteResources = false;
                break;
            }
        }
        if (deleteResources) {
            try {
                File supplFolder = new File(resource.getPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER));
                FileUtils.cleanDirectory((File)supplFolder);
                supplFolder.delete();
                resource.delete(true, null);
                resource.getProject().refreshLocal(Integer.MAX_VALUE, null);
            }
            catch (IOException | CoreException e) {
                Activator.getInstance().logError("Failed to delete experiment", e);
            }
        }
        return Response.ok((Object)experimentModel).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postExperiment(QueryParameters queryParameters) {
        IFolder resource;
        if (queryParameters == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing query parameters").build();
        }
        Map<String, Object> parameters = queryParameters.getParameters();
        String errorMessage = QueryParametersUtil.validateExperimentQueryParameters(parameters);
        if (errorMessage != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        String name = Objects.requireNonNull((String)parameters.get("name"));
        List tracesObj = Objects.requireNonNull((List)parameters.get("traces"));
        ArrayList<UUID> traceUUIDs = new ArrayList<UUID>();
        ArrayList<IResource> traceResources = new ArrayList<IResource>();
        for (Object uuidObj : tracesObj) {
            if (!(uuidObj instanceof String)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            UUID uuid = UUID.fromString((String)uuidObj);
            IResource traceResource = TraceManagerService.getTraceResource(uuid);
            if (traceResource == null) {
                return Response.noContent().build();
            }
            traceResources.add(traceResource);
            traceUUIDs.add(uuid);
        }
        UUID expUUID = UUID.nameUUIDFromBytes(Objects.requireNonNull(name.getBytes(Charset.defaultCharset())));
        try {
            resource = ExperimentManagerService.getExperimentResource(name);
            if (resource.exists()) {
                HashMultiset newTraceResources;
                HashMultiset oldTraceResources = HashMultiset.create(ExperimentManagerService.getTraceResources(resource));
                if (!oldTraceResources.equals((Object)(newTraceResources = HashMultiset.create(traceResources)))) {
                    TmfExperiment oldExperiment = new TmfExperiment(ITmfEvent.class, resource.getLocation().toOSString(), new ITmfTrace[0], 5000, (IResource)resource);
                    Experiment entity = Experiment.from(oldExperiment, expUUID);
                    oldExperiment.dispose();
                    return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)entity).build();
                }
                TmfExperiment experiment = EXPERIMENTS.get(expUUID);
                if (experiment != null) {
                    return Response.ok((Object)Experiment.from(experiment, expUUID)).build();
                }
            } else {
                ExperimentManagerService.createExperiment(resource, traceResources);
            }
        }
        catch (CoreException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        TRACE_UUIDS.put(expUUID, traceUUIDs);
        EXPERIMENT_RESOURCES.put(expUUID, (IResource)resource);
        TmfExperiment experiment = ExperimentManagerService.createExperimentInstance(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Failed to instantiate experiment").build();
        }
        return Response.ok((Object)Experiment.from(experiment, expUUID)).build();
    }

    private static @Nullable TmfExperiment createExperimentInstance(UUID expUUID) {
        List<UUID> traceUUIDs = TRACE_UUIDS.get(expUUID);
        IResource resource = EXPERIMENT_RESOURCES.get(expUUID);
        if (traceUUIDs == null || resource == null) {
            return null;
        }
        ExperimentManagerService.createSupplementaryFolder(resource);
        ITmfTrace[] traces = Lists.transform(traceUUIDs, uuid -> TraceManagerService.createTraceInstance(uuid)).toArray(new ITmfTrace[0]);
        int cacheSize = Integer.MAX_VALUE;
        ITmfTrace[] iTmfTraceArray = traces;
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            cacheSize = Math.min(cacheSize, trace.getCacheSize());
            ++n2;
        }
        TmfExperiment experiment = new TmfExperiment(ITmfEvent.class, resource.getLocation().toOSString(), traces, cacheSize, resource);
        experiment.indexTrace(false);
        ITmfContext ctx = experiment.seekEvent(0L);
        experiment.getNext(ctx);
        ctx.dispose();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal(ExperimentManagerService.class, (ITmfTrace)experiment, null));
        EXPERIMENTS.put(expUUID, experiment);
        TRACE_ANNOTATION_PROVIDERS.put(expUUID, new TraceAnnotationProvider((ITmfTrace)experiment));
        return experiment;
    }

    private static IFolder getExperimentResource(String name) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        project.refreshLocal(2, null);
        IFolder experimentsFolder = project.getFolder(EXPERIMENTS_FOLDER);
        return experimentsFolder.getFolder(name);
    }

    private static List<IResource> getTraceResources(final IFolder folder) {
        final ArrayList<IResource> list = new ArrayList<IResource>();
        final IFolder tracesFolder = folder.getProject().getFolder(TRACES_FOLDER);
        try {
            folder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy resource) throws CoreException {
                    if (resource.getType() == 1) {
                        IResource traceResourceUnderExperiment = resource.requestResource();
                        IPath relativePath = traceResourceUnderExperiment.getProjectRelativePath().makeRelativeTo(folder.getProjectRelativePath());
                        IResource traceResource = tracesFolder.findMember(relativePath);
                        if (traceResource != null) {
                            list.add(traceResource);
                        }
                        return false;
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException coreException) {}
        list.sort(Comparator.comparing(resource -> resource.getFullPath().toString()));
        return list;
    }

    private static void createExperiment(IFolder folder, List<IResource> traceResources) throws CoreException {
        ExperimentManagerService.createFolder(folder);
        for (IResource traceResource : traceResources) {
            ExperimentManagerService.addTrace(folder, traceResource);
        }
        folder.setPersistentProperty(TmfCommonConstants.TRACETYPE, "org.eclipse.linuxtools.tmf.core.experiment.generic");
    }

    private static void addTrace(IFolder folder, IResource traceResource) throws CoreException {
        IPath relativePath = traceResource.getProjectRelativePath().removeFirstSegments(1);
        IFile file = folder.getFile(relativePath);
        ExperimentManagerService.createFolder((IFolder)file.getParent());
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new NullProgressMonitor());
        file.setPersistentProperty(TmfCommonConstants.TRACETYPE, TmfTraceType.getTraceTypeId((IResource)traceResource));
    }

    private static void createSupplementaryFolder(IResource experimentResource) {
        try {
            IFolder supplRootFolder = experimentResource.getProject().getFolder(".tracing");
            IFolder supplFolder = supplRootFolder.getFolder(String.valueOf(experimentResource.getName()) + SUFFIX);
            ExperimentManagerService.createFolder(supplFolder);
            experimentResource.setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, supplFolder.getLocation().toOSString());
        }
        catch (CoreException coreException) {}
    }

    private static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                ExperimentManagerService.createFolder((IFolder)folder.getParent());
            }
            folder.create(true, true, null);
        }
    }

    public static synchronized @Nullable TmfExperiment getExperimentByUUID(UUID expUUID) {
        TmfExperiment experiment = EXPERIMENTS.get(expUUID);
        if (experiment == null) {
            experiment = ExperimentManagerService.createExperimentInstance(expUUID);
        }
        return experiment;
    }

    public static List<UUID> getTraceUUIDs(UUID expUUID) {
        return TRACE_UUIDS.getOrDefault(expUUID, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTraceInUse(UUID uuid) {
        Map<UUID, List<UUID>> map = TRACE_UUIDS;
        synchronized (map) {
            return TRACE_UUIDS.values().stream().anyMatch(traceUUIDs -> traceUUIDs.contains(uuid));
        }
    }

    public static TraceAnnotationProvider getTraceAnnotationProvider(UUID uuid) {
        return TRACE_ANNOTATION_PROVIDERS.get(uuid);
    }

    public static void dispose() {
        for (TmfExperiment experiment : EXPERIMENTS.values()) {
            if (experiment == null) continue;
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceClosedSignal((Object)experiment, (ITmfTrace)experiment));
            experiment.dispose();
        }
        EXPERIMENTS.clear();
        TRACE_UUIDS.clear();
        EXPERIMENT_RESOURCES.clear();
        TRACE_ANNOTATION_PROVIDERS.clear();
    }
}

