/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.ast.tag;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.tag.IBindingTagger;
import org.eclipse.cdt.core.dom.ast.tag.ITag;
import org.eclipse.cdt.core.dom.ast.tag.ITagReader;
import org.eclipse.cdt.core.dom.ast.tag.ITagWriter;
import org.eclipse.cdt.internal.core.dom.ast.tag.TaggerDescriptor;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.tag.PDOMTaggable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class TagManager {
    private static final String EXTENSION_POINT = "tagger";
    private static TagManager INSTANCE;
    private Map<String, TaggerDescriptor> taggers = TagManager.loadExtensions();

    public static TagManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TagManager();
        }
        return INSTANCE;
    }

    private TagManager() {
    }

    private static Map<String, TaggerDescriptor> loadExtensions() {
        IConfigurationElement[] elements;
        HashMap<String, TaggerDescriptor> taggers = new HashMap<String, TaggerDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.core", EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            TaggerDescriptor desc = new TaggerDescriptor(element);
            taggers.put(desc.getId(), desc);
            ++n2;
        }
        return taggers;
    }

    public ITag process(String taggerId, ITagWriter tagWriter, IBinding binding, IASTName ast) {
        TaggerDescriptor desc = this.taggers.get(taggerId);
        if (desc == null) {
            return null;
        }
        IBindingTagger tagger = desc.getBindingTaggerFor(binding, ast);
        return tagger == null ? null : tagger.process(tagWriter, binding, ast);
    }

    public Iterable<ITag> process(ITagWriter tagWriter, IBinding binding, IASTName ast) {
        LinkedList<ITag> tags = new LinkedList<ITag>();
        for (TaggerDescriptor desc : this.taggers.values()) {
            ITag tag;
            IBindingTagger tagger = desc.getBindingTaggerFor(binding, ast);
            if (tagger == null || (tag = tagger.process(tagWriter, binding, ast)) == null) continue;
            tags.add(tag);
        }
        return tags;
    }

    public void syncTags(IPDOMBinding dst, IBinding src) {
        if (dst == null || this.taggers.isEmpty()) {
            return;
        }
        ITagReader tagReader = CCorePlugin.getTagService().findTagReader(src);
        if (tagReader == null) {
            return;
        }
        PDOMTaggable tagWriter = new PDOMTaggable(dst.getPDOM(), dst.getRecord());
        tagWriter.setTags(tagReader.getTags());
    }
}

