/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.counters.core.aspects;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.counters.core.CounterType;
import org.eclipse.tracecompass.analysis.counters.core.aspects.ITmfCounterAspect;
import org.eclipse.tracecompass.internal.analysis.counters.core.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public abstract class AbstractCounterAspect
implements ITmfCounterAspect {
    private final String fFieldName;
    private final String fLabel;
    private final CounterType fType;

    public AbstractCounterAspect(String fieldName, String label) {
        this.fFieldName = fieldName;
        this.fLabel = label;
        this.fType = CounterType.LONG;
    }

    public AbstractCounterAspect(String fieldName, String label, CounterType type) {
        this.fFieldName = fieldName;
        this.fLabel = label;
        this.fType = type;
    }

    public @NonNull String getName() {
        return this.fLabel;
    }

    public @NonNull String getHelpText() {
        return String.valueOf(Messages.CounterAspect_HelpPrefix) + ' ' + this.getName();
    }

    public @Nullable Number resolve(@NonNull ITmfEvent event) {
        switch (this.fType) {
            case DOUBLE: {
                return (Number)event.getContent().getFieldValue(Double.class, new String[]{this.fFieldName});
            }
            case LONG: {
                return (Number)event.getContent().getFieldValue(Long.class, new String[]{this.fFieldName});
            }
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ' ' + this.fFieldName;
    }

    public int hashCode() {
        return Objects.hash(this.fFieldName, this.fLabel);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCounterAspect other = (AbstractCounterAspect)obj;
        return Objects.equals(this.fFieldName, other.fFieldName) && Objects.equals(this.fLabel, other.fLabel);
    }

    public CounterType getType() {
        return this.fType;
    }
}

