/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.InjecteeImpl;
import org.glassfish.hk2.utilities.cache.Cache;
import org.glassfish.hk2.utilities.cache.Computable;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Singleton
class DelegatedInjectionValueFactoryProvider
implements ValueFactoryProvider {
    private final ContextInjectionResolver resolver;
    static final Cache<Parameter, ActiveDescriptor> descriptorCache = new Cache((Computable)new Computable<Parameter, ActiveDescriptor>(){

        public ActiveDescriptor compute(Parameter parameter) {
            Class<?> rawType = parameter.getRawType();
            if (rawType.isInterface() && !(parameter.getType() instanceof ParameterizedType)) {
                return DelegatedInjectionValueFactoryProvider.createDescriptor(rawType);
            }
            return null;
        }
    });

    @Inject
    public DelegatedInjectionValueFactoryProvider(ServiceLocator locator) {
        ContextInjectionResolver result = null;
        for (InjectionResolver r : Providers.getProviders((ServiceLocator)locator, InjectionResolver.class)) {
            if (!ContextInjectionResolver.class.isInstance(r)) continue;
            result = (ContextInjectionResolver)ContextInjectionResolver.class.cast(r);
            break;
        }
        this.resolver = result;
    }

    @Override
    public Factory<?> getValueFactory(Parameter parameter) {
        Parameter.Source paramSource = parameter.getSource();
        if (paramSource == Parameter.Source.CONTEXT) {
            final Injectee effectiveInjectee = DelegatedInjectionValueFactoryProvider.getInjectee(parameter);
            return new Factory<Object>(){

                public Object provide() {
                    return DelegatedInjectionValueFactoryProvider.this.resolver.resolve(effectiveInjectee, null);
                }

                public void dispose(Object instance) {
                }
            };
        }
        return null;
    }

    @Override
    public ValueFactoryProvider.PriorityType getPriority() {
        return ValueFactoryProvider.Priority.LOW;
    }

    private static Injectee getInjectee(final Parameter parameter) {
        return new InjecteeImpl(){
            private final Class<?> rawType;
            {
                this.rawType = parameter.getRawType();
                this.setRequiredType(parameter.getType());
                this.setRequiredQualifiers(Collections.emptySet());
                ActiveDescriptor proxyDescriptor = (ActiveDescriptor)descriptorCache.compute((Object)parameter);
                if (proxyDescriptor != null) {
                    this.setInjecteeDescriptor(proxyDescriptor);
                }
            }

            public Class<?> getInjecteeClass() {
                return this.rawType;
            }
        };
    }

    private static <T> AbstractActiveDescriptor<T> createDescriptor(final Class<T> clazz) {
        return new AbstractActiveDescriptor<T>(){

            public Class<T> getImplementationClass() {
                return clazz;
            }

            public T create(ServiceHandle sh) {
                return null;
            }

            public Boolean isProxyForSameScope() {
                return false;
            }

            public synchronized String getScope() {
                return RequestScoped.class.getName();
            }
        };
    }
}

