/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsExecutionGraphProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsInterruptContext;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsSystemModel;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.BaseHandler;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class TraceEventHandlerExecutionGraph
extends BaseHandler {
    private static final int IRQ_TIMER = 0;
    private static final NullProgressMonitor DEFAULT_PROGRESS_MONITOR = new NullProgressMonitor();
    private final Table<String, Integer, OsWorker> fKernel;
    private final IMatchProcessingUnit fMatchProcessing;
    private Map<TmfEventDependency.DependencyEvent, ITmfVertex> fTcpNodes;
    private TmfEventMatching fTcpMatching;
    private Map<OsWorker, Pair<ITmfVertex, ITmfVertex>> fLatestReceivedNetworkLink = new HashMap<OsWorker, Pair<ITmfVertex, ITmfVertex>>();

    public TraceEventHandlerExecutionGraph(OsExecutionGraphProvider provider, int priority) {
        super(provider, priority);
        this.fKernel = HashBasedTable.create();
        this.fTcpNodes = new HashMap<TmfEventDependency.DependencyEvent, ITmfVertex>();
        this.fMatchProcessing = new IMatchProcessingUnit(){

            public void matchingEnded() {
            }

            public int countMatches() {
                return 0;
            }

            public void addMatch(@Nullable TmfEventDependency match) {
                if (match == null) {
                    return;
                }
                ITmfGraph graph = (ITmfGraph)NonNullUtils.checkNotNull((Object)TraceEventHandlerExecutionGraph.this.getProvider().getGraph());
                ITmfVertex output = (ITmfVertex)TraceEventHandlerExecutionGraph.this.fTcpNodes.remove(match.getSource());
                ITmfVertex input = (ITmfVertex)TraceEventHandlerExecutionGraph.this.fTcpNodes.remove(match.getDestination());
                if (output != null && input != null) {
                    TraceEventHandlerExecutionGraph.this.fLatestReceivedNetworkLink.put((OsWorker)graph.getParentOf(input), new Pair((Object)output, (Object)input));
                }
            }

            public void init(Collection<ITmfTrace> fTraces) {
            }
        };
        ITmfTrace trace = provider.getTrace();
        this.fTcpMatching = new TmfEventMatching(Collections.singleton(trace), this.fMatchProcessing);
        this.fTcpMatching.initMatching();
    }

    private OsWorker getOrCreateKernelWorker(ITmfEvent event, Integer cpu) {
        String host = event.getTrace().getHostId();
        OsWorker worker = (OsWorker)this.fKernel.get((Object)host, (Object)cpu);
        if (worker == null) {
            HostThread ht = new HostThread(host, Integer.valueOf(-1));
            worker = new OsWorker(ht, "kernel/" + cpu, event.getTimestamp().getValue());
            worker.setStatus(ProcessStatus.RUN);
            this.fKernel.put((Object)host, (Object)cpu, (Object)worker);
        }
        return worker;
    }

    @Override
    public void handleEvent(ITmfEvent ev) {
        IKernelAnalysisEventLayout eventLayout;
        String eventName = ev.getName();
        if (eventName.equals((eventLayout = this.getProvider().getEventLayout(ev.getTrace())).eventSchedSwitch())) {
            this.handleSchedSwitch(ev);
        } else if (eventName.equals(eventLayout.eventSoftIrqEntry())) {
            this.handleSoftirqEntry(ev);
        } else if (eventLayout.eventsNetworkReceive().contains(eventName) || eventName.equals("inet_sock_local_in")) {
            this.handleInetSockLocalIn(ev);
        } else if (eventLayout.eventsNetworkSend().contains(eventName) || eventName.equals("inet_sock_local_out")) {
            this.handleInetSockLocalOut(ev);
        } else if (this.isWakeupEvent(ev)) {
            this.handleSchedWakeup(ev);
        }
    }

    private ITmfVertex stateExtend(OsWorker task, long ts) {
        ITmfGraph graph = (ITmfGraph)NonNullUtils.checkNotNull((Object)this.getProvider().getGraph());
        ITmfVertex node = graph.createVertex((IGraphWorker)task, ts);
        ProcessStatus status = task.getStatus();
        this.appendInGraph(graph, task, node, TraceEventHandlerExecutionGraph.resolveProcessStatus(status), null);
        return node;
    }

    private ITmfVertex stateChange(OsWorker task, long ts) {
        ITmfGraph graph = (ITmfGraph)NonNullUtils.checkNotNull((Object)this.getProvider().getGraph());
        ITmfVertex node = graph.createVertex((IGraphWorker)task, ts);
        ProcessStatus status = task.getOldStatus();
        this.appendInGraph(graph, task, node, TraceEventHandlerExecutionGraph.resolveProcessStatus(status), null);
        return node;
    }

    private static ITmfEdgeContextState resolveProcessStatus(ProcessStatus status) {
        OSEdgeContextState ret = new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.UNKNOWN);
        switch (status) {
            case NOT_ALIVE: {
                break;
            }
            case EXIT: 
            case RUN: 
            case RUN_SYTEMCALL: 
            case INTERRUPTED: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.RUNNING);
                break;
            }
            case UNKNOWN: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.UNKNOWN);
                break;
            }
            case WAIT_BLOCKED: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.BLOCKED);
                break;
            }
            case WAIT_FORK: 
            case WAIT_CPU: 
            case WAIT_UNKNOWN: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.PREEMPTED);
                break;
            }
            case ZOMBIE: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.UNKNOWN);
                break;
            }
        }
        return ret;
    }

    private void handleSchedSwitch(ITmfEvent event) {
        String host = event.getTrace().getHostId();
        long ts = event.getTimestamp().getValue();
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        OsSystemModel system = this.getProvider().getSystem();
        ITmfEventField content = event.getContent();
        Integer next = (Integer)content.getFieldValue(Integer.class, new String[]{eventLayout.fieldNextTid()});
        Integer prev = (Integer)content.getFieldValue(Integer.class, new String[]{eventLayout.fieldPrevTid()});
        if (next == null || prev == null) {
            return;
        }
        OsWorker nextTask = system.findWorker(new HostThread(host, next), cpu);
        OsWorker prevTask = system.findWorker(new HostThread(host, prev), cpu);
        if (prevTask == null || nextTask == null) {
            return;
        }
        this.stateChange(prevTask, ts);
        this.stateChange(nextTask, ts);
    }

    private void handleSchedWakeup(ITmfEvent event) {
        ITmfGraph graph = (ITmfGraph)NonNullUtils.checkNotNull((Object)this.getProvider().getGraph());
        String host = event.getTrace().getHostId();
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        OsSystemModel system = this.getProvider().getSystem();
        long ts = event.getTimestamp().getValue();
        Integer tid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{eventLayout.fieldTid()});
        if (tid == null) {
            return;
        }
        OsWorker target = system.findWorker(new HostThread(host, tid), cpu);
        OsWorker current = system.getWorkerOnCpu(host, cpu);
        if (target == null) {
            return;
        }
        ProcessStatus status = target.getOldStatus();
        switch (status) {
            case WAIT_FORK: {
                this.waitFork(graph, ts, target, current);
                break;
            }
            case WAIT_BLOCKED: {
                this.waitBlocked(event, graph, host, cpu, eventLayout, system, ts, target, current);
                break;
            }
        }
    }

    private void appendInGraph(ITmfGraph graph, OsWorker target, ITmfVertex vertex, ITmfEdgeContextState contextState, @Nullable String qualifier) {
        Pair<ITmfVertex, ITmfVertex> link = this.fLatestReceivedNetworkLink.remove(target);
        if (link != null) {
            graph.edgeVertical((ITmfVertex)link.getFirst(), (ITmfVertex)link.getSecond(), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), null);
        }
        graph.append(vertex, contextState, qualifier);
    }

    private void waitBlocked(ITmfEvent event, ITmfGraph graph, String host, Integer cpu, IKernelAnalysisEventLayout eventLayout, OsSystemModel system, long ts, OsWorker target, @Nullable OsWorker current) {
        OsInterruptContext context = system.peekContextStack(host, cpu);
        switch (context.getContext()) {
            case HRTIMER: {
                this.appendInGraph(graph, target, graph.createVertex((IGraphWorker)target, ts), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.TIMER), null);
                break;
            }
            case IRQ: 
            case COMPLETE_IRQ: {
                this.irq(graph, eventLayout, ts, target, context);
                break;
            }
            case SOFTIRQ: {
                this.softIrq(event, graph, cpu, eventLayout, ts, target, context);
                break;
            }
            case IPI: {
                this.appendInGraph(graph, target, graph.createVertex((IGraphWorker)target, ts), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.IPI), null);
                break;
            }
            case NONE: {
                this.none(graph, ts, target, current);
                break;
            }
            case PACKET_RECEPTION: {
                this.receivingFromNetwork(event, host, cpu, system, graph, ts, target, current);
                break;
            }
        }
    }

    private void receivingFromNetwork(ITmfEvent event, String host, Integer cpu, OsSystemModel system, ITmfGraph graph, long ts, OsWorker target, @Nullable OsWorker current) {
        OsExecutionGraphProvider.Context innerCtx = TraceEventHandlerExecutionGraph.peekInnerContext(host, cpu, system);
        OsWorker source = current;
        if (innerCtx == OsExecutionGraphProvider.Context.SOFTIRQ || innerCtx == OsExecutionGraphProvider.Context.IRQ) {
            source = this.getOrCreateKernelWorker(event, cpu);
        }
        ITmfVertex wupTarget = graph.createVertex((IGraphWorker)target, ts);
        this.appendInGraph(graph, target, wupTarget, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), source != null && innerCtx != OsExecutionGraphProvider.Context.SOFTIRQ && innerCtx != OsExecutionGraphProvider.Context.IRQ ? source.getName() : null);
        if (source == null) {
            return;
        }
        ITmfVertex tail = graph.getTail((IGraphWorker)source);
        if (tail != null) {
            this.replaceIncomingNetworkEdge(graph, source, tail, wupTarget);
        }
    }

    private boolean replaceIncomingNetworkEdge(ITmfGraph graph, OsWorker tailWorker, ITmfVertex tail, ITmfVertex wupTarget) {
        Pair<ITmfVertex, ITmfVertex> link = this.fLatestReceivedNetworkLink.remove(tailWorker);
        if (link == null) {
            return false;
        }
        graph.edgeVertical((ITmfVertex)link.getFirst(), wupTarget, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), null);
        return true;
    }

    private void extendAndLink(ITmfGraph graph, OsWorker worker, long ts, ITmfVertex targetVertex) {
        ITmfVertex wupSource = this.stateExtend(worker, ts);
        graph.edgeVertical(wupSource, targetVertex, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.DEFAULT), null);
    }

    private void softIrq(ITmfEvent event, ITmfGraph graph, Integer cpu, IKernelAnalysisEventLayout eventLayout, long ts, OsWorker target, OsInterruptContext context) {
        OsWorker k;
        ITmfVertex tail;
        ITmfVertex wupTarget = graph.createVertex((IGraphWorker)target, ts);
        ITmfEventField content = context.getEvent().getContent();
        Long vec = (Long)content.getFieldValue(Long.class, new String[]{eventLayout.fieldVec()});
        this.appendInGraph(graph, target, wupTarget, TraceEventHandlerExecutionGraph.resolveSoftirq(vec), null);
        if (vec != null && (vec == 3L || vec == 2L) && (tail = graph.getTail((IGraphWorker)(k = this.getOrCreateKernelWorker(event, cpu)))) != null) {
            this.replaceIncomingNetworkEdge(graph, k, tail, wupTarget);
        }
    }

    private void none(ITmfGraph graph, long ts, OsWorker target, @Nullable OsWorker current) {
        if (current != null) {
            ITmfVertex n1 = this.stateChange(target, ts);
            this.extendAndLink(graph, current, ts, n1);
        } else {
            this.stateChange(target, ts);
        }
    }

    private void irq(ITmfGraph graph, IKernelAnalysisEventLayout eventLayout, long ts, OsWorker target, OsInterruptContext context) {
        ITmfVertex wup = graph.createVertex((IGraphWorker)target, ts);
        ITmfEventField content = context.getEvent().getContent();
        Integer vec = (Integer)content.getFieldValue(Integer.class, new String[]{eventLayout.fieldIrq()});
        ITmfEdgeContextState contextState = TraceEventHandlerExecutionGraph.resolveIRQ(vec);
        if (contextState.equals(OSEdgeContextState.OSEdgeContextEnum.BLOCKED)) {
            String irqName = (String)content.getFieldValue(String.class, new String[]{eventLayout.fieldName()});
            this.appendInGraph(graph, target, wup, contextState, irqName);
        } else {
            this.appendInGraph(graph, target, wup, contextState, null);
        }
    }

    private void waitFork(ITmfGraph graph, long ts, OsWorker target, @Nullable OsWorker current) {
        if (current != null) {
            ITmfVertex n0 = this.stateExtend(current, ts);
            ITmfVertex n1 = this.stateChange(target, ts);
            graph.edge(n0, n1);
        } else {
            this.stateChange(target, ts);
        }
    }

    private static ITmfEdgeContextState resolveIRQ(@Nullable Integer vec) {
        OSEdgeContextState ret = new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.UNKNOWN);
        if (vec == null) {
            return ret;
        }
        switch (vec) {
            case 0: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.INTERRUPTED);
                break;
            }
            default: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.BLOCKED);
            }
        }
        return ret;
    }

    private static ITmfEdgeContextState resolveSoftirq(@Nullable Long vec) {
        OSEdgeContextState ret = new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.UNKNOWN);
        if (vec == null) {
            return ret;
        }
        switch (vec.intValue()) {
            case 1: 
            case 8: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.TIMER);
                break;
            }
            case 4: 
            case 5: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.BLOCK_DEVICE);
                break;
            }
            case 2: 
            case 3: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.NETWORK);
                break;
            }
            case 7: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.INTERRUPTED);
                break;
            }
            default: {
                ret.setContextEnum((Enum)OSEdgeContextState.OSEdgeContextEnum.BLOCKED);
            }
        }
        return ret;
    }

    private static OsExecutionGraphProvider.Context peekInnerContext(String host, Integer cpu, OsSystemModel system) {
        OsInterruptContext lastCtx = system.popContextStack(host, cpu);
        OsInterruptContext innerCtx = system.peekContextStack(host, cpu);
        if (lastCtx != null) {
            system.pushContextStack(host, cpu, lastCtx);
        }
        return innerCtx.getContext();
    }

    private void handleInetSockLocalIn(ITmfEvent event) {
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        String host = event.getTrace().getHostId();
        OsSystemModel system = this.getProvider().getSystem();
        OsInterruptContext intCtx = system.peekContextStack(host, cpu);
        OsExecutionGraphProvider.Context context = intCtx.getContext();
        if (context == OsExecutionGraphProvider.Context.PACKET_RECEPTION) {
            context = TraceEventHandlerExecutionGraph.peekInnerContext(host, cpu, system);
        }
        OsWorker receiver = null;
        receiver = context == OsExecutionGraphProvider.Context.SOFTIRQ || context == OsExecutionGraphProvider.Context.IRQ ? this.getOrCreateKernelWorker(event, cpu) : system.getWorkerOnCpu(event.getTrace().getHostId(), cpu);
        if (receiver == null) {
            return;
        }
        ITmfVertex endpoint = this.stateExtend(receiver, event.getTimestamp().getValue());
        this.fTcpNodes.put(new TmfEventDependency.DependencyEvent(event), endpoint);
        this.fTcpMatching.matchEvent(event, event.getTrace(), (IProgressMonitor)DEFAULT_PROGRESS_MONITOR);
    }

    private void handleInetSockLocalOut(ITmfEvent event) {
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        String host = event.getTrace().getHostId();
        OsSystemModel system = this.getProvider().getSystem();
        OsInterruptContext intCtx = system.peekContextStack(host, cpu);
        OsExecutionGraphProvider.Context context = intCtx.getContext();
        if (context == OsExecutionGraphProvider.Context.PACKET_RECEPTION) {
            context = TraceEventHandlerExecutionGraph.peekInnerContext(host, cpu, system);
        }
        OsWorker sender = null;
        if (context == OsExecutionGraphProvider.Context.NONE) {
            sender = system.getWorkerOnCpu(event.getTrace().getHostId(), cpu);
        } else if (context == OsExecutionGraphProvider.Context.SOFTIRQ) {
            sender = this.getOrCreateKernelWorker(event, cpu);
        }
        if (sender == null) {
            return;
        }
        ITmfVertex endpoint = this.stateExtend(sender, event.getTimestamp().getValue());
        this.fTcpNodes.put(new TmfEventDependency.DependencyEvent(event), endpoint);
        this.fTcpMatching.matchEvent(event, event.getTrace(), (IProgressMonitor)DEFAULT_PROGRESS_MONITOR);
    }

    private void handleSoftirqEntry(ITmfEvent event) {
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        ITmfGraph graph = (ITmfGraph)NonNullUtils.checkNotNull((Object)this.getProvider().getGraph());
        Long vec = (Long)event.getContent().getFieldValue(Long.class, new String[]{eventLayout.fieldVec()});
        if (vec != null && (vec == 3L || vec == 2L)) {
            Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
            OsWorker k = this.getOrCreateKernelWorker(event, cpu);
            graph.add(graph.createVertex((IGraphWorker)k, event.getTimestamp().getValue()));
        }
    }
}

