/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.analysis.core.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ICpuTimeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ISamplingDataProvider;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.IThreadOnCpuProvider;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ProcessStatusInterval;
import org.eclipse.tracecompass.incubator.analysis.core.model.IHostModel;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CompositeHostModel
implements IHostModel {
    private final Multimap<ITmfTrace, Object> fTraceObjectMap = HashMultimap.create();
    private final Set<ICpuTimeProvider> fCpuTimeProviders = (Set)NonNullUtils.checkNotNull(Collections.newSetFromMap(new WeakHashMap()));
    private final Set<IThreadOnCpuProvider> fThreadOnCpuProviders = (Set)NonNullUtils.checkNotNull(Collections.newSetFromMap(new WeakHashMap()));
    private final Set<ISamplingDataProvider> fSamplingDataProviders = (Set)NonNullUtils.checkNotNull(Collections.newSetFromMap(new WeakHashMap()));
    private final Set<KernelAnalysisModule> fKernelModules = (Set)NonNullUtils.checkNotNull(Collections.newSetFromMap(new WeakHashMap()));
    private final String fHostId;

    public CompositeHostModel(String hostId) {
        this.fHostId = hostId;
        TmfSignalManager.register((Object)this);
    }

    @Override
    public int getThreadOnCpu(int cpu, long t, boolean block) {
        for (IThreadOnCpuProvider provider : this.fThreadOnCpuProviders) {
            Integer tid = provider.getThreadOnCpuAtTime(cpu, t, block);
            if (tid == null || tid == -1) continue;
            return tid;
        }
        return -1;
    }

    @Override
    public long getCpuTime(int tid, long start, long end) {
        for (ICpuTimeProvider provider : this.fCpuTimeProviders) {
            long cpuTime = provider.getCpuTime(tid, start, end);
            if (cpuTime == -1L) continue;
            return cpuTime;
        }
        return -1L;
    }

    @Override
    public Collection<AggregatedCallSite> getSamplingData(int tid, long start, long end) {
        for (ISamplingDataProvider provider : this.fSamplingDataProviders) {
            Collection<AggregatedCallSite> samples = provider.getSamplingData(tid, start, end);
            if (samples.isEmpty()) continue;
            return samples;
        }
        return Collections.emptyList();
    }

    @Override
    public int getProcessId(int tid, long t) {
        Integer pid = this.fKernelModules.stream().map(module -> KernelThreadInformationProvider.getProcessId((KernelAnalysisModule)module, (Integer)tid, (long)t)).filter(Objects::nonNull).findFirst().orElse(null);
        return pid == null ? -1 : pid;
    }

    @Override
    public @Nullable String getExecName(int tid, long t) {
        return this.fKernelModules.stream().map(module -> KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)module, (Integer)tid)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void setCpuTimeProvider(ICpuTimeProvider provider) {
        this.fCpuTimeProviders.add(provider);
    }

    public void setCpuTimeProvider(ITmfTrace trace, ICpuTimeProvider provider) {
        this.fCpuTimeProviders.add(provider);
        this.fTraceObjectMap.put((Object)trace, (Object)provider);
    }

    public void setThreadOnCpuProvider(IThreadOnCpuProvider provider) {
        this.fThreadOnCpuProviders.add(provider);
    }

    public void setThreadOnCpuProvider(ITmfTrace trace, IThreadOnCpuProvider provider) {
        this.fThreadOnCpuProviders.add(provider);
        this.fTraceObjectMap.put((Object)trace, (Object)provider);
    }

    public void setSamplingDataProvider(ISamplingDataProvider provider) {
        this.fSamplingDataProviders.add(provider);
    }

    public void setSamplingDataProvider(ITmfTrace trace, ISamplingDataProvider provider) {
        this.fSamplingDataProviders.add(provider);
        this.fTraceObjectMap.put((Object)trace, (Object)provider);
    }

    public void setKernelModule(ITmfTrace trace, KernelAnalysisModule module) {
        this.fKernelModules.add(module);
        this.fTraceObjectMap.put((Object)trace, (Object)module);
    }

    public String toString() {
        return String.valueOf(this.getClass());
    }

    @Override
    public Iterable<ProcessStatusInterval> getThreadStatusIntervals(int tid, long start, long end, long resolution) {
        if (tid == -1) {
            return Objects.requireNonNull(Collections.emptyList());
        }
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((String)this.fHostId, KernelAnalysisModule.class);
        if (modules.iterator().hasNext()) {
            KernelAnalysisModule module = (KernelAnalysisModule)modules.iterator().next();
            return new ThreadStatusIterable(start, end, module, tid, resolution);
        }
        return Objects.requireNonNull(Collections.emptyList());
    }

    @Override
    public boolean isSamplingDataAvailable() {
        return !this.fSamplingDataProviders.isEmpty();
    }

    @Override
    public boolean isThreadStatusAvailable() {
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((String)this.fHostId, KernelAnalysisModule.class);
        return modules.iterator().hasNext();
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)trace).forEach(t -> {
            Collection objects = this.fTraceObjectMap.removeAll(t);
            for (Object object : objects) {
                if (object instanceof ICpuTimeProvider) {
                    this.fCpuTimeProviders.remove(object);
                }
                if (object instanceof IThreadOnCpuProvider) {
                    this.fThreadOnCpuProviders.remove(object);
                }
                if (object instanceof ISamplingDataProvider) {
                    this.fSamplingDataProviders.remove(object);
                }
                if (!(object instanceof KernelAnalysisModule)) continue;
                this.fKernelModules.remove(object);
            }
        });
    }

    @Override
    public void dispose() {
        TmfSignalManager.deregister((Object)this);
    }

    private static class ThreadStatusIterable
    implements Iterable<ProcessStatusInterval> {
        private final long fStart;
        private final long fEnd;
        private KernelAnalysisModule fModule;
        private int fTid;
        private long fResolution;

        public ThreadStatusIterable(long start, long end, KernelAnalysisModule module, int tid, long resolution) {
            this.fStart = start;
            this.fEnd = end;
            this.fModule = module;
            this.fTid = tid;
            this.fResolution = resolution;
        }

        @Override
        public Iterator<ProcessStatusInterval> iterator() {
            return new ThreadStatusIterator(this.fStart, this.fEnd, KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)this.fModule, (Integer)this.fTid, (long)this.fStart, (long)this.fEnd, (long)this.fResolution));
        }
    }

    private static class ThreadStatusIterator
    implements Iterator<ProcessStatusInterval> {
        private final Iterator<ITmfStateInterval> fIntervalIterator;
        private final long fStart;
        private final long fEnd;

        public ThreadStatusIterator(long start, long end, Iterator<ITmfStateInterval> iter) {
            this.fIntervalIterator = iter;
            this.fStart = start;
            this.fEnd = end;
        }

        @Override
        public boolean hasNext() {
            return this.fIntervalIterator.hasNext();
        }

        @Override
        public ProcessStatusInterval next() {
            if (!this.fIntervalIterator.hasNext()) {
                throw new NoSuchElementException();
            }
            ITmfStateInterval interval = this.fIntervalIterator.next();
            long start = Math.max(interval.getStartTime(), this.fStart);
            long end = Math.min(interval.getEndTime(), this.fEnd);
            return new ProcessStatusInterval(start, end, ProcessStatus.getStatusFromStateValue((ITmfStateValue)interval.getStateValue()));
        }
    }
}

