/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.atrace.trace;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.atrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.IGenericFtraceConstants;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.trace.GenericFtrace;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;

public class ATrace
extends GenericFtrace {
    private static final String ATRACE_TRACEEVENT_EVENT = "tracing_mark_write";
    private static final Pattern TRACE_EVENT_PATTERN = Pattern.compile("(?<phase>\\w)(\\|(?<tid>\\d+)\\|(?<content>[^\\|]+))?");
    private static final String TRACE_EVENT_PHASE_GROUP = "phase";
    private static final String TRACE_EVENT_CONTENT_GROUP = "content";
    private static final int MAX_LINES = 100;
    private static final int MAX_CONFIDENCE = 100;

    public IStatus validate(IProject project, String path) {
        int confidence;
        block23: {
            File file = new File(path);
            if (!file.exists()) {
                return new Status(4, "org.eclipse.tracecompass.incubator.atrace.core", "File not found: " + path);
            }
            if (!file.isFile()) {
                return new Status(4, "org.eclipse.tracecompass.incubator.atrace.core", "Not a file. It's a directory: " + path);
            }
            confidence = 0;
            try {
                if (!TmfTraceUtils.isText((File)file)) {
                    return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.incubator.atrace.core");
                }
            }
            catch (IOException e) {
                Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
                return new Status(4, "org.eclipse.tracecompass.incubator.atrace.core", "IOException validating file: " + path, (Throwable)e);
            }
            try {
                Throwable e = null;
                Object var6_9 = null;
                try (BufferedRandomAccessFile rafile = new BufferedRandomAccessFile(path, "r");){
                    int lineCount = 0;
                    int matches = 0;
                    String line = rafile.readLine();
                    int function_call_count = 0;
                    boolean isSystrace = false;
                    while (line != null && lineCount++ < 100) {
                        if (line.contains("<title>Android System Trace</title>")) {
                            confidence = 100;
                            isSystrace = true;
                            ++matches;
                            break;
                        }
                        try {
                            GenericFtraceField field = this.parseLine(line);
                            if (field != null) {
                                ++matches;
                                if (field.getTid() != field.getPid()) {
                                    ++function_call_count;
                                }
                            }
                        }
                        catch (RuntimeException e2) {
                            confidence = Integer.MIN_VALUE;
                        }
                        confidence = 100 * matches / lineCount;
                        line = rafile.readLine();
                    }
                    confidence = function_call_count > 0 || isSystrace ? ++confidence : 0;
                    if (matches != 0) break block23;
                    return new Status(4, "org.eclipse.tracecompass.incubator.atrace.core", "Most assuredly NOT a atrace trace");
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
                return new Status(4, "org.eclipse.tracecompass.incubator.atrace.core", "IOException validating file: " + path, (Throwable)e);
            }
        }
        return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.incubator.atrace.core");
    }

    protected @Nullable GenericFtraceField parseLine(String line) {
        String data;
        Matcher atraceMatcher;
        Matcher matcher;
        if (line == null || line.isEmpty()) {
            return null;
        }
        GenericFtraceField field = GenericFtraceField.parseLine((String)line);
        if (field != null && (matcher = IGenericFtraceConstants.FTRACE_PATTERN.matcher(line)).matches() && field.getName().equals(ATRACE_TRACEEVENT_EVENT) && (atraceMatcher = TRACE_EVENT_PATTERN.matcher(data = matcher.group("data"))).matches()) {
            String phase = atraceMatcher.group(TRACE_EVENT_PHASE_GROUP);
            String pname = matcher.group("comm");
            String content = atraceMatcher.group(TRACE_EVENT_CONTENT_GROUP);
            Integer tid = field.getTid();
            Integer pid = field.getPid();
            HashMap<@NonNull String, @NonNull Object> argmap = new HashMap<String, Object>();
            if (phase != null) {
                argmap.put("ph", phase);
            }
            if (tid != null) {
                argmap.put("tid", tid);
            }
            if (pid != null) {
                argmap.put("pid", pid);
            }
            if (pname != null) {
                argmap.put("tname", pname);
            }
            if (content != null) {
                field.setName(content);
            }
            field.setContent(argmap);
        }
        return field;
    }
}

