/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.trace;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceAspects;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.IGenericFtraceConstants;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.layout.GenericFtraceEventLayout;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public abstract class GenericFtrace
extends TmfTrace
implements IKernelTrace {
    private static final int ESTIMATED_EVENT_SIZE = 90;
    private static final TmfLongLocation NULL_LOCATION = new TmfLongLocation(-1L);
    private static final TmfContext INVALID_CONTEXT = new TmfContext((ITmfLocation)NULL_LOCATION, -1L);
    private File fFile;
    private RandomAccessFile fFileInput;

    protected @Nullable GenericFtraceField parseLine(String line) {
        if (line != null) {
            return GenericFtraceField.parseLine(line);
        }
        return null;
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        super.initTrace(resource, path, type);
        try {
            this.fFile = new File(path);
            this.fFileInput = new BufferedRandomAccessFile(this.fFile, "r");
        }
        catch (IOException e) {
            throw new TmfTraceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void dispose() {
        if (this.fFileInput != null) {
            try {
                this.fFileInput.close();
            }
            catch (IOException e) {
                Activator.getInstance().logError("Error disposing trace. File: " + this.getPath(), (Throwable)e);
            }
        }
        super.dispose();
    }

    public double getLocationRatio(ITmfLocation location) {
        return ((Long)this.getCurrentLocation().getLocationInfo()).doubleValue() / (double)this.fFile.length();
    }

    public ITmfContext seekEvent(ITmfLocation location) {
        if (this.fFile == null) {
            return INVALID_CONTEXT;
        }
        TmfContext context = new TmfContext((ITmfLocation)NULL_LOCATION, -1L);
        if (NULL_LOCATION.equals((Object)location)) {
            return context;
        }
        try {
            if (location == null) {
                this.fFileInput.seek(0L);
                long lineStartOffset = this.fFileInput.getFilePointer();
                @Nullable String line = this.fFileInput.readLine();
                if (line == null) {
                    return context;
                }
                Matcher matcher = IGenericFtraceConstants.FTRACE_PATTERN.matcher(line);
                while (!matcher.matches()) {
                    lineStartOffset = this.fFileInput.getFilePointer();
                    line = this.fFileInput.readLine();
                    if (line == null) break;
                    matcher = IGenericFtraceConstants.FTRACE_PATTERN.matcher(line);
                }
                this.fFileInput.seek(lineStartOffset);
            } else if (location.getLocationInfo() instanceof Long) {
                this.fFileInput.seek((Long)location.getLocationInfo());
            }
            context.setLocation((ITmfLocation)new TmfLongLocation(this.fFileInput.getFilePointer()));
            context.setRank(0L);
            return context;
        }
        catch (FileNotFoundException e) {
            Activator.getInstance().logError("Error seeking event. File not found: " + this.getPath(), (Throwable)e);
            return context;
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error seeking event. File: " + this.getPath(), (Throwable)e);
            return context;
        }
    }

    public ITmfEvent parseEvent(ITmfContext context) {
        @Nullable ITmfLocation location = context.getLocation();
        if (location instanceof TmfLongLocation) {
            TmfLongLocation tmfLongLocation = (TmfLongLocation)location;
            Long locationInfo = tmfLongLocation.getLocationInfo();
            if (location.equals(NULL_LOCATION)) {
                locationInfo = 0L;
            }
            if (locationInfo != null) {
                try {
                    String nextLine;
                    if (!locationInfo.equals(this.fFileInput.getFilePointer())) {
                        this.fFileInput.seek(locationInfo);
                    }
                    while ((nextLine = this.fFileInput.readLine()) != null && nextLine.startsWith("#")) {
                    }
                    GenericFtraceField field = this.parseLine(nextLine);
                    if (field != null) {
                        return new GenericFtraceEvent((ITmfTrace)this, context.getRank(), field);
                    }
                }
                catch (IOException e) {
                    Activator.getInstance().logError("Error parsing event", (Throwable)e);
                }
            }
        }
        return null;
    }

    public ITmfLocation getCurrentLocation() {
        long temp = -1L;
        try {
            temp = this.fFileInput.getFilePointer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new TmfLongLocation(temp);
    }

    public ITmfContext seekEvent(double ratio) {
        File file = this.fFile;
        if (file == null) {
            return INVALID_CONTEXT;
        }
        long filePos = (long)((double)file.length() * ratio);
        long estimatedRank = filePos / 90L;
        return this.seekEvent((ITmfLocation)new TmfLongLocation(estimatedRank));
    }

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(GenericFtraceAspects.getAspects());
        return builder.build();
    }

    public IKernelAnalysisEventLayout getKernelEventLayout() {
        return GenericFtraceEventLayout.getInstance();
    }
}

