/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tracecompass.core.trace;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.json.JSONException;
import org.json.JSONObject;

public class TraceCompassJulEvent
extends CtfTmfEvent {
    private transient @Nullable String fEventName;
    private transient @Nullable ITmfEventField fContent;

    public TraceCompassJulEvent(CtfTmfTrace trace, long rank, ITmfTimestamp timestamp, String channel, int cpu, IEventDeclaration declaration, IEventDefinition eventDefinition) {
        super(trace, rank, timestamp, channel, cpu, declaration, eventDefinition);
    }

    public @NonNull String getName() {
        String eventName = this.fEventName;
        if (eventName == null) {
            this.getContent();
            eventName = this.fEventName;
            if (eventName == null) {
                eventName = this.fEventName = super.getName();
            }
        }
        return eventName;
    }

    public synchronized @NonNull ITmfEventField getContent() {
        ITmfEventField content = this.fContent;
        if (content == null) {
            ITmfEventField baseContent = super.getContent();
            ITmfEventField field = baseContent.getField(new String[]{"msg"});
            content = baseContent;
            if (field == null) {
                this.fContent = baseContent;
                return baseContent;
            }
            String msg = (String)field.getValue();
            ArrayList<TmfEventField> fields = new ArrayList<TmfEventField>();
            baseContent.getFields().stream().forEach(t -> {
                boolean bl = fields.add((TmfEventField)t);
            });
            try {
                JSONObject args;
                String ts;
                JSONObject root = new JSONObject(msg);
                char phase = root.optString("ph", "i").charAt(0);
                fields.add(new TmfEventField("ph", (Object)String.valueOf(phase), null));
                this.fEventName = root.optString("name");
                fields.add(new TmfEventField("evName", (Object)this.fEventName, null));
                String id = root.optString("id");
                if (id != null) {
                    fields.add(new TmfEventField("id", (Object)id, null));
                }
                if ((id = root.optString("cat")) != null) {
                    fields.add(new TmfEventField("cat", (Object)id, null));
                }
                if ((ts = root.optString("ts")) != null) {
                    fields.add(new TmfEventField("ts", (Object)ts, null));
                }
                if ((args = root.optJSONObject("args")) != null) {
                    Iterator keys = args.keys();
                    while (keys.hasNext()) {
                        String key = String.valueOf(keys.next());
                        String value = args.optString(key);
                        fields.add(new TmfEventField("args." + key, (Object)value, null));
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.fContent = content = new TmfEventField(":root:", null, (ITmfEventField[])fields.toArray(new TmfEventField[fields.size()]));
        }
        return content;
    }
}

