/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.context.ContextAnalysis;
import org.eclipse.tracecompass.internal.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class ContextDataProvider
extends AbstractTimeGraphDataProvider<ContextAnalysis, TimeGraphEntryModel> {
    public static final @NonNull String ID = "org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.context.dataprovider";

    public ContextDataProvider(ITmfTrace trace, ContextAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    public @NonNull String getId() {
        return ID;
    }

    protected boolean isCacheable() {
        return true;
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, "Not supported");
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, "Not supported");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable List<@NonNull ITimeGraphRowModel> getRowModel(@NonNull ITmfStateSystem ss, @NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        HashMap<Integer, String[]> paths = new HashMap<Integer, String[]>();
        ArrayList<MarkerModel> markerList = new ArrayList<MarkerModel>();
        Collection times = ContextDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        HashSet quarks = new HashSet();
        @NonNull @NonNull Map selectedEntries = this.getSelectedEntries(filter);
        for (Integer quark : selectedEntries.values()) {
            quarks.addAll(ss.getSubAttributes(quark.intValue(), true));
        }
        for (Integer quark : quarks) {
            paths.put(quark, ss.getFullAttributePathArray(quark.intValue()));
        }
        for (ITmfStateInterval interval : ss.query2D(quarks, times)) {
            if (monitor != null && monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (!(interval.getValue() instanceof Integer)) continue;
            long startTime = interval.getStartTime();
            long duration = interval.getEndTime() - startTime + 1L;
            markerList.add(new MarkerModel(startTime, duration, (String[])paths.get(interval.getAttribute())));
        }
        if (monitor != null && monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new TimeGraphRowModel(this.getId(-1), markerList));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull List<@NonNull TimeGraphEntryModel> getTree(@NonNull ITmfStateSystem ss, @NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        long rootId = this.getId(-1);
        @NonNull List attribs = ss.getSubAttributes(-1, false);
        ArrayList<@NonNull TimeGraphEntryModel> retVal = new ArrayList<TimeGraphEntryModel>();
        for (Integer attrib : attribs) {
            String[] strings = ss.getFullAttributePathArray(attrib.intValue());
            retVal.add(new TimeGraphEntryModel(this.getId(attrib), rootId, strings[0], ss.getStartTime(), ss.getCurrentEndTime()));
        }
        return retVal;
    }

    public static class MarkerModel
    extends TimeGraphState {
        private final String fAnnotation;
        private final String fCategory;

        private MarkerModel(long startTime, long duration, String[] sections) {
            super(startTime, duration, 0, sections[1]);
            this.fCategory = sections[0];
            this.fAnnotation = sections[2];
        }

        public String getCategory() {
            return this.fCategory;
        }

        public String getAnnotation() {
            return this.fAnnotation;
        }
    }
}

