/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc;

import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.ConcurrentMessageProcessor;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageConsumer;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageProducer;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.jsonrpc.validation.ReflectiveMessageValidator;

public interface Launcher<T> {
    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out) {
        return new Builder().setLocalService(localService).setRemoteInterface(remoteInterface).setInput(in).setOutput(out).create();
    }

    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, boolean validate, PrintWriter trace) {
        return new Builder().setLocalService(localService).setRemoteInterface(remoteInterface).setInput(in).setOutput(out).validateMessages(validate).traceMessages(trace).create();
    }

    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return Launcher.createIoLauncher(localService, remoteInterface, in, out, executorService, wrapper);
    }

    public static <T> Launcher<T> createIoLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return new Builder().setLocalService(localService).setRemoteInterface(remoteInterface).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).create();
    }

    public static <T> Launcher<T> createIoLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper, Consumer<GsonBuilder> configureGson) {
        return new Builder().setLocalService(localService).setRemoteInterface(remoteInterface).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).configureGson(configureGson).create();
    }

    public static Launcher<Object> createIoLauncher(Collection<Object> localServices, Collection<Class<?>> remoteInterfaces, ClassLoader classLoader, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper, Consumer<GsonBuilder> configureGson) {
        return new Builder().setLocalServices(localServices).setRemoteInterfaces(remoteInterfaces).setClassLoader(classLoader).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).configureGson(configureGson).create();
    }

    public Future<Void> startListening();

    public T getRemoteProxy();

    public RemoteEndpoint getRemoteEndpoint();

    public static class Builder<T> {
        protected Collection<Object> localServices;
        protected Collection<Class<? extends T>> remoteInterfaces;
        protected InputStream input;
        protected OutputStream output;
        protected ExecutorService executorService;
        protected Function<MessageConsumer, MessageConsumer> messageWrapper;
        protected boolean validateMessages;
        protected PrintWriter messageTracer;
        protected Consumer<GsonBuilder> configureGson;
        protected ClassLoader classLoader;

        public Builder<T> setLocalService(Object localService) {
            this.localServices = Collections.singletonList(localService);
            return this;
        }

        public Builder<T> setLocalServices(Collection<Object> localServices) {
            this.localServices = localServices;
            return this;
        }

        public Builder<T> setRemoteInterface(Class<? extends T> remoteInterface) {
            this.remoteInterfaces = Collections.singletonList(remoteInterface);
            return this;
        }

        public Builder<T> setRemoteInterfaces(Collection<Class<? extends T>> remoteInterfaces) {
            this.remoteInterfaces = remoteInterfaces;
            return this;
        }

        public Builder<T> setInput(InputStream input) {
            this.input = input;
            return this;
        }

        public Builder<T> setOutput(OutputStream output) {
            this.output = output;
            return this;
        }

        public Builder<T> setExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder<T> setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder<T> wrapMessages(Function<MessageConsumer, MessageConsumer> wrapper) {
            this.messageWrapper = wrapper;
            return this;
        }

        public Builder<T> validateMessages(boolean validate) {
            this.validateMessages = validate;
            return this;
        }

        public Builder<T> traceMessages(PrintWriter tracer) {
            this.messageTracer = tracer;
            return this;
        }

        public Builder<T> configureGson(Consumer<GsonBuilder> configureGson) {
            this.configureGson = configureGson;
            return this;
        }

        public Launcher<T> create() {
            if (this.input == null) {
                throw new IllegalStateException("Input stream must be configured.");
            }
            if (this.output == null) {
                throw new IllegalStateException("Output stream must be configured.");
            }
            if (this.localServices == null) {
                throw new IllegalStateException("Local service must be configured.");
            }
            if (this.remoteInterfaces == null) {
                throw new IllegalStateException("Remote interface must be configured.");
            }
            MessageJsonHandler jsonHandler = this.createJsonHandler();
            final RemoteEndpoint remoteEndpoint = this.createRemoteEndpoint(jsonHandler);
            final Object remoteProxy = this.localServices.size() == 1 && this.remoteInterfaces.size() == 1 ? ServiceEndpoints.toServiceObject(remoteEndpoint, this.remoteInterfaces.iterator().next()) : ServiceEndpoints.toServiceObject(remoteEndpoint, this.remoteInterfaces, this.classLoader);
            final StreamMessageProducer reader = new StreamMessageProducer(this.input, jsonHandler, remoteEndpoint);
            final MessageConsumer messageConsumer = this.wrapMessageConsumer(remoteEndpoint);
            final ExecutorService execService = this.executorService != null ? this.executorService : Executors.newCachedThreadPool();
            return new Launcher<T>(){

                @Override
                public Future<Void> startListening() {
                    return ConcurrentMessageProcessor.startProcessing(reader, messageConsumer, execService);
                }

                @Override
                public T getRemoteProxy() {
                    return remoteProxy;
                }

                @Override
                public RemoteEndpoint getRemoteEndpoint() {
                    return remoteEndpoint;
                }
            };
        }

        protected MessageConsumer wrapMessageConsumer(MessageConsumer consumer) {
            MessageConsumer result = consumer;
            if (this.messageTracer != null) {
                PrintWriter tracer = this.messageTracer;
                result = message -> {
                    tracer.println(message);
                    tracer.flush();
                    consumer.consume(message);
                };
            }
            if (this.validateMessages) {
                result = new ReflectiveMessageValidator(result);
            }
            if (this.messageWrapper != null) {
                result = this.messageWrapper.apply(result);
            }
            return result;
        }

        protected Map<String, JsonRpcMethod> getSupportedMethods() {
            LinkedHashMap<String, JsonRpcMethod> supportedMethods = new LinkedHashMap<String, JsonRpcMethod>();
            for (Class<? extends T> clazz : this.remoteInterfaces) {
                supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(clazz));
            }
            for (Object object : this.localServices) {
                if (object instanceof JsonRpcMethodProvider) {
                    JsonRpcMethodProvider rpcMethodProvider = (JsonRpcMethodProvider)object;
                    supportedMethods.putAll(rpcMethodProvider.supportedMethods());
                    continue;
                }
                supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(object.getClass()));
            }
            return supportedMethods;
        }

        protected MessageJsonHandler createJsonHandler() {
            Map<String, JsonRpcMethod> supportedMethods = this.getSupportedMethods();
            if (this.configureGson != null) {
                return new MessageJsonHandler(supportedMethods, this.configureGson);
            }
            return new MessageJsonHandler(supportedMethods);
        }

        protected RemoteEndpoint createRemoteEndpoint(MessageJsonHandler jsonHandler) {
            MessageConsumer outgoingMessageStream = new StreamMessageConsumer(this.output, jsonHandler);
            outgoingMessageStream = this.wrapMessageConsumer(outgoingMessageStream);
            RemoteEndpoint remoteEndpoint = new RemoteEndpoint(outgoingMessageStream, ServiceEndpoints.toEndpoint(this.localServices));
            jsonHandler.setMethodProvider(remoteEndpoint);
            return remoteEndpoint;
        }
    }
}

