/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.concepts;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ICallStackSymbol;

public abstract class AggregatedCallSite {
    private final ICallStackSymbol fSymbol;
    private final Map<Object, AggregatedCallSite> fCallees = new HashMap<Object, AggregatedCallSite>();
    private final @Nullable AggregatedCallSite fCaller;

    public AggregatedCallSite(ICallStackSymbol symbol) {
        this.fSymbol = symbol;
        this.fCaller = null;
    }

    protected AggregatedCallSite(AggregatedCallSite copy) {
        this.fSymbol = copy.fSymbol;
        for (Map.Entry<Object, AggregatedCallSite> entry : copy.fCallees.entrySet()) {
            this.fCallees.put(entry.getKey(), entry.getValue().copyOf());
        }
        this.fCaller = copy.fCaller;
    }

    public abstract long getLength();

    public abstract AggregatedCallSite copyOf();

    public ICallStackSymbol getSymbol() {
        return this.fSymbol;
    }

    protected @Nullable AggregatedCallSite getCaller() {
        return this.fCaller;
    }

    public Collection<AggregatedCallSite> getCallees() {
        return this.fCallees.values();
    }

    public void addCallee(AggregatedCallSite callee) {
        AggregatedCallSite callsite = this.fCallees.get(callee.getSymbol());
        if (callsite == null) {
            this.fCallees.put(callee.getSymbol(), callee);
            return;
        }
        callsite.merge(callee);
    }

    public final void merge(AggregatedCallSite other) {
        if (!other.getSymbol().equals(this.getSymbol())) {
            throw new IllegalArgumentException("AggregatedStackTraces: trying to merge stack traces of different symbols");
        }
        this.mergeData(other);
        this.mergeCallees(other);
    }

    protected abstract void mergeData(AggregatedCallSite var1);

    private void mergeCallees(AggregatedCallSite other) {
        for (AggregatedCallSite otherChildSite : other.fCallees.values()) {
            ICallStackSymbol childSymbol = otherChildSite.getSymbol();
            AggregatedCallSite childSite = this.fCallees.get(childSymbol);
            if (childSite == null) {
                this.fCallees.put(childSymbol, otherChildSite.copyOf());
                continue;
            }
            childSite.merge(otherChildSite);
        }
    }

    public int getMaxDepth() {
        int maxDepth = 0;
        for (AggregatedCallSite callsite : this.fCallees.values()) {
            maxDepth = Math.max(maxDepth, callsite.getMaxDepth());
        }
        return maxDepth + 1;
    }

    public Map<String, IStatistics<?>> getStatistics() {
        return ImmutableMap.of();
    }

    public String toString() {
        return "CallSite: " + this.fSymbol;
    }

    public Iterable<AggregatedCallSite> getExtraChildrenSites() {
        return Collections.emptyList();
    }
}

