/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.callstack.core.callgraph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;

public class CallGraph {
    public static final CallGraph EMPTY_GRAPH = new CallGraph();
    private Set<ICallStackElement> fRootElements = new HashSet<ICallStackElement>();
    private final Multimap<ICallStackElement, AggregatedCallSite> fCcts = HashMultimap.create();

    public Collection<AggregatedCallSite> getCallingContextTree(ICallStackElement element) {
        return this.fCcts.get((Object)element);
    }

    public void addAggregatedCallSite(ICallStackElement dstGroup, AggregatedCallSite callsite) {
        ICallStackElement root = dstGroup;
        ICallStackElement parent = dstGroup.getParentElement();
        while (parent != null) {
            root = parent;
            parent = parent.getParentElement();
        }
        this.fRootElements.add(root);
        Collection callsites = this.fCcts.get((Object)dstGroup);
        for (AggregatedCallSite site : callsites) {
            if (!site.getSymbol().equals(callsite.getSymbol())) continue;
            site.merge(callsite);
            return;
        }
        this.fCcts.put((Object)dstGroup, (Object)callsite);
    }

    public Collection<ICallStackElement> getElements() {
        return ImmutableSet.copyOf(this.fRootElements);
    }
}

