/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.analysis.core.aspects.ProcessNameAspect;
import org.eclipse.tracecompass.incubator.analysis.core.aspects.ThreadNameAspect;
import org.eclipse.tracecompass.incubator.callstack.core.flamechart.Messages;
import org.eclipse.tracecompass.incubator.internal.callstack.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public abstract class CallStackStateProvider
extends AbstractTmfStateProvider {
    public static final String PROCESSES = "Processes";
    public static final int UNKNOWN_PID = -1;
    public static final String UNKNOWN = "UNKNOWN";
    private static final String ID = "org.eclipse.linuxtools.tmf.callstack";

    public CallStackStateProvider(ITmfTrace trace) {
        super(trace, ID);
    }

    protected void eventHandle(ITmfEvent event) {
        if (!this.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        this.handleFunctionEntry(ss, event);
        this.handleFunctionExit(ss, event);
    }

    private void handleFunctionEntry(ITmfStateSystemBuilder ss, ITmfEvent event) {
        Object functionEntryName = this.functionEntry(event);
        if (functionEntryName != null) {
            long timestamp = event.getTimestamp().toNanos();
            String processName = this.getProcessName(event);
            int processId = this.getProcessId(event);
            if (processName == null) {
                processName = processId == -1 ? UNKNOWN : Integer.toString(processId);
            }
            int processQuark = ss.getQuarkAbsoluteAndAdd(new String[]{PROCESSES, processName});
            ss.updateOngoingState((ITmfStateValue)TmfStateValue.newValueInt((int)processId), processQuark);
            String threadName = this.getThreadName(event);
            long threadId = this.getThreadId(event);
            if (threadName == null) {
                threadName = Long.toString(threadId);
            }
            int threadQuark = ss.getQuarkRelativeAndAdd(processQuark, new String[]{threadName});
            ss.updateOngoingState((ITmfStateValue)TmfStateValue.newValueLong((long)threadId), threadQuark);
            int callStackQuark = ss.getQuarkRelativeAndAdd(threadQuark, new String[]{"CallStack"});
            ss.pushAttribute(timestamp, functionEntryName, callStackQuark);
            return;
        }
    }

    private void handleFunctionExit(ITmfStateSystemBuilder ss, ITmfEvent event) {
        Object functionExitState = this.functionExit(event);
        if (functionExitState != null) {
            int quark;
            ITmfStateValue poppedValue;
            String threadName;
            long timestamp = event.getTimestamp().toNanos();
            String processName = this.getProcessName(event);
            if (processName == null) {
                int processId = this.getProcessId(event);
                String string = processName = processId == -1 ? UNKNOWN : Integer.toString(processId);
            }
            if ((threadName = this.getThreadName(event)) == null) {
                threadName = Long.toString(this.getThreadId(event));
            }
            if (!functionExitState.equals(poppedValue = ss.popAttribute(timestamp, quark = ss.getQuarkAbsoluteAndAdd(new String[]{PROCESSES, processName, threadName, "CallStack"})))) {
                Activator.getInstance().logWarning(String.valueOf(NLS.bind((String)Messages.CallStackStateProvider_EventDescription, (Object)event.getName(), (Object)event.getTimestamp().getValue())) + ": " + NLS.bind((String)Messages.CallStackStateProvider_UnmatchedPoppedValue, (Object)functionExitState, (Object)poppedValue));
            }
        }
    }

    public abstract CallStackStateProvider getNewInstance();

    protected abstract boolean considerEvent(ITmfEvent var1);

    protected abstract @Nullable Object functionEntry(ITmfEvent var1);

    protected abstract @Nullable Object functionExit(ITmfEvent var1);

    protected abstract int getProcessId(ITmfEvent var1);

    protected @Nullable String getProcessName(ITmfEvent event) {
        Object resolved = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), ProcessNameAspect.class, (ITmfEvent)event);
        return resolved instanceof String ? (String)resolved : null;
    }

    protected abstract long getThreadId(ITmfEvent var1);

    protected @Nullable String getThreadName(ITmfEvent event) {
        Object resolved = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), ThreadNameAspect.class, (ITmfEvent)event);
        return resolved instanceof String ? (String)resolved : null;
    }
}

