/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.callstack.core.sampled.callgraph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ICallStackSymbol;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.CallGraph;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.incubator.callstack.core.flamechart.IEventCallStackProvider;
import org.eclipse.tracecompass.incubator.callstack.core.sampled.callgraph.AggregatedStackTraces;
import org.eclipse.tracecompass.incubator.callstack.core.symbol.CallStackSymbolFactory;
import org.eclipse.tracecompass.incubator.internal.callstack.core.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public abstract class ProfilingCallGraphAnalysisModule
extends TmfAbstractAnalysisModule
implements ICallGraphProvider,
IEventCallStackProvider {
    private @Nullable ITmfEventRequest fRequest;
    private final Set<ICallStackElement> fRootElements = new HashSet<ICallStackElement>();
    private @Nullable CallGraph fFullRangeCallGraph;

    protected Collection<ICallStackElement> getRootElements() {
        return this.fRootElements;
    }

    public void addRootElement(ICallStackElement element) {
        this.fRootElements.add(element);
    }

    @Override
    public CallGraph getCallGraph(ITmfTimestamp start, ITmfTimestamp end) {
        CallGraph cg = this.executeForRange(new TmfTimeRange(start, end));
        if (cg == null) {
            return CallGraph.EMPTY_GRAPH;
        }
        return cg;
    }

    @Override
    public CallGraph getCallGraph() {
        CallGraph cg = this.fFullRangeCallGraph;
        if (cg == null) {
            return CallGraph.EMPTY_GRAPH;
        }
        return cg;
    }

    @Override
    public AggregatedCallSite createCallSite(ICallStackSymbol symbol) {
        return new AggregatedStackTraces(symbol);
    }

    public AggregatedCallSite getCallSite(ICallStackElement dstGroup, long[] stackTrace, long ts) {
        if (stackTrace.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Get callsite, the received array should not be null");
        }
        AggregatedCallSite prevCallsite = this.createCallSite(CallStackSymbolFactory.createSymbol(stackTrace[stackTrace.length - 1], dstGroup, ts));
        int i = stackTrace.length - 2;
        while (i >= 0) {
            AggregatedCallSite callsite = this.createCallSite(CallStackSymbolFactory.createSymbol(stackTrace[i], dstGroup, ts));
            callsite.addCallee(prevCallsite);
            prevCallsite = callsite;
            --i;
        }
        return prevCallsite;
    }

    protected abstract @Nullable Pair<ICallStackElement, AggregatedCallSite> getProfiledStackTrace(ITmfEvent var1);

    protected boolean executeAnalysis(@NonNull IProgressMonitor monitor) throws TmfAnalysisException {
        CallGraph callgraph = this.executeForRange(TmfTimeRange.ETERNITY);
        if (callgraph == null) {
            return false;
        }
        this.fFullRangeCallGraph = callgraph;
        return true;
    }

    private @Nullable CallGraph executeForRange(TmfTimeRange range) {
        CallGraph callGraph;
        block5: {
            ITmfTrace trace = this.getTrace();
            if (trace == null) {
                throw new NullPointerException("Trace has not been set, yet the analysis is being run!");
            }
            Object request = this.fRequest;
            if (request != null && !request.isCompleted()) {
                request.cancel();
            }
            try {
                callGraph = new CallGraph();
                this.fRequest = request = new ProfilingEventRequest(trace, callGraph, range);
                trace.sendRequest(request);
                request.waitForCompletion();
                if (request.isCompleted()) break block5;
                return null;
            }
            catch (InterruptedException e) {
                Activator.getInstance().logError("Request interrupted", (Throwable)e);
                return null;
            }
        }
        return callGraph;
    }

    protected void canceling() {
        ITmfEventRequest req = this.fRequest;
        if (req != null && !req.isCompleted()) {
            req.cancel();
        }
    }

    private class ProfilingEventRequest
    extends TmfEventRequest {
        private final ITmfTrace fTrace;
        private final CallGraph fCallGraph;

        public ProfilingEventRequest(ITmfTrace trace, CallGraph callgraph, TmfTimeRange range) {
            super(TmfEvent.class, range, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.fTrace = trace;
            this.fCallGraph = callgraph;
        }

        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == this.fTrace) {
                this.processEvent(event);
            } else if (this.fTrace instanceof TmfExperiment) {
                for (ITmfTrace childTrace : ((TmfExperiment)this.fTrace).getTraces()) {
                    if (childTrace != event.getTrace()) continue;
                    this.processEvent(event);
                }
            }
        }

        private void processEvent(ITmfEvent event) {
            Pair<ICallStackElement, AggregatedCallSite> perfCallSite = ProfilingCallGraphAnalysisModule.this.getProfiledStackTrace(event);
            if (perfCallSite == null) {
                return;
            }
            this.fCallGraph.addAggregatedCallSite((ICallStackElement)perfCallSite.getFirst(), (AggregatedCallSite)perfCallSite.getSecond());
        }
    }
}

