/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph;

import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ICallStackSymbol;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ProcessStatusInterval;
import org.eclipse.tracecompass.incubator.internal.callstack.core.symbol.StringSymbol;

public class AggregatedThreadStatus
extends AggregatedCallSite {
    private final ProcessStatus fStatus;
    private long fLength = 0L;

    public AggregatedThreadStatus(ProcessStatus status) {
        super((ICallStackSymbol)new StringSymbol(status));
        this.fStatus = status;
    }

    public AggregatedThreadStatus(AggregatedThreadStatus status) {
        super(status.getSymbol());
        this.fStatus = status.fStatus;
        this.fLength = status.fLength;
    }

    public void update(ProcessStatusInterval interval) {
        this.fLength += interval.getLength();
    }

    public ProcessStatus getProcessStatus() {
        return this.fStatus;
    }

    public String toString() {
        return "Aggregated Thread status for " + this.fStatus + ": " + this.fLength;
    }

    public long getLength() {
        return this.fLength;
    }

    public AggregatedCallSite copyOf() {
        return new AggregatedThreadStatus(this);
    }

    protected void mergeData(AggregatedCallSite other) {
        if (other instanceof AggregatedThreadStatus) {
            this.fLength += ((AggregatedThreadStatus)other).getLength();
        }
    }
}

