/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.InstrumentedCallStackAnalysis;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class FlameChartArrowProvider {
    private final ITmfTrace fTrace;

    public FlameChartArrowProvider(ITmfTrace trace) {
        this.fTrace = trace;
    }

    public List<ITmfStateInterval> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        if (filter == null) {
            return Collections.emptyList();
        }
        long start = filter.getStart();
        long end = filter.getEnd();
        InstrumentedCallStackAnalysis csModule = null;
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)this.fTrace, InstrumentedCallStackAnalysis.class);
        Iterator iterator = modules.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        csModule = (InstrumentedCallStackAnalysis)iterator.next();
        csModule.schedule();
        List<@NonNull ITmfStateInterval> edges = csModule.getLinks(start, end, (IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
        return edges;
    }
}

