/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.views.cct;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.CallGraph;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.incubator.callstack.core.sampled.callgraph.AggregatedStackTraces;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.views.cct.Messages;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class CallingContextTreeViewer
extends AbstractTmfTreeViewer {
    private static final Format TIME_FORMATTER = new SubSecondTimeWithUnitFormat();
    private static final Format DECIMAL_FORMATTER = new DecimalFormat("###,###.##");
    private static final Comparator<CCTCallSiteEntry> COMPARATOR = (o1, o2) -> Long.compare(o2.getCallSite().getLength(), o1.getCallSite().getLength());
    private MenuManager fTablePopupMenuManager;
    private String fAnalysisId;
    private Collection<ISymbolProvider> fSymbolProviders = Collections.emptyList();
    private static final String[] COLUMN_NAMES = new String[]{Objects.requireNonNull(Messages.CallingContextTreeViewer_CallSite), Objects.requireNonNull(Messages.CallingContextTreeViewer_NbCalls), Objects.requireNonNull(Messages.CallingContextTreeViewer_Duration), Objects.requireNonNull(Messages.CallingContextTreeViewer_SelfTime), Objects.requireNonNull(Messages.CallingContextTreeViewer_CpuTime)};

    public CallingContextTreeViewer(@Nullable Composite parent, String analysisId) {
        super(parent, false);
        this.fAnalysisId = analysisId;
        this.setLabelProvider((IBaseLabelProvider)new CallingContextTreeLabelProvider());
        this.fTablePopupMenuManager = new MenuManager();
        this.fTablePopupMenuManager.setRemoveAllWhenShown(true);
        this.fTablePopupMenuManager.addMenuListener(manager -> {
            TreeViewer viewer = this.getTreeViewer();
            ISelection selection = viewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (manager != null) {
                    this.appendToTablePopupMenu(manager, sel);
                }
            }
        });
        Menu tablePopup = this.fTablePopupMenuManager.createContextMenu((Control)this.getTreeViewer().getTree());
        Tree tree = this.getTreeViewer().getTree();
        tree.setMenu(tablePopup);
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return new ITmfTreeColumnDataProvider(){

            public List<@Nullable TmfTreeColumnData> getColumnData() {
                ArrayList<@Nullable TmfTreeColumnData> columns = new ArrayList<TmfTreeColumnData>();
                TmfTreeColumnData column = new TmfTreeColumnData(COLUMN_NAMES[0]);
                column.setAlignment(16384);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (!(e1 instanceof CCTCallSiteEntry) || !(e2 instanceof CCTCallSiteEntry)) {
                            return 0;
                        }
                        CCTCallSiteEntry n1 = (CCTCallSiteEntry)((Object)e1);
                        CCTCallSiteEntry n2 = (CCTCallSiteEntry)((Object)e2);
                        return n1.getName().compareTo(n2.getName());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[1]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (!(e1 instanceof CCTCallSiteEntry) || !(e2 instanceof CCTCallSiteEntry)) {
                            return 0;
                        }
                        CCTCallSiteEntry n1 = (CCTCallSiteEntry)((Object)e1);
                        CCTCallSiteEntry n2 = (CCTCallSiteEntry)((Object)e2);
                        AggregatedCallSite callsite1 = n1.getCallSite();
                        AggregatedCallSite callsite2 = n2.getCallSite();
                        if (callsite1 instanceof AggregatedCalledFunction && callsite2 instanceof AggregatedCalledFunction) {
                            return Long.compare(((AggregatedCalledFunction)callsite1).getNbCalls(), ((AggregatedCalledFunction)callsite2).getNbCalls());
                        }
                        if (callsite1 instanceof AggregatedStackTraces && callsite2 instanceof AggregatedStackTraces) {
                            return Long.compare(((AggregatedStackTraces)callsite1).getLength(), ((AggregatedStackTraces)callsite2).getLength());
                        }
                        if (callsite1 instanceof AggregatedCalledFunction && callsite2 instanceof AggregatedStackTraces) {
                            return 1;
                        }
                        if (callsite1 instanceof AggregatedStackTraces && callsite2 instanceof AggregatedCalledFunction) {
                            return -1;
                        }
                        return 0;
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[2]);
                column.setPercentageProvider((TmfTreeColumnData.ITmfColumnPercentageProvider)new CCTPercentageProvider());
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (!(e1 instanceof CCTCallSiteEntry) || !(e2 instanceof CCTCallSiteEntry)) {
                            return 0;
                        }
                        CCTCallSiteEntry n1 = (CCTCallSiteEntry)((Object)e1);
                        CCTCallSiteEntry n2 = (CCTCallSiteEntry)((Object)e2);
                        AggregatedCallSite callsite1 = n1.getCallSite();
                        AggregatedCallSite callsite2 = n2.getCallSite();
                        if (callsite1 instanceof AggregatedCalledFunction && callsite2 instanceof AggregatedCalledFunction) {
                            return Long.compare(((AggregatedCalledFunction)callsite1).getDuration(), ((AggregatedCalledFunction)callsite2).getDuration());
                        }
                        if (callsite1 instanceof AggregatedCalledFunction && callsite2 instanceof AggregatedStackTraces) {
                            return 1;
                        }
                        if (callsite1 instanceof AggregatedStackTraces && callsite2 instanceof AggregatedCalledFunction) {
                            return -1;
                        }
                        return 0;
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[3]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (!(e1 instanceof CCTCallSiteEntry) || !(e2 instanceof CCTCallSiteEntry)) {
                            return 0;
                        }
                        CCTCallSiteEntry n1 = (CCTCallSiteEntry)((Object)e1);
                        CCTCallSiteEntry n2 = (CCTCallSiteEntry)((Object)e2);
                        AggregatedCallSite callsite1 = n1.getCallSite();
                        AggregatedCallSite callsite2 = n2.getCallSite();
                        if (callsite1 instanceof AggregatedCalledFunction && callsite2 instanceof AggregatedCalledFunction) {
                            return Long.compare(((AggregatedCalledFunction)callsite1).getSelfTime(), ((AggregatedCalledFunction)callsite2).getSelfTime());
                        }
                        if (callsite1 instanceof AggregatedCalledFunction && callsite2 instanceof AggregatedStackTraces) {
                            return 1;
                        }
                        if (callsite1 instanceof AggregatedStackTraces && callsite2 instanceof AggregatedCalledFunction) {
                            return -1;
                        }
                        return 0;
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[4]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (!(e1 instanceof CCTCallSiteEntry) || !(e2 instanceof CCTCallSiteEntry)) {
                            return 0;
                        }
                        CCTCallSiteEntry n1 = (CCTCallSiteEntry)((Object)e1);
                        CCTCallSiteEntry n2 = (CCTCallSiteEntry)((Object)e2);
                        AggregatedCallSite callsite1 = n1.getCallSite();
                        AggregatedCallSite callsite2 = n2.getCallSite();
                        if (callsite1 instanceof AggregatedCalledFunction && callsite2 instanceof AggregatedCalledFunction) {
                            return Long.compare(((AggregatedCalledFunction)callsite1).getCpuTime(), ((AggregatedCalledFunction)callsite2).getCpuTime());
                        }
                        if (callsite1 instanceof AggregatedCalledFunction && callsite2 instanceof AggregatedStackTraces) {
                            return 1;
                        }
                        if (callsite1 instanceof AggregatedStackTraces && callsite2 instanceof AggregatedCalledFunction) {
                            return -1;
                        }
                        return 0;
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData("");
                columns.add(column);
                return columns;
            }
        };
    }

    private Set<ICallGraphProvider> getCallGraphs() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            Iterable callgraphModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ICallGraphProvider.class);
            return StreamSupport.stream(callgraphModules.spliterator(), false).filter(m -> {
                if (m instanceof IAnalysisModule) {
                    return ((IAnalysisModule)m).getId().equals(this.fAnalysisId);
                }
                return true;
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public void initializeDataSource(ITmfTrace trace) {
        Set<ICallGraphProvider> modules = this.getCallGraphs();
        this.fSymbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(trace);
        modules.forEach(m -> {
            if (m instanceof IAnalysisModule) {
                ((IAnalysisModule)m).schedule();
            }
        });
    }

    protected void appendToTablePopupMenu(IMenuManager manager, IStructuredSelection sel) {
    }

    protected static String toFormattedString(double value) {
        return String.format("%s", TIME_FORMATTER.format(value));
    }

    protected @Nullable ITmfTreeViewerEntry updateElements(ITmfTrace trace, long start, long end, boolean isSelection) {
        Set<ICallGraphProvider> modules = this.getCallGraphs();
        if (modules.isEmpty()) {
            return null;
        }
        modules.forEach(m -> {
            if (m instanceof IAnalysisModule) {
                ((IAnalysisModule)m).waitForCompletion();
            }
        });
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        List entryList = root.getChildren();
        for (ICallGraphProvider module : modules) {
            if (isSelection) {
                this.setStats(start, end, entryList, module, true, (IProgressMonitor)new NullProgressMonitor());
            }
            this.setStats(start, start, entryList, module, false, (IProgressMonitor)new NullProgressMonitor());
        }
        return root;
    }

    private void setStats(long start, long end, List<ITmfTreeViewerEntry> entryList, ICallGraphProvider module, boolean isSelection, IProgressMonitor monitor) {
        CallGraph callGraph = null;
        callGraph = start != end ? module.getCallGraph(TmfTimestamp.fromNanos((long)start), TmfTimestamp.fromNanos((long)end)) : module.getCallGraph();
        Collection elements = callGraph.getElements();
        for (ICallStackElement element : elements) {
            CCTElementEntry entry = new CCTElementEntry(element, callGraph);
            entryList.add((ITmfTreeViewerEntry)entry);
        }
    }

    @TmfSignalHandler
    public void windowRangeUpdated(@Nullable TmfWindowRangeUpdatedSignal signal) {
    }

    protected String getTypeLabel() {
        return Objects.requireNonNull(Messages.CallingContextTreeViewer_LabelType);
    }

    protected String getTotalLabel() {
        return Objects.requireNonNull(Messages.CallingContextTreeViewer_LabelTotal);
    }

    protected String getSelectionLabel() {
        return Objects.requireNonNull(Messages.CallingContextTreeViewer_LabelSelection);
    }

    protected class CCTCallSiteEntry
    extends TmfTreeViewerEntry {
        private final AggregatedCallSite fCallSite;
        private final CallGraph fCallGraph;
        private @Nullable List<ITmfTreeViewerEntry> fChildren;

        public CCTCallSiteEntry(AggregatedCallSite callsite, CallGraph callGraph, TmfTreeViewerEntry parent) {
            super(callsite.getSymbol().resolve(CallingContextTreeViewer.this.fSymbolProviders));
            this.fChildren = null;
            this.fCallSite = callsite;
            this.fCallGraph = callGraph;
            this.setParent((ITmfTreeViewerEntry)parent);
        }

        public AggregatedCallSite getCallSite() {
            return this.fCallSite;
        }

        public boolean hasChildren() {
            return !this.fCallSite.getCallees().isEmpty();
        }

        public List<ITmfTreeViewerEntry> getChildren() {
            List<ITmfTreeViewerEntry> children = this.fChildren;
            if (children == null) {
                ArrayList<CCTCallSiteEntry> cctChildren = new ArrayList<CCTCallSiteEntry>();
                for (AggregatedCallSite callsite : this.fCallSite.getCallees()) {
                    CCTCallSiteEntry entry = new CCTCallSiteEntry(callsite, this.fCallGraph, this);
                    int index = Collections.binarySearch(cctChildren, entry, COMPARATOR);
                    cctChildren.add(index < 0 ? -index - 1 : index, entry);
                }
                this.fChildren = children = new ArrayList<ITmfTreeViewerEntry>(cctChildren);
            }
            return children;
        }
    }

    protected class CCTElementEntry
    extends TmfTreeViewerEntry {
        private final ICallStackElement fElement;
        private final CallGraph fCallGraph;
        private @Nullable List<ITmfTreeViewerEntry> fChildren;

        public CCTElementEntry(ICallStackElement element, CallGraph callgraph) {
            super(element.getName());
            this.fChildren = null;
            this.fElement = element;
            this.fCallGraph = callgraph;
        }

        public ICallStackElement getElement() {
            return this.fElement;
        }

        public boolean hasChildren() {
            return true;
        }

        public List<ITmfTreeViewerEntry> getChildren() {
            List<ITmfTreeViewerEntry> children = this.fChildren;
            if (children == null) {
                children = this.fElement.isLeaf() ? this.getChildrenCallSites() : this.getChildrenElements();
                this.fChildren = children;
            }
            return children;
        }

        public long getTotalLength() {
            List<ITmfTreeViewerEntry> childrenCallSites = this.getChildrenCallSites();
            long length = 0L;
            for (ITmfTreeViewerEntry callsiteEntry : childrenCallSites) {
                length += ((CCTCallSiteEntry)callsiteEntry).getCallSite().getLength();
            }
            return length;
        }

        private List<ITmfTreeViewerEntry> getChildrenElements() {
            ArrayList<ITmfTreeViewerEntry> list = new ArrayList<ITmfTreeViewerEntry>();
            Collection children = this.fElement.getChildren();
            for (ICallStackElement elem : children) {
                list.add((ITmfTreeViewerEntry)new CCTElementEntry(elem, this.fCallGraph));
            }
            return list;
        }

        private List<ITmfTreeViewerEntry> getChildrenCallSites() {
            ArrayList<ITmfTreeViewerEntry> list = new ArrayList<ITmfTreeViewerEntry>();
            Collection cct = this.fCallGraph.getCallingContextTree(this.fElement);
            for (AggregatedCallSite callsite : cct) {
                list.add((ITmfTreeViewerEntry)new CCTCallSiteEntry(callsite, this.fCallGraph, this));
            }
            return list;
        }
    }

    private static class CCTPercentageProvider
    implements TmfTreeColumnData.ITmfColumnPercentageProvider {
        private CCTPercentageProvider() {
        }

        public double getPercentage(@Nullable Object data) {
            double value = 0.0;
            if (data instanceof CCTCallSiteEntry) {
                CCTCallSiteEntry entry = (CCTCallSiteEntry)((Object)data);
                AggregatedCallSite callSite = entry.getCallSite();
                CCTCallSiteEntry parentEntry = entry;
                while (parentEntry != null && !(parentEntry instanceof CCTElementEntry)) {
                    parentEntry = parentEntry.getParent();
                }
                if (parentEntry != null) {
                    value = (double)callSite.getLength() / (double)((CCTElementEntry)((Object)parentEntry)).getTotalLength();
                }
            }
            return value;
        }
    }

    protected static class CallingContextTreeLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        protected CallingContextTreeLabelProvider() {
        }

        public String getColumnText(@Nullable Object element, int columnIndex) {
            String value = "";
            if (element instanceof HiddenTreeViewerEntry) {
                if (columnIndex == 0) {
                    value = ((HiddenTreeViewerEntry)((Object)element)).getName();
                }
            } else if (element instanceof CCTElementEntry) {
                CCTElementEntry entry = (CCTElementEntry)((Object)element);
                if (columnIndex == 0) {
                    return String.valueOf(entry.getName());
                }
                value = "";
            } else if (element instanceof CCTCallSiteEntry) {
                CCTCallSiteEntry entry = (CCTCallSiteEntry)((Object)element);
                if (columnIndex == 0) {
                    return String.valueOf(entry.getName());
                }
                AggregatedCallSite callSite = entry.getCallSite();
                if (callSite instanceof AggregatedCalledFunction) {
                    value = CallingContextTreeLabelProvider.getStringForColumn((AggregatedCalledFunction)callSite, columnIndex);
                } else if (callSite instanceof AggregatedStackTraces) {
                    value = CallingContextTreeLabelProvider.getStringForColumn((AggregatedStackTraces)callSite, columnIndex);
                }
            }
            return Objects.requireNonNull(value);
        }

        private static String getStringForColumn(AggregatedStackTraces callsite, int columnIndex) {
            if (columnIndex == 1) {
                return String.format("%s", DECIMAL_FORMATTER.format(callsite.getLength()));
            }
            return "";
        }

        private static String getStringForColumn(AggregatedCalledFunction callsite, int columnIndex) {
            long cpuTime;
            if (columnIndex == 1) {
                return String.format("%s", DECIMAL_FORMATTER.format(callsite.getNbCalls()));
            }
            if (columnIndex == 2) {
                return CallingContextTreeViewer.toFormattedString(callsite.getDuration());
            }
            if (columnIndex == 3) {
                return CallingContextTreeViewer.toFormattedString(callsite.getSelfTime());
            }
            if (columnIndex == 4 && (cpuTime = callsite.getCpuTime()) != -1L) {
                return CallingContextTreeViewer.toFormattedString(cpuTime);
            }
            return "";
        }
    }

    protected class HiddenTreeViewerEntry
    extends TmfTreeViewerEntry {
        public HiddenTreeViewerEntry(String name) {
            super(name);
        }
    }
}

