/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.callstack.core.callgraph;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.callstack.core.base.CallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackGroupDescriptor;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.AllGroupDescriptor;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.CallGraph;

public final class CallGraphGroupBy {
    private CallGraphGroupBy() {
    }

    public static CallGraph groupCallGraphBy(ICallStackGroupDescriptor groupBy, CallGraph callGraph) {
        if (groupBy.equals(AllGroupDescriptor.getInstance())) {
            return CallGraphGroupBy.groupCallGraphByAll(callGraph);
        }
        CallGraph cg = new CallGraph();
        callGraph.getElements().forEach(g -> CallGraphGroupBy.searchForGroups(g, groupBy, callGraph, null, cg));
        return cg;
    }

    private static void addGroupData(ICallStackElement srcGroup, CallGraph srcCg, ICallStackElement dstGroup, CallGraph callGraph) {
        srcCg.getCallingContextTree(srcGroup).forEach(acs -> {
            AggregatedCallSite acsCopy = acs.copyOf();
            callGraph.addAggregatedCallSite(dstGroup, acsCopy);
        });
        srcGroup.getChildrenElements().forEach(group -> CallGraphGroupBy.addGroupData(group, srcCg, dstGroup, callGraph));
    }

    private static CallGraph groupCallGraphByAll(CallGraph callGraph) {
        CallGraph cg = new CallGraph();
        CallStackElement allGroup = new CallStackElement("All", AllGroupDescriptor.getInstance(), null, null);
        callGraph.getElements().forEach(g -> CallGraphGroupBy.addGroupData(g, callGraph, allGroup, cg));
        return cg;
    }

    private static void searchForGroups(ICallStackElement element, ICallStackGroupDescriptor groupBy, CallGraph callGraph, @Nullable ICallStackElement parentElement, CallGraph newCg) {
        if (element.getGroup().equals(groupBy)) {
            CallStackElement groupedElement = new CallStackElement(element.getName(), groupBy, null, parentElement);
            if (parentElement != null) {
                parentElement.addChild(groupedElement);
            }
            CallGraphGroupBy.addGroupData(element, callGraph, groupedElement, newCg);
            return;
        }
        CallStackElement groupedElement = new CallStackElement(element.getName(), element.getGroup(), element.getNextGroup(), parentElement);
        if (parentElement != null) {
            parentElement.addChild(groupedElement);
        }
        element.getChildrenElements().forEach(g -> CallGraphGroupBy.searchForGroups(g, groupBy, callGraph, groupedElement, newCg));
    }
}

