/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.callstack.core.callgraph;

import java.util.Collection;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ICallStackSymbol;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackGroupDescriptor;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.CallGraph;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;

public interface ICallGraphProvider
extends IWeightedTreeProvider<ICallStackSymbol, ICallStackElement, AggregatedCallSite> {
    public Collection<ICallStackGroupDescriptor> getGroupDescriptors();

    public CallGraph getCallGraph(ITmfTimestamp var1, ITmfTimestamp var2);

    public CallGraph getCallGraph();

    default public Collection<AggregatedCallSite> getTreesFor(ICallStackElement element) {
        CallGraph callGraph = this.getCallGraph();
        return callGraph.getCallingContextTree(element);
    }

    default public Collection<AggregatedCallSite> getTrees(ICallStackElement element, ITmfTimestamp start, ITmfTimestamp end) {
        CallGraph callGraph = this.getCallGraph(start, end);
        return callGraph.getCallingContextTree(element);
    }

    default public Collection<ICallStackElement> getElements() {
        CallGraph callGraph = this.getCallGraph();
        return callGraph.getElements();
    }

    public AggregatedCallSite createCallSite(Object var1);
}

