/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.core.analysis.spanlife;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.analysis.spanlife.SpanLifeAnalysis;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.analysis.spanlife.SpanLifeEntryModel;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SpanLifeDataProvider
extends AbstractTimeGraphDataProvider<SpanLifeAnalysis, TimeGraphEntryModel> {
    private static final int MARKER_SIZE = 500;
    private static final String ERROR = "error";
    private static final String EVENT = "event";
    private static final String MESSAGE = "message";
    private static final String STACK = "stack";
    private static final String OTHER = "other";
    public static final String SUFFIX = ".dataprovider";

    public SpanLifeDataProvider(ITmfTrace trace, SpanLifeAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ITmfStateSystem ss = ((SpanLifeAnalysis)this.getAnalysisModule()).getStateSystem();
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        @NonNull @NonNull Map entries = this.getSelectedEntries(filter);
        Collection<@NonNull V> quarks = entries.values();
        long startTime = filter.getStart();
        long hoverTime = filter.getTimesRequested()[1];
        long endTime = filter.getEnd();
        if (ss == null || quarks.size() != 1 || !((SpanLifeAnalysis)this.getAnalysisModule()).isQueryable(hoverTime)) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        int traceLogsQuark = -2;
        try {
            String traceId = ss.getFullAttributePathArray(((Integer)quarks.iterator().next()).intValue())[0];
            traceLogsQuark = ss.getQuarkRelative(ss.getQuarkAbsolute(new String[]{traceId}), new String[]{"logs"});
        }
        catch (AttributeNotFoundException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        int spanLogQuark = SpanLifeDataProvider.getLogQuark(ss, ss.getAttributeName(((Integer)quarks.iterator().next()).intValue()), ss.getSubAttributes(traceLogsQuark, false));
        try {
            HashMap<@NonNull String, @NonNull String> retMap = new HashMap<String, String>();
            if (spanLogQuark != -2) {
                Long ssStartTime = startTime == Long.MIN_VALUE ? ss.getStartTime() : startTime;
                Long ssEndTime = endTime == Long.MIN_VALUE ? ss.getCurrentEndTime() : endTime;
                Long deviationAccepted = (ssEndTime - ssStartTime) / 500L;
                for (ITmfStateInterval state : ss.query2D(Collections.singletonList(spanLogQuark), Math.max(hoverTime - deviationAccepted, ssStartTime), Math.min(hoverTime + deviationAccepted, ssEndTime))) {
                    String[] fields;
                    Object object = state.getValue();
                    if (!(object instanceof String)) continue;
                    String logs = (String)object;
                    String timestamp = TmfTimestamp.fromNanos((long)state.getStartTime()).toString();
                    if (timestamp != null) {
                        retMap.put("log timestamp", timestamp);
                    }
                    String[] stringArray = fields = logs.split("~");
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String field = stringArray[n2];
                        retMap.put(field.substring(0, field.indexOf(58)), field.substring(field.indexOf(58) + 1));
                        ++n2;
                    }
                    return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                }
            }
            return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        catch (StateSystemDisposedException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
    }

    public @NonNull String getId() {
        return String.valueOf(((SpanLifeAnalysis)this.getAnalysisModule()).getId()) + SUFFIX;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable TimeGraphModel getRowModel(@NonNull ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(parameters);
        @NonNull @NonNull Map entries = this.getSelectedEntries(filter);
        Collection times = SpanLifeDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        for (ITmfStateInterval interval : ss.query2D(entries.values(), times)) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(parameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        ArrayList<@NonNull TimeGraphRowModel> rows = new ArrayList<TimeGraphRowModel>();
        for (Map.Entry entry : entries.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            ArrayList eventList = new ArrayList();
            for (ITmfStateInterval interval : intervals.get((Object)((Integer)entry.getValue()))) {
                long startTime = interval.getStartTime();
                long duration = interval.getEndTime() - startTime + 1L;
                Object state = interval.getValue();
                TimeGraphState value = new TimeGraphState(startTime, duration, state == null ? Integer.MIN_VALUE : 0);
                this.applyFilterAndAddState(eventList, (ITimeGraphState)value, (Long)entry.getKey(), predicates, monitor);
            }
            rows.add(new TimeGraphRowModel(((Long)entry.getKey()).longValue(), eventList));
        }
        return new TimeGraphModel(rows);
    }

    protected boolean isCacheable() {
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull TmfTreeModel<@NonNull TimeGraphEntryModel> getTree(@NonNull ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ImmutableList.Builder builder = new ImmutableList.Builder();
        long rootId = this.getId(-1);
        builder.add((Object)new TimeGraphEntryModel(rootId, -1L, Collections.singletonList(String.valueOf(this.getTrace().getName())), ss.getStartTime(), ss.getCurrentEndTime()));
        Iterator iterator = ss.getSubAttributes(-1, false).iterator();
        while (iterator.hasNext()) {
            int traceQuark = (Integer)iterator.next();
            this.addTrace(ss, (ImmutableList.Builder<TimeGraphEntryModel>)builder, traceQuark, rootId);
        }
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    private void addTrace(ITmfStateSystem ss, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<@NonNull TimeGraphEntryModel> builder, int quark, long parentId) {
        int ustSpansQuark;
        int openTracingSpansQuark;
        ArrayList<Integer> logsQuarks;
        try {
            int logsQuark = ss.getQuarkRelative(quark, new String[]{"logs"});
            logsQuarks = ss.getSubAttributes(logsQuark, false);
        }
        catch (AttributeNotFoundException e) {
            logsQuarks = new ArrayList();
        }
        try {
            openTracingSpansQuark = ss.getQuarkRelative(quark, new String[]{"openTracingSpans"});
        }
        catch (AttributeNotFoundException e) {
            return;
        }
        long traceQuarkId = this.getId(quark);
        builder.add((Object)new TimeGraphEntryModel(traceQuarkId, parentId, Collections.singletonList(ss.getAttributeName(quark)), ss.getStartTime(), ss.getCurrentEndTime()));
        try {
            ustSpansQuark = ss.getQuarkRelative(quark, new String[]{"ustSpans"});
        }
        catch (AttributeNotFoundException e) {
            this.addChildren(ss, builder, openTracingSpansQuark, traceQuarkId, logsQuarks);
            return;
        }
        this.addUstChildren(ss, builder, openTracingSpansQuark, ustSpansQuark, traceQuarkId, logsQuarks);
    }

    private void addChildren(ITmfStateSystem ss, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<@NonNull TimeGraphEntryModel> builder, int quark, long parentId, List<Integer> logsQuarks) {
        for (Integer child : ss.getSubAttributes(quark, false)) {
            long childId = this.getId(child);
            String childName = ss.getAttributeName(child.intValue());
            if (childName.equals("logs")) continue;
            ArrayList<SpanLifeEntryModel.LogEvent> logs = new ArrayList<SpanLifeEntryModel.LogEvent>();
            int logQuark = SpanLifeDataProvider.getLogQuark(ss, childName, logsQuarks);
            try {
                for (ITmfStateInterval interval : ss.query2D(Collections.singletonList(logQuark), ss.getStartTime(), ss.getCurrentEndTime())) {
                    if (interval.getStateValue().isNull()) continue;
                    logs.add(new SpanLifeEntryModel.LogEvent(interval.getStartTime(), SpanLifeDataProvider.getLogType(String.valueOf(interval.getValue()))));
                }
            }
            catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException throwable) {
                // empty catch block
            }
            builder.add((Object)new SpanLifeEntryModel(childId, parentId, Collections.singletonList(SpanLifeDataProvider.getSpanName(childName)), ss.getStartTime(), ss.getCurrentEndTime(), logs, SpanLifeDataProvider.getErrorTag(childName), SpanLifeDataProvider.getProcessName(childName)));
            this.addChildren(ss, builder, child, childId, logsQuarks);
        }
    }

    private void addUstChildren(ITmfStateSystem ss, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<@NonNull TimeGraphEntryModel> builder, int openTracingQuark, int ustQuark, long parentId, List<Integer> logsQuarks) {
        for (Integer child : ss.getSubAttributes(openTracingQuark, false)) {
            int ustSpan;
            String childName = ss.getAttributeName(child.intValue());
            ArrayList<SpanLifeEntryModel.LogEvent> logs = new ArrayList<SpanLifeEntryModel.LogEvent>();
            int logQuark = SpanLifeDataProvider.getLogQuark(ss, childName, logsQuarks);
            try {
                for (ITmfStateInterval interval : ss.query2D(Collections.singletonList(logQuark), ss.getStartTime(), ss.getCurrentEndTime())) {
                    if (interval.getStateValue().isNull()) continue;
                    logs.add(new SpanLifeEntryModel.LogEvent(interval.getStartTime(), SpanLifeDataProvider.getLogType(String.valueOf(interval.getValue()))));
                }
            }
            catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException interval) {
                // empty catch block
            }
            String spanId = SpanLifeDataProvider.getSpanId(childName);
            try {
                ustSpan = ss.getQuarkRelative(ustQuark, new String[]{spanId});
            }
            catch (AttributeNotFoundException e) {
                return;
            }
            long childId = this.getId(ustSpan);
            builder.add((Object)new SpanLifeEntryModel(childId, parentId, Collections.singletonList(SpanLifeDataProvider.getSpanName(childName)), ss.getStartTime(), ss.getCurrentEndTime(), logs, SpanLifeDataProvider.getErrorTag(childName), SpanLifeDataProvider.getProcessName(childName)));
            this.addUstChildren(ss, builder, child, ustQuark, childId, logsQuarks);
        }
    }

    private static int getLogQuark(ITmfStateSystem ss, String spanName, List<Integer> logsQuarks) {
        for (int logsQuark : logsQuarks) {
            if (!ss.getAttributeName(logsQuark).equals(SpanLifeDataProvider.getSpanId(spanName))) continue;
            return logsQuark;
        }
        return -2;
    }

    private static String getSpanName(String attributeName) {
        int slashPos = attributeName.lastIndexOf(47);
        slashPos = attributeName.lastIndexOf(47, slashPos);
        slashPos = attributeName.lastIndexOf(47, slashPos);
        return attributeName.substring(0, Math.max(0, slashPos));
    }

    private static String getSpanId(String attributeName) {
        String[] attributeInfo = attributeName.split("/");
        return attributeInfo[attributeInfo.length - 3];
    }

    private static Boolean getErrorTag(String attributeName) {
        String[] attributeInfo = attributeName.split("/");
        return attributeInfo[attributeInfo.length - 2].equals("true");
    }

    private static String getProcessName(String attributeName) {
        return attributeName.substring(attributeName.lastIndexOf(47) + 1);
    }

    private static String getLogType(String logs) {
        String[] logsArray = logs.split("~");
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < logsArray.length) {
            builder.append(logsArray[i].substring(0, logsArray[i].indexOf(58)));
            ++i;
        }
        String types = builder.toString();
        if (types.contains(ERROR)) {
            return ERROR;
        }
        if (types.contains(EVENT)) {
            return EVENT;
        }
        if (types.contains(MESSAGE)) {
            return MESSAGE;
        }
        if (types.contains(STACK)) {
            return STACK;
        }
        return OTHER;
    }

    @Deprecated
    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        return this.fetchArrows(parameters, monitor);
    }

    @Deprecated
    public TmfModelResponse<Map<String, String>> fetchTooltip(SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
        return this.fetchTooltip(parameters, monitor);
    }
}

