/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.core.data.provider;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.scripting.core.data.provider.ScriptedEntryDataModel;
import org.eclipse.tracecompass.incubator.scripting.core.analysis.ScriptedAnalysis;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;

public class ScriptedTimeGraphDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<ITimeGraphEntryModel> {
    public static final String ID = "org.eclipse.tracecompass.tmf.analysis.xml.core.output.DataDrivenTimeGraphDataProvider";
    private final ITmfStateSystem fSs;
    private final Map<Long, Integer> fIDToDisplayQuark = new HashMap<Long, Integer>();
    private final String fId;
    private final Function<Map<String, Object>, @Nullable List<ITimeGraphEntryModel>> fEntryMethod;
    private final @Nullable Function<Map<String, Object>, @Nullable List<ITimeGraphArrow>> fArrowMethod;
    private final @Nullable Function<Map<String, Object>, @Nullable List<ITimeGraphRowModel>> fRowModelMethod;

    public ScriptedTimeGraphDataProvider(ScriptedAnalysis analysis, Function<Map<String, Object>, @Nullable List<ITimeGraphEntryModel>> entryMethod, @Nullable Function<Map<String, Object>, @Nullable List<ITimeGraphRowModel>> rowModelMethod, @Nullable Function<Map<String, Object>, @Nullable List<ITimeGraphArrow>> arrowMethod) {
        super(analysis.getTrace());
        this.fSs = (ITmfStateSystem)Objects.requireNonNull(analysis.getStateSystem(true));
        this.fEntryMethod = entryMethod;
        this.fRowModelMethod = rowModelMethod;
        this.fArrowMethod = arrowMethod;
        this.fId = "org.eclipse.tracecompass.incubator.scripting.dataprovider:" + analysis.getName();
    }

    public TmfModelResponse<TmfTreeModel<ITimeGraphEntryModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        boolean isComplete = this.fSs.waitUntilBuilt(0L);
        List<Object> entryList = this.fEntryMethod.apply(fetchParameters);
        if (entryList == null) {
            entryList = Collections.emptyList();
        }
        for (ITimeGraphEntryModel entry : entryList) {
            if (!(entry instanceof ScriptedEntryDataModel)) continue;
            this.fIDToDisplayQuark.put(entry.getId(), ((ScriptedEntryDataModel)entry).getQuark());
        }
        ITmfResponse.Status status = isComplete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING;
        String msg = isComplete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING;
        return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), entryList), status, msg);
    }

    public @NonNull String getId() {
        return this.fId;
    }

    public @NonNull TmfModelResponse<TimeGraphModel> fetchRowModel(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Function<Map<String, Object>, @Nullable List<ITimeGraphRowModel>> rowModelMethod = this.fRowModelMethod;
        try {
            List<Object> rowModels;
            List<ITimeGraphRowModel> list = rowModels = rowModelMethod != null ? rowModelMethod.apply(fetchParameters) : this.getDefaultRowModels(fetchParameters, monitor);
            if (rowModels == null) {
                rowModels = Collections.emptyList();
            }
            return new TmfModelResponse((Object)new TimeGraphModel(rowModels), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable List<ITimeGraphRowModel> getDefaultRowModels(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        HashMap<Integer, TimeGraphRowModel> quarkToRow = new HashMap<Integer, TimeGraphRowModel>();
        Collection<Object> selectedItems = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (selectedItems == null) {
            selectedItems = this.fIDToDisplayQuark.keySet();
        }
        for (Long id : selectedItems) {
            Integer quark = this.fIDToDisplayQuark.get(id);
            if (quark == null) continue;
            quarkToRow.put(quark, new TimeGraphRowModel(id.longValue(), new ArrayList()));
        }
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(fetchParameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        long currentEndTime = this.fSs.getCurrentEndTime();
        for (ITmfStateInterval interval : this.fSs.query2D(quarkToRow.keySet(), ScriptedTimeGraphDataProvider.getTimes(this.fSs, DataProviderParameterUtils.extractTimeRequested(fetchParameters)))) {
            if (monitor != null && monitor.isCanceled()) {
                return Collections.emptyList();
            }
            ITimeGraphRowModel row = (ITimeGraphRowModel)quarkToRow.get(interval.getAttribute());
            if (row == null) continue;
            @NonNull List states = row.getStates();
            TimeGraphState timeGraphState = ScriptedTimeGraphDataProvider.getStateFromInterval(interval, currentEndTime);
            this.applyFilterAndAddState(states, (ITimeGraphState)timeGraphState, row.getEntryID(), predicates, monitor);
        }
        for (ITimeGraphRowModel model : quarkToRow.values()) {
            model.getStates().sort(Comparator.comparingLong(ITimeGraphState::getStartTime));
        }
        return new ArrayList<ITimeGraphRowModel>(quarkToRow.values());
    }

    private static TimeGraphState getStateFromInterval(ITmfStateInterval statusInterval, long currentEndTime) {
        long time = statusInterval.getStartTime();
        long duration = Math.min(currentEndTime, statusInterval.getEndTime() + 1L) - time;
        Object o = statusInterval.getValue();
        if (o instanceof Integer) {
            return new TimeGraphState(time, duration, ((Integer)o).intValue(), String.valueOf(o));
        }
        if (o instanceof Long) {
            long l = (Long)o;
            return new TimeGraphState(time, duration, (int)l, "0x" + Long.toHexString(l));
        }
        if (o instanceof String) {
            return new TimeGraphState(time, duration, Integer.MIN_VALUE, (String)o);
        }
        if (o instanceof Double) {
            return new TimeGraphState(time, duration, ((Double)o).intValue());
        }
        return new TimeGraphState(time, duration, Integer.MIN_VALUE);
    }

    private static Set<Long> getTimes(ITmfStateSystem key, @Nullable List<Long> list) {
        if (list == null) {
            return Collections.emptySet();
        }
        HashSet<@NonNull Long> times = new HashSet<Long>();
        for (long t : list) {
            if (key.getStartTime() > t || t > key.getCurrentEndTime()) continue;
            times.add(t);
        }
        return times;
    }

    public @NonNull TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Function<Map<String, Object>, @Nullable List<ITimeGraphArrow>> arrowMethod = this.fArrowMethod;
        if (arrowMethod == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        List<ITimeGraphArrow> arrows = arrowMethod.apply(fetchParameters);
        boolean completed = this.fSs.waitUntilBuilt(0L);
        ITmfResponse.Status status = completed ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING;
        String msg = completed ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING;
        return new TmfModelResponse(arrows, status, msg);
    }

    public @NonNull TmfModelResponse<Map<String, String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    @Deprecated
    public TmfModelResponse<List<ITimeGraphEntryModel>> fetchTree(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        TmfModelResponse<TmfTreeModel<ITimeGraphEntryModel>> modelResponse = this.fetchTree(parameters, monitor);
        TmfTreeModel model = (TmfTreeModel)modelResponse.getModel();
        return new TmfModelResponse((Object)(model == null ? null : model.getEntries()), modelResponse.getStatus(), modelResponse.getStatusMessage());
    }

    @Deprecated
    public TmfModelResponse<List<ITimeGraphRowModel>> fetchRowModel(SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
        TmfModelResponse<TimeGraphModel> modelResponse = this.fetchRowModel(parameters, monitor);
        TimeGraphModel model = (TimeGraphModel)modelResponse.getModel();
        return new TmfModelResponse((Object)(model == null ? null : model.getRows()), modelResponse.getStatus(), modelResponse.getStatusMessage());
    }

    @Deprecated
    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        return this.fetchArrows(parameters, monitor);
    }

    @Deprecated
    public TmfModelResponse<Map<String, String>> fetchTooltip(SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
        return this.fetchTooltip(parameters, monitor);
    }
}

