/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.core.trace;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.collect.BufferedBlockingQueue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;

public class ScriptEventRequest
extends TmfEventRequest {
    private static final int DEFAULT_EVENTS_QUEUE_SIZE = 127;
    private static final int DEFAULT_EVENTS_CHUNK_SIZE = 127;
    private static final EndEvent END_EVENT = new EndEvent();
    private final BufferedBlockingQueue<ITmfEvent> fEventsQueue = new BufferedBlockingQueue(127, 127);
    private final EventIterator fEventIterator = new EventIterator(this.fEventsQueue);

    public ScriptEventRequest() {
        super(ITmfEvent.class, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND, 100);
    }

    public void handleData(@NonNull ITmfEvent event) {
        super.handleData(event);
        this.fEventsQueue.put((Object)event);
    }

    public synchronized void done() {
        super.done();
        this.fEventsQueue.put((Object)END_EVENT);
        this.fEventsQueue.flushInputBuffer();
    }

    public synchronized void cancel() {
        super.cancel();
        this.fEventsQueue.put((Object)END_EVENT);
        this.fEventsQueue.flushInputBuffer();
    }

    public Iterator<ITmfEvent> getEventIterator() {
        return this.fEventIterator;
    }

    private static class EndEvent
    extends TmfEvent {
        public EndEvent() {
            super(null, -1L, null, null, null);
        }
    }

    private static class EventIterator
    implements Iterator<ITmfEvent> {
        private final BufferedBlockingQueue<ITmfEvent> fEventsQueue;
        private @Nullable ITmfEvent fNext;

        public EventIterator(BufferedBlockingQueue<ITmfEvent> eventsQueue) {
            this.fEventsQueue = eventsQueue;
        }

        @Override
        public synchronized boolean hasNext() {
            ITmfEvent next = this.fNext;
            if (next == null) {
                this.fNext = next = (ITmfEvent)this.fEventsQueue.take();
            }
            return next != END_EVENT;
        }

        @Override
        public synchronized ITmfEvent next() {
            if (this.hasNext()) {
                ITmfEvent next = this.fNext;
                this.fNext = null;
                if (next != null) {
                    return next;
                }
            }
            throw new NoSuchElementException("No more elements in the queue");
        }
    }
}

