/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.scripting.core.analysis;

import java.util.Iterator;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.scripting.core.analysis.TmfScriptAnalysis;
import org.eclipse.tracecompass.incubator.internal.scripting.core.trace.ScriptEventRequest;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class ScriptedAnalysis {
    private final ITmfTrace fTrace;
    private final String fName;

    ScriptedAnalysis(ITmfTrace activeTrace, String name) {
        this.fTrace = activeTrace;
        this.fName = name;
    }

    @WrapToScript
    public @Nullable ITmfStateSystemBuilder getStateSystem(@ScriptParameter(defaultValue="false") boolean useExisting) {
        TmfScriptAnalysis analysisModule = (TmfScriptAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)this.fTrace, TmfScriptAnalysis.class, (String)"org.eclipse.tracecompass.incubator.scripting.analysis");
        if (analysisModule == null) {
            return null;
        }
        return (ITmfStateSystemBuilder)analysisModule.getStateSystem(this.fName, useExisting);
    }

    @WrapToScript
    public Iterator<ITmfEvent> getEventIterator() {
        ScriptEventRequest scriptEventRequest = new ScriptEventRequest();
        this.fTrace.sendRequest((ITmfEventRequest)scriptEventRequest);
        return scriptEventRequest.getEventIterator();
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public String getName() {
        return this.fName;
    }
}

