/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IExportContainer;
import org.eclipse.wst.jsdt.core.IExportDeclaration;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.CategoryFilterActionGroup;
import org.eclipse.wst.jsdt.internal.ui.actions.LexicalSortingAction;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.actions.MemberFilterActionGroup;

public class MembersView
extends JavaBrowsingPart
implements IPropertyChangeListener {
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private CategoryFilterActionGroup fCategoryFilterActionGroup;

    public MembersView() {
        this.setHasWorkingSetFilter(false);
        this.setHasCustomSetFilter(true);
        JavaScriptPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer"};
                }
            };
        }
        return super.getAdapter(key);
    }

    @Override
    protected JavaUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(3976933559779370L, 1);
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.wst.jsdt.ui.members_view_context";
    }

    @Override
    protected String getLinkToEditorKey() {
        return "org.eclipse.wst.jsdt.ui.browsing.memberstoeditor";
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        ProblemTreeViewer viewer = new ProblemTreeViewer(parent, 2);
        ColoredViewersManager.install((StructuredViewer)viewer);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)viewer, JavaScriptUI.ID_MEMBERS_VIEW);
        return viewer;
    }

    @Override
    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)new LexicalSortingAction(this.getViewer(), JavaScriptUI.ID_MEMBERS_VIEW));
        this.fMemberFilterActionGroup.contributeToToolBar(tbm);
        super.fillToolBar(tbm);
    }

    @Override
    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.fCategoryFilterActionGroup = new CategoryFilterActionGroup(this.getViewer(), this.getViewSite().getId(), this.getCategoryFilterActionGroupInput());
        this.fCategoryFilterActionGroup.contributeToViewMenu(actionBars.getMenuManager());
    }

    @Override
    protected void setInput(Object input) {
        super.setInput(input);
        if (this.fCategoryFilterActionGroup != null) {
            this.fCategoryFilterActionGroup.setInput(this.getCategoryFilterActionGroupInput());
        }
    }

    private IJavaScriptElement[] getCategoryFilterActionGroupInput() {
        Object input = this.getInput();
        if (input instanceof IJavaScriptElement) {
            return new IJavaScriptElement[]{(IJavaScriptElement)input};
        }
        return new IJavaScriptElement[0];
    }

    @Override
    protected boolean isValidInput(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            return type.isBinary() || type.getDeclaringType() == null;
        }
        return false;
    }

    @Override
    protected boolean isValidElement(Object element) {
        if (element instanceof IMember) {
            return super.isValidElement(((IMember)element).getDeclaringType());
        }
        if (element instanceof IImportDeclaration) {
            return this.isValidElement(((IJavaScriptElement)element).getParent());
        }
        if (element instanceof IImportContainer) {
            Object input = this.getViewer().getInput();
            if (input instanceof IJavaScriptElement) {
                IJavaScriptUnit cu = (IJavaScriptUnit)((IJavaScriptElement)input).getAncestor(5);
                if (cu != null) {
                    IJavaScriptUnit importContainerCu = (IJavaScriptUnit)((IJavaScriptElement)element).getAncestor(5);
                    return cu.equals(importContainerCu);
                }
                IClassFile cf = (IClassFile)((IJavaScriptElement)input).getAncestor(6);
                IClassFile importContainerCf = (IClassFile)((IJavaScriptElement)element).getAncestor(6);
                return cf != null && cf.equals(importContainerCf);
            }
        } else {
            Object input;
            if (element instanceof IExportDeclaration) {
                return this.isValidElement(((IJavaScriptElement)element).getParent());
            }
            if (element instanceof IExportContainer && (input = this.getViewer().getInput()) instanceof IJavaScriptElement) {
                IJavaScriptUnit cu = (IJavaScriptUnit)((IJavaScriptElement)input).getAncestor(5);
                if (cu != null) {
                    IJavaScriptUnit exportContainerCu = (IJavaScriptUnit)((IJavaScriptElement)element).getAncestor(5);
                    return cu.equals(exportContainerCu);
                }
                IClassFile cf = (IClassFile)((IJavaScriptElement)input).getAncestor(6);
                IClassFile exportContainerCf = (IClassFile)((IJavaScriptElement)element).getAncestor(6);
                return cf != null && cf.equals(exportContainerCf);
            }
        }
        return false;
    }

    @Override
    protected IJavaScriptElement findElementToSelect(IJavaScriptElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                if (((IType)je).getDeclaringType() == null) {
                    return null;
                }
                return je;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: {
                return je;
            }
            case 13: {
                IJavaScriptUnit cu = (IJavaScriptUnit)je.getParent().getParent();
                try {
                    Object selectedElement;
                    if (cu.getImports()[0].equals(je) && (selectedElement = this.getSingleElementFromSelection(this.getViewer().getSelection())) instanceof IImportContainer) {
                        return (IImportContainer)selectedElement;
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
                return je;
            }
            case 16: {
                IJavaScriptUnit cu = (IJavaScriptUnit)je.getParent().getParent();
                try {
                    Object selectedElement;
                    if (cu.getExports()[0].equals(je) && (selectedElement = this.getSingleElementFromSelection(this.getViewer().getSelection())) instanceof IExportContainer) {
                        return (IExportContainer)selectedElement;
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
                return je;
            }
        }
        return null;
    }

    @Override
    protected IJavaScriptElement findInputForJavaElement(IJavaScriptElement je) {
        if (je == null || !je.exists() || je.getJavaScriptProject() != null && !je.getJavaScriptProject().isOnIncludepath(je)) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                IType type = ((IType)je).getDeclaringType();
                if (type == null) {
                    return je;
                }
                return this.findInputForJavaElement((IJavaScriptElement)type);
            }
            case 5: {
                return this.getTypeForCU((IJavaScriptUnit)je);
            }
            case 6: {
                return this.findInputForJavaElement((IJavaScriptElement)((IClassFile)je).getType());
            }
            case 13: {
                return this.findInputForJavaElement(je.getParent());
            }
            case 12: {
                IJavaScriptElement parent = je.getParent();
                if (parent instanceof IJavaScriptUnit) {
                    return this.getTypeForCU((IJavaScriptUnit)parent);
                }
                if (parent instanceof IClassFile) {
                    return this.findInputForJavaElement(parent);
                }
                return null;
            }
            case 16: {
                return this.findInputForJavaElement(je.getParent());
            }
            case 15: {
                IJavaScriptElement parent = je.getParent();
                if (parent instanceof IJavaScriptUnit) {
                    return this.getTypeForCU((IJavaScriptUnit)parent);
                }
                if (parent instanceof IClassFile) {
                    return this.findInputForJavaElement(parent);
                }
                return null;
            }
        }
        if (je instanceof IMember) {
            return this.findInputForJavaElement((IJavaScriptElement)((IMember)je).getDeclaringType());
        }
        return null;
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.fMemberFilterActionGroup.saveState(memento);
    }

    @Override
    protected void restoreState(IMemento memento) {
        super.restoreState(memento);
        this.fMemberFilterActionGroup.restoreState(memento);
        this.getViewer().getControl().setRedraw(false);
        this.getViewer().refresh();
        this.getViewer().getControl().setRedraw(true);
    }

    @Override
    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)MembersView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    boolean isInputAWorkingCopy() {
        IJavaScriptUnit cu;
        Object input = this.getViewer().getInput();
        if (input instanceof IJavaScriptElement && (cu = (IJavaScriptUnit)((IJavaScriptElement)input).getAncestor(5)) != null) {
            return cu.isWorkingCopy();
        }
        return false;
    }

    @Override
    protected void restoreSelection() {
        IEditorPart editor = this.getViewSite().getPage().getActiveEditor();
        if (editor != null) {
            this.setSelectionFromEditor((IWorkbenchPart)editor);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            this.getViewer().refresh();
        }
    }

    @Override
    public void dispose() {
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fCategoryFilterActionGroup != null) {
            this.fCategoryFilterActionGroup.dispose();
            this.fCategoryFilterActionGroup = null;
        }
        super.dispose();
        JavaScriptPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

