/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.ui.views.contextswitch;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.incubator.internal.kernel.ui.views.contextswitch.ContextSwitchEntry;
import org.eclipse.tracecompass.incubator.internal.kernel.ui.views.contextswitch.ContextSwitchTimeEvent;
import org.eclipse.tracecompass.incubator.internal.kernel.ui.views.contextswitch.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

public class ContextSwitchPresentationProvider
extends TimeGraphPresentationProvider {
    private static State[] getStateValues() {
        return State.values();
    }

    private static State getEventState(TimeEvent event) {
        if (event instanceof ContextSwitchTimeEvent) {
            ContextSwitchTimeEvent tevent = (ContextSwitchTimeEvent)event;
            ContextSwitchEntry entry = (ContextSwitchEntry)event.getEntry();
            if (entry.hasId()) {
                if (tevent.fRate == ContextSwitchTimeEvent.ContextSwitchRate.NONE) {
                    return State.NONE;
                }
                if (tevent.fRate == ContextSwitchTimeEvent.ContextSwitchRate.LOW) {
                    return State.LOW;
                }
                if (tevent.fRate == ContextSwitchTimeEvent.ContextSwitchRate.MODERATE) {
                    return State.MODERATE;
                }
                if (tevent.fRate == ContextSwitchTimeEvent.ContextSwitchRate.HIGH) {
                    return State.HIGH;
                }
                if (tevent.fRate == ContextSwitchTimeEvent.ContextSwitchRate.CRITICAL) {
                    return State.CRITICAL;
                }
            }
        }
        return null;
    }

    public int getStateTableIndex(ITimeEvent event) {
        ContextSwitchEntry entry = (ContextSwitchEntry)event.getEntry();
        if (!entry.hasId()) {
            return -2;
        }
        State state = ContextSwitchPresentationProvider.getEventState((TimeEvent)event);
        if (state == State.NONE) {
            return -1;
        }
        if (state != null) {
            return state.ordinal();
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public StateItem[] getStateTable() {
        State[] states = ContextSwitchPresentationProvider.getStateValues();
        StateItem[] stateTable = new StateItem[states.length];
        int i = 0;
        while (i < stateTable.length) {
            State state = states[i];
            stateTable[i] = new StateItem(state.rgb, state.toString());
            ++i;
        }
        return stateTable;
    }

    public Map<String, Object> getSpecificEventStyle(ITimeEvent event) {
        ContextSwitchEntry csEntry;
        double mean;
        ContextSwitchTimeEvent csEvent;
        Map specificEventStyle = super.getSpecificEventStyle(event);
        if (event instanceof ContextSwitchTimeEvent && (csEvent = (ContextSwitchTimeEvent)event).getEntry() instanceof ContextSwitchEntry && (mean = (csEntry = (ContextSwitchEntry)csEvent.getEntry()).getMean()) != 0.0) {
            HashMap<String, Object> retVal = new HashMap<String, Object>();
            int count = csEvent.getCount();
            float heightFactor = (float)((double)csEvent.getValue() / mean / (double)count * 0.33);
            heightFactor = (float)Math.max((double)0.1f, Math.min((double)heightFactor, 1.0));
            retVal.put(ITimeEventStyleStrings.heightFactor(), Float.valueOf(heightFactor));
            return retVal;
        }
        return specificEventStyle;
    }

    public String getEventName(ITimeEvent event) {
        State state = ContextSwitchPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.toString();
        }
        if (event instanceof NullTimeEvent) {
            return null;
        }
        return Messages.ContextSwitchPresentationProvider_CPU;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            TimeEvent tEvent = (TimeEvent)event;
            ContextSwitchEntry entry = (ContextSwitchEntry)event.getEntry();
            if (entry.hasId()) {
                retMap.put(Messages.ContextSwitchPresentationProvider_NumberOfContextSwitch, Integer.toString(tEvent.getValue()));
            }
        }
        return retMap;
    }

    private static enum State {
        CRITICAL(new RGB(0, 191, 255)),
        HIGH(new RGB(0, 207, 255)),
        MODERATE(new RGB(128, 218, 235)),
        LOW(new RGB(135, 206, 250)),
        NONE(new RGB(0, 0, 0));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

