/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.traceevent.core.analysis.callstack;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxPidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.incubator.callstack.core.base.EdgeStateValue;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.CallStackStateProvider;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.TraceEventAspects;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class TraceEventCallStackProvider
extends CallStackStateProvider {
    private static final int VERSION_NUMBER = 7;
    private static final int UNSET_ID = -1;
    static final String EDGES = "EDGES";
    private static final Function<EventTreeKey, Integer> FUNCTION = s -> {
        try {
            return Integer.decode(((EventTreeKey)s).fId);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    };
    private ITmfTimestamp fSafeTime;
    private final Map<Integer, Deque<Long>> fStack = new TreeMap<Integer, Deque<Long>>();
    private final ITmfEventAspect<?> fIdAspect;
    private final ITmfEventAspect<?> fCatAspect;
    private final Map<EventTreeKey, Long> fEdgeStartTimes = new HashMap<EventTreeKey, Long>();
    private final Map<EventTreeKey, HostThread> fEdgeSrcHosts = new HashMap<EventTreeKey, HostThread>();
    private final Map<EventTreeKey, Integer> fIdCache = new HashMap<EventTreeKey, Integer>();

    public TraceEventCallStackProvider(@NonNull ITmfTrace trace) {
        super(trace);
        ITmfStateSystemBuilder stateSystemBuilder = this.getStateSystemBuilder();
        if (stateSystemBuilder != null) {
            int quark = stateSystemBuilder.getQuarkAbsoluteAndAdd(new String[]{"dummy entry to make gpu entries work"});
            stateSystemBuilder.modifyAttribute(0L, (Object)0, quark);
        }
        this.fSafeTime = trace.getStartTime();
        this.fIdAspect = TraceEventAspects.ID_ASPECT;
        this.fCatAspect = TraceEventAspects.CATEGORY_ASPECT;
    }

    protected @Nullable String getProcessName(@NonNull ITmfEvent event) {
        String pName = super.getProcessName(event);
        if (pName == null) {
            pName = (String)event.getContent().getFieldValue(String.class, new String[]{"pid"});
        }
        if (pName == null) {
            int processId = this.getProcessId(event);
            pName = processId == -1 ? "UNKNOWN" : Integer.toString(processId);
        }
        return pName;
    }

    protected @Nullable String getThreadName(@NonNull ITmfEvent event) {
        String tName = super.getThreadName(event);
        if (tName == null) {
            tName = (String)event.getContent().getFieldValue(String.class, new String[]{"tname"});
        }
        if (tName == null) {
            long threadId = this.getThreadId(event);
            tName = threadId == -1L ? "UNKNOWN" : Long.toString(threadId);
        }
        return tName;
    }

    protected int getProcessId(@NonNull ITmfEvent event) {
        Integer pid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxPidAspect.class, (ITmfEvent)event);
        if (pid == null) {
            pid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"pid"});
        }
        return pid == null ? -1 : pid;
    }

    protected long getThreadId(@NonNull ITmfEvent event) {
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            tid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"tid"});
        }
        return tid == null ? -1 : tid;
    }

    public int getVersion() {
        return 7;
    }

    public @NonNull CallStackStateProvider getNewInstance() {
        return new TraceEventCallStackProvider(this.getTrace());
    }

    protected boolean considerEvent(@NonNull ITmfEvent event) {
        String ph = (String)event.getContent().getFieldValue(String.class, new String[]{"ph"});
        return ph != null;
    }

    protected @Nullable Object functionEntry(@NonNull ITmfEvent event) {
        if (TraceEventCallStackProvider.isEntry(event)) {
            return event.getName();
        }
        return null;
    }

    private static boolean isEntry(ITmfEvent event) {
        String phase = (String)event.getContent().getFieldValue(String.class, new String[]{"ph"});
        return "b".equals(phase) || "B".equals(phase);
    }

    protected @Nullable Object functionExit(@NonNull ITmfEvent event) {
        if (TraceEventCallStackProvider.isExit(event)) {
            return event.getName();
        }
        return null;
    }

    private static boolean isExit(ITmfEvent event) {
        String phase = (String)event.getContent().getFieldValue(String.class, new String[]{"ph"});
        return "e".equals(phase) || "E".equals(phase);
    }

    protected void eventHandle(ITmfEvent event) {
        if (!this.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        long timestamp = event.getTimestamp().toNanos();
        this.updateCloseCandidates(ss, timestamp);
        String processName = this.getProcessName(event);
        String ph = (String)event.getContent().getFieldValue(String.class, new String[]{"ph"});
        if (ph == null) {
            return;
        }
        switch (ph) {
            case "B": 
            case "b": {
                this.handleStart(event, ss, timestamp, processName);
                break;
            }
            case "X": {
                Number duration = (Number)event.getContent().getFieldValue(Number.class, new String[]{"dur"});
                if (duration == null) break;
                this.handleComplete(event, ss, processName);
                break;
            }
            case "E": 
            case "e": {
                this.handleEnd(event, ss, timestamp, processName);
                break;
            }
            case "s": {
                this.updateSLinks(event, ss, timestamp, processName);
                break;
            }
            case "t": {
                this.updateTLinks(event, ss, timestamp, processName);
                break;
            }
            case "f": {
                this.updateFLinks(event, ss, timestamp, processName);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void updateCloseCandidates(ITmfStateSystemBuilder ss, long timestamp) {
        for (Map.Entry<Integer, Deque<Long>> stackEntry : this.fStack.entrySet()) {
            Deque<Long> stack = stackEntry.getValue();
            if (stack.isEmpty()) continue;
            Long closeCandidate = stack.pop();
            while (closeCandidate != null && closeCandidate < timestamp) {
                ss.popAttribute(closeCandidate.longValue(), stackEntry.getKey().intValue());
                Long l = closeCandidate = stack.isEmpty() ? null : stack.pop();
            }
            if (closeCandidate == null) continue;
            stack.push(closeCandidate);
        }
    }

    private EventTreeKey getEventTreeKey(ITmfEvent event) {
        String sScope;
        String sCat;
        String sId = (String)event.getContent().getFieldValue(String.class, new String[]{"id"});
        if (sId == null) {
            Object resolve = this.fIdAspect.resolve(event);
            if (resolve == null) {
                resolve = 0;
            }
            sId = String.valueOf(resolve);
        }
        if ((sCat = (String)event.getContent().getFieldValue(String.class, new String[]{"cat"})) == null) {
            Object resolve = this.fCatAspect.resolve(event);
            if (resolve == null) {
                resolve = 0;
            }
            sCat = String.valueOf(resolve);
        }
        return (sScope = (String)event.getContent().getFieldValue(String.class, new String[]{"scope"})) == null ? new EventTreeKey(sCat, sId) : new EventTreeKey(sCat, sId, sScope);
    }

    private void updateFLinks(ITmfEvent event, ITmfStateSystemBuilder ss, long ts, String processName) {
        EventTreeKey key = this.getEventTreeKey(event);
        String bindingPoint = (String)event.getContent().getFieldValue(String.class, new String[]{"bp"});
        if (bindingPoint == null) {
            bindingPoint = "n";
        }
        int tid = (int)this.getThreadId(event);
        Long startTime = this.fEdgeStartTimes.get(key);
        if (startTime == null) {
            return;
        }
        HostThread srcHostThread = this.fEdgeSrcHosts.remove(key);
        HostThread currHostThread = new HostThread(event.getTrace().getHostId(), Integer.valueOf(tid));
        if (bindingPoint == "e" && !this.validateEnclosingSlice(event, ss, ts, processName, tid)) {
            return;
        }
        if (srcHostThread != null) {
            int edgeQuark = TraceEventCallStackProvider.getAvailableEdgeQuark(ss, startTime);
            EdgeStateValue edgeStateValue = new EdgeStateValue(this.fIdCache.computeIfAbsent(key, FUNCTION).intValue(), srcHostThread, currHostThread);
            ss.modifyAttribute(startTime.longValue(), (Object)edgeStateValue, edgeQuark);
            ss.modifyAttribute(ts, null, edgeQuark);
        }
    }

    private void updateTLinks(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long ts, String processName) {
        EventTreeKey key = this.getEventTreeKey(event);
        int tid = (int)this.getThreadId(event);
        Long startTime = this.fEdgeStartTimes.get(key);
        if (startTime == null) {
            return;
        }
        HostThread srcHostThread = this.fEdgeSrcHosts.remove(key);
        HostThread currHostThread = new HostThread(event.getTrace().getHostId(), Integer.valueOf(tid));
        if (!this.validateEnclosingSlice(event, ss, ts, processName, tid)) {
            return;
        }
        if (srcHostThread != null) {
            int edgeQuark = TraceEventCallStackProvider.getAvailableEdgeQuark(ss, startTime);
            EdgeStateValue edgeStateValue = new EdgeStateValue(this.fIdCache.computeIfAbsent(key, FUNCTION).intValue(), srcHostThread, currHostThread);
            ss.modifyAttribute(startTime.longValue(), (Object)edgeStateValue, edgeQuark);
            ss.modifyAttribute(ts, null, edgeQuark);
        }
        this.fEdgeStartTimes.put(key, ts);
        this.fEdgeSrcHosts.put(key, currHostThread);
    }

    private boolean validateEnclosingSlice(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long ts, String processName, int tid) {
        int callstackQuark;
        String threadName = this.getThreadName(event);
        if (threadName == null) {
            threadName = Long.toString(tid);
        }
        if ((callstackQuark = ss.optQuarkAbsolute(new String[]{"Processes", processName, threadName, "CallStack"})) < 0) {
            return false;
        }
        try {
            ITmfStateInterval interval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss, (long)ts, (int)callstackQuark);
            return interval != null && interval.getValue() != null;
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            return false;
        }
    }

    private void updateSLinks(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long ts, String processName) {
        EventTreeKey key = this.getEventTreeKey(event);
        int tid = (int)this.getThreadId(event);
        ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
        if (ssb == null) {
            return;
        }
        HostThread currHostThread = new HostThread(event.getTrace().getHostId(), Integer.valueOf(tid));
        if (!this.validateEnclosingSlice(event, ss, ts, processName, tid)) {
            return;
        }
        this.fEdgeStartTimes.put(key, ts);
        this.fEdgeSrcHosts.put(key, currHostThread);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static int getAvailableEdgeQuark(ITmfStateSystemBuilder ssb, long startTime) {
        int edgeRoot = ssb.getQuarkAbsoluteAndAdd(new String[]{EDGES});
        @NonNull List subQuarks = ssb.getSubAttributes(edgeRoot, false);
        Iterator iterator = subQuarks.iterator();
        while (iterator.hasNext()) {
            int quark = (Integer)iterator.next();
            long start = ssb.getOngoingStartTime(quark);
            Object value = ssb.queryOngoing(quark);
            if (value != null || start > startTime) continue;
            return quark;
        }
        return ssb.getQuarkRelativeAndAdd(edgeRoot, new String[]{Integer.toString(subQuarks.size())});
    }

    private void handleStart(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp, String processName) {
        Object functionBeginName = this.functionEntry(event);
        if (functionBeginName != null) {
            int processQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Processes", processName});
            int pid = this.getProcessId(event);
            ss.modifyAttribute(timestamp, (Object)pid, processQuark);
            String threadName = this.getThreadName(event);
            long threadId = this.getThreadId(event);
            if (threadName == null) {
                threadName = Long.toString(threadId);
            }
            int threadQuark = ss.getQuarkRelativeAndAdd(processQuark, new String[]{threadName});
            ss.modifyAttribute(timestamp, (Object)threadId, threadQuark);
            int callStackQuark = ss.getQuarkRelativeAndAdd(threadQuark, new String[]{"CallStack"});
            ss.pushAttribute(timestamp, functionBeginName, callStackQuark);
            TraceEventCallStackProvider.prepareNextSlice(ss, callStackQuark, timestamp);
        }
    }

    private static void prepareNextSlice(ITmfStateSystemBuilder ss, int quark, long timestamp) {
        ss.pushAttribute(timestamp, (Object)"", quark);
        ss.popAttribute(timestamp, quark);
    }

    private void handleEnd(@NonNull ITmfEvent event, ITmfStateSystemBuilder ss, long timestamp, String processName) {
        Object functionExitName = this.functionExit(event);
        if (functionExitName != null) {
            int quark;
            List<Object> callStack;
            int indexOf;
            String threadName;
            String pName = processName;
            if (pName == null) {
                int processId = this.getProcessId(event);
                String string = pName = processId == -1 ? "UNKNOWN" : Integer.toString(processId);
            }
            if ((threadName = this.getThreadName(event)) == null) {
                threadName = Long.toString(this.getThreadId(event));
            }
            if ((indexOf = (callStack = TraceEventCallStackProvider.getCallStack(ss, quark = ss.getQuarkAbsoluteAndAdd(new String[]{"Processes", pName, threadName, "CallStack"}))).indexOf(functionExitName)) < 0) {
                if (functionExitName.equals("exit unknown") || functionExitName.equals("duration exit")) {
                    indexOf = callStack.size() - 1;
                } else {
                    int stackQuark = ss.optQuarkRelative(quark, new String[]{String.valueOf(callStack.size() + 1)});
                    if (stackQuark >= 0) {
                        ss.updateOngoingState(functionExitName, stackQuark);
                        ss.pushAttribute(timestamp, null, quark);
                    }
                    indexOf = callStack.size() - 1;
                }
            }
            int i = indexOf;
            while (i < callStack.size()) {
                ss.popAttribute(timestamp, quark);
                ++i;
            }
        }
    }

    private static List<Object> getCallStack(ITmfStateSystemBuilder ss, int quark) {
        ArrayList<Object> callstackObjects = new ArrayList<Object>();
        Integer currentDepth = (Integer)ss.queryOngoing(quark);
        if (currentDepth == null) {
            return callstackObjects;
        }
        int i = 0;
        while (i < currentDepth) {
            int stackQuark = ss.optQuarkRelative(quark, new String[]{String.valueOf(i + 1)});
            if (stackQuark < 0) {
                return callstackObjects;
            }
            callstackObjects.add(ss.queryOngoing(stackQuark));
            ++i;
        }
        return callstackObjects;
    }

    private void handleComplete(ITmfEvent event, ITmfStateSystemBuilder ss, String processName) {
        long startTime;
        ITmfTimestamp timestamp = event.getTimestamp();
        this.fSafeTime = this.fSafeTime.compareTo(timestamp) > 0 ? this.fSafeTime : timestamp;
        String currentProcessName = processName;
        if (currentProcessName == null) {
            int processId = this.getProcessId(event);
            currentProcessName = processId == -1 ? "UNKNOWN" : Integer.toString(processId).intern();
        }
        int processQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Processes", currentProcessName});
        long end = startTime = event.getTimestamp().toNanos();
        Number duration = (Number)event.getContent().getFieldValue(Number.class, new String[]{"dur"});
        if (duration != null) {
            end += Math.max(duration.longValue(), 0L);
        }
        String threadName = this.getThreadName(event);
        long threadId = this.getThreadId(event);
        if (threadName == null) {
            threadName = Long.toString(threadId).intern();
        }
        int threadQuark = ss.getQuarkRelativeAndAdd(processQuark, new String[]{threadName});
        ss.modifyAttribute(event.getTimestamp().toNanos(), (Object)threadId, threadQuark);
        int callStackQuark = ss.getQuarkRelativeAndAdd(threadQuark, new String[]{"CallStack"});
        ss.pushAttribute(startTime, (Object)event.getName(), callStackQuark);
        Deque stack = this.fStack.computeIfAbsent(callStackQuark, ArrayDeque::new);
        stack.push(end);
    }

    private static class EventTreeKey {
        private final String fCategory;
        private final String fId;
        private final @Nullable String fScope;

        public EventTreeKey(String category, String id) {
            this.fCategory = category;
            this.fId = id;
            this.fScope = null;
        }

        public EventTreeKey(String category, String id, String scope) {
            this.fCategory = category;
            this.fId = id;
            this.fScope = scope;
        }

        public String toString() {
            return String.valueOf(this.fCategory) + ':' + this.fId + (this.fScope == null ? "" : String.valueOf(':') + this.fScope);
        }

        public boolean equals(Object arg0) {
            boolean catAndIdEqual;
            if (!(arg0 instanceof EventTreeKey)) {
                return false;
            }
            EventTreeKey other = (EventTreeKey)arg0;
            boolean bl = catAndIdEqual = Objects.equals(this.fCategory, other.fCategory) && Objects.equals(this.fId, other.fId);
            if (catAndIdEqual && this.fScope != null && other.fScope != null) {
                return Objects.equals(this.fScope, other.fScope);
            }
            return catAndIdEqual;
        }

        public int hashCode() {
            return Objects.hash(this.fCategory, this.fId, this.fScope);
        }
    }
}

