/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class StatusBarUpdater
implements ISelectionChangedListener {
    private final long LABEL_FLAGS = 13196440454323L;
    private IStatusLineManager fStatusLineManager;

    public StatusBarUpdater(IStatusLineManager statusLineManager) {
        this.fStatusLineManager = statusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        String statusBarMessage = this.formatMessage(event.getSelection());
        this.fStatusLineManager.setMessage(statusBarMessage);
    }

    protected String formatMessage(ISelection sel) {
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IWorkbenchAdapter wbadapter;
            IStructuredSelection selection = (IStructuredSelection)sel;
            int nElements = selection.size();
            if (nElements > 1) {
                return Messages.format(JavaUIMessages.StatusBarUpdater_num_elements_selected, String.valueOf(nElements));
            }
            Object elem = selection.getFirstElement();
            if (elem instanceof IJavaScriptElement) {
                return this.formatJavaElementMessage((IJavaScriptElement)elem);
            }
            if (elem instanceof IResource) {
                return this.formatResourceMessage((IResource)elem);
            }
            if (elem instanceof PackageFragmentRootContainer) {
                PackageFragmentRootContainer container = (PackageFragmentRootContainer)elem;
                return String.valueOf(container.getLabel()) + JavaScriptElementLabels.CONCAT_STRING + container.getJavaProject().getElementName();
            }
            if (elem instanceof IJarEntryResource) {
                IJarEntryResource jarEntryResource = (IJarEntryResource)elem;
                StringBuffer buf = new StringBuffer(jarEntryResource.getName());
                buf.append(JavaScriptElementLabels.CONCAT_STRING);
                IPath fullPath = jarEntryResource.getFullPath();
                if (fullPath.segmentCount() > 1) {
                    buf.append(fullPath.removeLastSegments(1).makeRelative());
                    buf.append(JavaScriptElementLabels.CONCAT_STRING);
                }
                JavaScriptElementLabels.getPackageFragmentRootLabel(jarEntryResource.getPackageFragmentRoot(), 0x40000000000L, buf);
                return buf.toString();
            }
            if (elem instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)elem).getAdapter(IWorkbenchAdapter.class)) != null) {
                return wbadapter.getLabel(elem);
            }
        }
        return "";
    }

    private String formatJavaElementMessage(IJavaScriptElement element) {
        return JavaScriptElementLabels.getElementLabel(element, 13196440454323L);
    }

    private String formatResourceMessage(IResource element) {
        IContainer parent = element.getParent();
        if (parent != null && parent.getType() != 8) {
            return String.valueOf(element.getName()) + JavaScriptElementLabels.CONCAT_STRING + parent.getFullPath().makeRelative().toString();
        }
        return element.getName();
    }
}

