/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.fileaccess;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.incubator.internal.kernel.core.Activator;
import org.eclipse.tracecompass.incubator.internal.kernel.core.filedescriptor.FileDescriptorStateProvider;
import org.eclipse.tracecompass.incubator.internal.kernel.core.filedescriptor.HandlerParameter;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class FileAccessStateProvider
extends FileDescriptorStateProvider {
    private static final String PID = "pid";
    private static final String STDERR = "stderr";
    private static final String STDOUT = "stdout";
    private static final String STDIN = "stdin";
    private static final String ID = "org.eclipse.tracecompass.incubator.internal.kernel.core.fileacess";
    private static final String OPENAT = "openat";
    private static final String OPEN = "open";
    private static final String LTTNG_STATEDUMP_FILE_DESCRIPTOR = "lttng_statedump_file_descriptor";
    private static final Set<String> NO_NO_LIST = ImmutableSet.of((Object)"socket:", (Object)"pipe:");
    private static final int VERSION = 1;
    private final String fFileName;
    private final Map<Integer, String> fOpenContexts = new HashMap<Integer, String>();

    public FileAccessStateProvider(IKernelTrace trace) {
        super(trace, ID);
        IKernelAnalysisEventLayout layout = this.getLayout();
        this.addEventHandler(String.valueOf(layout.eventSyscallEntryPrefix()) + OPENAT, this::handleOpen);
        this.addEventHandler(String.valueOf(layout.eventSyscallExitPrefix()) + OPENAT, this::handleOpenExit);
        this.addEventHandler(String.valueOf(layout.eventSyscallEntryPrefix()) + OPEN, this::handleOpen);
        this.addEventHandler(String.valueOf(layout.eventSyscallExitPrefix()) + OPEN, this::handleOpenExit);
        this.addEventHandler(LTTNG_STATEDUMP_FILE_DESCRIPTOR, this::handleStateDump);
        this.fFileName = layout.fieldFilename();
    }

    public int getVersion() {
        return 1;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        ITmfTrace trace = this.getTrace();
        if (trace instanceof IKernelTrace) {
            return new FileAccessStateProvider((IKernelTrace)trace);
        }
        throw new IllegalStateException("Trace " + trace + " is not a kernel trace");
    }

    private void handleOpenExit(HandlerParameter hp) {
        Integer tid = hp.getTid();
        ITmfStateSystemBuilder ssb = hp.getSsb();
        long time = hp.getTime();
        ITmfEvent event = hp.getEvent();
        String fileName = this.fOpenContexts.remove(tid);
        Long ret = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldSyscallRet()});
        if (ret == null || fileName == null) {
            return;
        }
        FileAccessStateProvider.handleCommonOpen(ssb, time, tid, ret, fileName);
    }

    private static void handleCommonOpen(ITmfStateSystemBuilder ssb, long time, Integer tid, Long fd, String filename) {
        String fn = filename;
        if (fd == 0L) {
            fn = STDIN;
        } else if (fd == 1L) {
            fn = STDOUT;
        } else if (fd == 2L) {
            fn = STDERR;
        }
        if (fn.isEmpty()) {
            return;
        }
        int fileQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"RES", fn});
        int fileTidQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"RES", fn, String.valueOf(tid)});
        if (fd < 0L) {
            ssb.updateOngoingState((Object)fd, fileTidQuark);
            ssb.modifyAttribute(time, null, fileTidQuark);
            return;
        }
        ssb.updateOngoingState(null, fileTidQuark);
        ssb.modifyAttribute(time, (Object)fd, fileTidQuark);
        try {
            int tidQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"TID", String.valueOf(tid)});
            StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ssb, (long)time, (int)tidQuark, (int)1);
            int tidFileQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"TID", String.valueOf(tid), String.valueOf(fd)});
            ssb.modifyAttribute(time, (Object)fn, tidFileQuark);
            StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ssb, (long)time, (int)fileQuark, (int)1);
        }
        catch (StateValueTypeException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    private void handleOpen(HandlerParameter param) {
        ITmfEvent event = param.getEvent();
        Integer tid = param.getTid();
        String fileName = (String)event.getContent().getFieldValue(String.class, new String[]{this.fFileName});
        if (fileName == null) {
            return;
        }
        ITmfStateSystemBuilder ssb = param.getSsb();
        long time = param.getTime();
        int fileTidQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"RES", fileName, String.valueOf(tid)});
        ssb.modifyAttribute(time, (Object)0L, fileTidQuark);
        this.fOpenContexts.put(tid, fileName);
    }

    private void handleStateDump(HandlerParameter params) {
        String filename;
        Long fd;
        Long pid;
        ITmfEvent event;
        block3: {
            block2: {
                event = params.getEvent();
                ITmfEventField content = event.getContent();
                pid = (Long)content.getFieldValue(Long.class, new String[]{PID});
                fd = (Long)content.getFieldValue(Long.class, new String[]{"fd"});
                filename = (String)content.getFieldValue(String.class, new String[]{this.fFileName});
                if (pid == null || fd == null || filename == null) break block2;
                if (!NO_NO_LIST.stream().anyMatch(filename::startsWith)) break block3;
            }
            return;
        }
        int tid = pid.intValue();
        this.fOpenContexts.put(tid, filename);
        FileAccessStateProvider.handleCommonOpen(params.getSsb(), event.getTimestamp().toNanos(), tid, fd, filename);
    }
}

