/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.filedescriptor;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.incubator.internal.kernel.core.Activator;
import org.eclipse.tracecompass.incubator.internal.kernel.core.filedescriptor.HandlerParameter;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public abstract class FileDescriptorStateProvider
extends AbstractTmfStateProvider {
    public static final String TID = "TID";
    public static final String RESOURCES = "RES";
    protected static final String DESCRIPTOR = "fd";
    public static final String READ = "read";
    public static final String WRITE = "write";
    private static final String COUNT = "count";
    private static final String PREAD = "pread";
    private static final String READ64 = "read64";
    private static final String PREAD64 = "pread64";
    private static final String PWRITE = "pwrite";
    private static final String WRITE64 = "write64";
    private static final String PWRITE64 = "pwrite64";
    private static final String CLOSE = "close";
    private final Map<String, Consumer<HandlerParameter>> fHandlers = new HashMap<String, Consumer<HandlerParameter>>();
    private final IKernelAnalysisEventLayout fLayout;
    private final Map<Integer, @Nullable Long> fToRead = new HashMap<Integer, Long>();
    private final Map<Integer, @Nullable Long> fToWrite = new HashMap<Integer, Long>();
    private final Map<Integer, Long> fToClose = new HashMap<Integer, Long>();

    public FileDescriptorStateProvider(IKernelTrace trace, String id) {
        super((ITmfTrace)trace, id);
        this.fLayout = trace.getKernelEventLayout();
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + CLOSE, this::closeBegin);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + CLOSE, this::closeEnd);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + READ, this::readBegin);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + PREAD, this::readBegin);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + READ64, this::readBegin);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + PREAD64, this::readBegin);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + READ, this::readEnd);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + PREAD, this::readEnd);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + READ64, this::readEnd);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + PREAD64, this::readEnd);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + WRITE, this::writeBegin);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + PWRITE, this::writeBegin);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + WRITE64, this::writeBegin);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallEntryPrefix()) + PWRITE64, this::writeBegin);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + WRITE, this::writeEnd);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + PWRITE, this::writeEnd);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + WRITE64, this::writeEnd);
        this.addEventHandler(String.valueOf(this.getLayout().eventSyscallExitPrefix()) + PWRITE64, this::writeEnd);
    }

    protected final void addEventHandler(String eventName, Consumer<HandlerParameter> handler) {
        this.fHandlers.put(eventName, handler);
    }

    protected final void eventHandle(@NonNull ITmfEvent event) {
        ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
        if (ssb == null) {
            return;
        }
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return;
        }
        String name = event.getName();
        Consumer<HandlerParameter> eventHandler = this.fHandlers.get(name);
        if (eventHandler != null) {
            eventHandler.accept(new HandlerParameter(ssb, event, tid));
        }
    }

    protected final IKernelAnalysisEventLayout getLayout() {
        return this.fLayout;
    }

    protected static final @Nullable Long isValidFileDescriptor(ITmfStateSystem ssb, Integer tid, @Nullable Long fd) {
        if (fd == null) {
            return null;
        }
        int tidFileQuark = ssb.optQuarkAbsolute(new String[]{TID, String.valueOf(tid), String.valueOf(fd)});
        if (tidFileQuark == -2) {
            return null;
        }
        return ssb.queryOngoing(tidFileQuark) != null ? fd : null;
    }

    private void readBegin(HandlerParameter params) {
        ITmfEvent event = params.getEvent();
        Integer tid = params.getTid();
        ITmfStateSystemBuilder ssb = params.getSsb();
        Long fd = (Long)event.getContent().getFieldValue(Long.class, new String[]{DESCRIPTOR});
        if ((fd = FileDescriptorStateProvider.isValidFileDescriptor((ITmfStateSystem)ssb, tid, fd)) == null) {
            return;
        }
        Long read = (Long)event.getContent().getFieldValue(Long.class, new String[]{COUNT});
        if (read == null) {
            return;
        }
        int tidQuark = ssb.optQuarkAbsolute(new String[]{TID, String.valueOf(tid)});
        if (tidQuark == -2) {
            return;
        }
        this.fToRead.put(tid, fd);
    }

    private void readEnd(HandlerParameter params) {
        ITmfEvent event = params.getEvent();
        Integer tid = params.getTid();
        ITmfStateSystemBuilder ssb = params.getSsb();
        long time = params.getTime();
        Long count = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldSyscallRet()});
        Long fd = this.fToRead.remove(tid);
        if ((fd = FileDescriptorStateProvider.isValidFileDescriptor((ITmfStateSystem)ssb, tid, fd)) != null && count != null) {
            try {
                int fileNameQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{TID, String.valueOf(tid), String.valueOf(fd)});
                int readTid = ssb.getQuarkAbsoluteAndAdd(new String[]{TID, String.valueOf(tid), String.valueOf(fd), READ});
                StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ssb, (long)time, (int)readTid, (long)count);
                Object fileNameObj = ssb.queryOngoing(fileNameQuark);
                if (fileNameObj instanceof String) {
                    int readFile = ssb.getQuarkAbsoluteAndAdd(new String[]{RESOURCES, String.valueOf(fileNameObj), String.valueOf(tid), READ});
                    StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ssb, (long)time, (int)readFile, (long)count);
                }
            }
            catch (StateValueTypeException e) {
                Activator.getInstance().logError(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void writeBegin(HandlerParameter params) {
        ITmfEvent event = params.getEvent();
        Integer tid = params.getTid();
        ITmfStateSystemBuilder ssb = params.getSsb();
        Long fd = (Long)event.getContent().getFieldValue(Long.class, new String[]{DESCRIPTOR});
        if ((fd = FileDescriptorStateProvider.isValidFileDescriptor((ITmfStateSystem)ssb, tid, fd)) == null) {
            return;
        }
        this.fToWrite.put(tid, fd);
    }

    private void writeEnd(HandlerParameter params) {
        ITmfEvent event = params.getEvent();
        Integer tid = params.getTid();
        ITmfStateSystemBuilder ssb = params.getSsb();
        long time = params.getTime();
        Long count = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldSyscallRet()});
        Long fd = this.fToWrite.remove(tid);
        if ((fd = FileDescriptorStateProvider.isValidFileDescriptor((ITmfStateSystem)ssb, tid, fd)) != null && count != null) {
            try {
                int fileNameQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{TID, String.valueOf(tid), String.valueOf(fd)});
                int writeTid = ssb.getQuarkAbsoluteAndAdd(new String[]{TID, String.valueOf(tid), String.valueOf(fd), WRITE});
                StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ssb, (long)time, (int)writeTid, (long)count);
                Object fileNameObj = ssb.queryOngoing(fileNameQuark);
                if (fileNameObj instanceof String) {
                    int writeFile = ssb.getQuarkAbsoluteAndAdd(new String[]{RESOURCES, String.valueOf(fileNameObj), String.valueOf(tid), WRITE});
                    StateSystemBuilderUtils.incrementAttributeLong((ITmfStateSystemBuilder)ssb, (long)time, (int)writeFile, (long)count);
                }
            }
            catch (StateValueTypeException e) {
                Activator.getInstance().logError(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void closeBegin(HandlerParameter params) {
        ITmfEvent event = params.getEvent();
        ITmfStateSystemBuilder ssb = params.getSsb();
        Integer tid = params.getTid();
        Long fd = (Long)event.getContent().getFieldValue(Long.class, new String[]{DESCRIPTOR});
        if ((fd = FileDescriptorStateProvider.isValidFileDescriptor((ITmfStateSystem)ssb, tid, fd)) == null) {
            return;
        }
        this.fToClose.put(tid, fd);
    }

    private void closeEnd(HandlerParameter params) {
        ITmfEvent event = params.getEvent();
        Integer tid = params.getTid();
        ITmfStateSystemBuilder ssb = params.getSsb();
        long time = params.getTime();
        try {
            Long ret = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.getLayout().fieldSyscallRet()});
            Long fd = this.fToClose.remove(tid);
            if (ret == null || fd == null || ret < 0L) {
                return;
            }
            int tidQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{TID, String.valueOf(tid)});
            Object current = ssb.queryOngoing(tidQuark);
            if (!(current instanceof Integer)) {
                return;
            }
            if (Integer.valueOf(1).equals(current)) {
                ssb.modifyAttribute(time, null, tidQuark);
            } else {
                StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ssb, (long)time, (int)tidQuark, (int)-1);
            }
            int tidFileQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{TID, String.valueOf(tid), String.valueOf(fd)});
            Object fileName = ssb.queryOngoing(tidFileQuark);
            ssb.modifyAttribute(time, null, tidFileQuark);
            if (ssb.optQuarkAbsolute(new String[]{RESOURCES}) != -2 && fileName instanceof String) {
                int fileQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{RESOURCES, String.valueOf(fileName)});
                int fileTidQuark = ssb.getQuarkRelativeAndAdd(fileQuark, new String[]{String.valueOf(tid)});
                current = ssb.queryOngoing(fileQuark);
                if (current instanceof Integer) {
                    if (Integer.valueOf(1).equals(current)) {
                        ssb.modifyAttribute(time, null, fileQuark);
                    } else {
                        StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ssb, (long)time, (int)fileQuark, (int)-1);
                    }
                }
                ssb.modifyAttribute(time, null, fileTidQuark);
            }
        }
        catch (StateValueTypeException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }
}

