/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.ImportDeclaration;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.SourceRange;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;

public class ImportContainer
extends SourceRefElement
implements IImportContainer {
    protected ImportContainer(CompilationUnit parent) {
        super(parent);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ImportContainer)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int getElementType() {
        return 12;
    }

    @Override
    public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '#': {
                if (memento.hasMoreTokens()) {
                    String importName = memento.nextToken();
                    JavaElement importDecl = (JavaElement)((Object)this.getImport(importName));
                    return importDecl.getHandleFromMemento(memento, workingCopyOwner);
                }
                return this;
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '#';
    }

    @Override
    public IImportDeclaration getImport(String importName) {
        boolean isOnDemand;
        int index = importName.indexOf(".*");
        boolean bl = isOnDemand = index != -1;
        if (isOnDemand) {
            importName = new String(importName.substring(0, index));
        }
        return new ImportDeclaration(this, importName, isOnDemand);
    }

    @Override
    public IJavaScriptElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu = (CompilationUnit)this.parent;
        if (checkOwner && cu.isPrimary()) {
            return this;
        }
        return cu.getImportContainer();
    }

    @Override
    public ISourceRange getSourceRange() throws JavaScriptModelException {
        IJavaScriptElement[] imports = this.getChildren();
        ISourceRange firstRange = ((ISourceReference)((Object)imports[0])).getSourceRange();
        ISourceRange lastRange = ((ISourceReference)((Object)imports[imports.length - 1])).getSourceRange();
        SourceRange range = new SourceRange(firstRange.getOffset(), lastRange.getOffset() + lastRange.getLength() - firstRange.getOffset());
        return range;
    }

    @Override
    public String readableName() {
        return null;
    }

    @Override
    protected void toString(int tab, StringBuffer buffer) {
        Object info = JavaModelManager.getJavaModelManager().peekAtInfo(this);
        if (info == null || !(info instanceof JavaElementInfo)) {
            return;
        }
        IJavaScriptElement[] children = ((JavaElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            if (i > 0) {
                buffer.append("\n");
            }
            ((JavaElement)children[i]).toString(tab, buffer);
            ++i;
        }
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("<import container>");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

