/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.CRC32;
import org.eclipse.wst.jsdt.core.ast.IAssignment;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFieldReference;
import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FunctionTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class SourceTypeBinding
extends ReferenceBinding {
    private static final boolean DEBUG = false;
    private ReferenceBinding fSuperBinding;
    protected FieldBinding[] fields;
    protected MethodBinding[] methods;
    public ReferenceBinding[] memberTypes = Binding.NO_MEMBER_TYPES;
    public Scope scope;
    public ClassScope classScope;
    private SourceTypeBinding fNextType;
    private static final CRC32 checksumCalculator = new CRC32();
    private boolean fHasBuiltFieldsAndMethods = false;
    private boolean fBuildingAllFieldsAndFunctions = false;
    private char[][] fBuildingSelectors = null;
    private char[][] fBuiltSelectors = null;
    private final Object fBuildFieldsAndFunctionsLock = new Object();

    public SourceTypeBinding(char[][] compoundName, PackageBinding fPackage, Scope scope) {
        this();
        this.compoundName = compoundName;
        this.fPackage = fPackage;
        char[] cArray = this.fileName = scope == null ? null : scope.referenceCompilationUnit().getFileName();
        if (scope instanceof ClassScope) {
            this.classScope = (ClassScope)scope;
            if (this.classScope.referenceContext != null) {
                this.modifiers = this.classScope.referenceContext.modifiers;
                this.sourceName = this.classScope.referenceContext.name;
            } else {
                this.sourceName = this.classScope.inferredType.getName();
                this.modifiers = 1;
            }
        }
        this.scope = scope;
        this.fields = Binding.NO_FIELDS;
        this.methods = Binding.NO_METHODS;
        this.computeId();
    }

    protected SourceTypeBinding() {
        this.fNextType = this;
    }

    void buildFieldsAndMethods() {
        this.buildFieldsAndMethods(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFieldsAndMethods(char[] restrictToSelector) {
        Object object;
        block35: {
            Object object2 = this.fBuildFieldsAndFunctionsLock;
            synchronized (object2) {
                if (this.fBuildingAllFieldsAndFunctions || this.fHasBuiltFieldsAndMethods) {
                    return;
                }
                if (restrictToSelector != null && this.fBuildingSelectors != null && this.fBuildingSelectors.length > 0 && CharOperation.contains(restrictToSelector, this.fBuildingSelectors)) {
                    return;
                }
                if (restrictToSelector != null && this.fBuiltSelectors != null && this.fBuiltSelectors.length > 0 && CharOperation.contains(restrictToSelector, this.fBuiltSelectors)) {
                    return;
                }
                if (restrictToSelector != null) {
                    if (this.fBuildingSelectors == null) {
                        this.fBuildingSelectors = new char[1][];
                        this.fBuildingSelectors[0] = restrictToSelector;
                    } else {
                        char[][] newBuildingSelectors = new char[this.fBuildingSelectors.length + 1][];
                        System.arraycopy(this.fBuildingSelectors, 0, newBuildingSelectors, 0, this.fBuildingSelectors.length);
                        this.fBuildingSelectors = newBuildingSelectors;
                        this.fBuildingSelectors[this.fBuildingSelectors.length - 1] = restrictToSelector;
                    }
                } else {
                    this.fBuildingAllFieldsAndFunctions = true;
                }
            }
            try {
                this.buildFunctions(restrictToSelector);
                this.buildFields(restrictToSelector);
                if (restrictToSelector == null) {
                    this.fHasBuiltFieldsAndMethods = true;
                }
                break block35;
            }
            catch (Throwable throwable) {
                object = this.fBuildFieldsAndFunctionsLock;
                synchronized (object) {
                    if (restrictToSelector != null) {
                        if (this.fBuildingSelectors.length == 1) {
                            this.fBuildingSelectors = null;
                        } else {
                            char[][] newBuildingSelectors = new char[this.fBuildingSelectors.length - 1][];
                            int j = 0;
                            int i = 0;
                            while (i < this.fBuildingSelectors.length) {
                                if (!CharOperation.equals(restrictToSelector, this.fBuildingSelectors[i])) {
                                    newBuildingSelectors[j++] = this.fBuildingSelectors[i];
                                }
                                ++i;
                            }
                            this.fBuildingSelectors = newBuildingSelectors;
                        }
                        if (this.fBuiltSelectors == null) {
                            this.fBuiltSelectors = new char[1][];
                            this.fBuiltSelectors[0] = restrictToSelector;
                        } else {
                            char[][] newBuiltSelectors = new char[this.fBuiltSelectors.length + 1][];
                            System.arraycopy(this.fBuiltSelectors, 0, newBuiltSelectors, 0, this.fBuiltSelectors.length);
                            this.fBuiltSelectors = newBuiltSelectors;
                            this.fBuiltSelectors[this.fBuiltSelectors.length - 1] = restrictToSelector;
                        }
                    } else {
                        this.fBuildingAllFieldsAndFunctions = false;
                    }
                }
            }
            throw throwable;
        }
        object = this.fBuildFieldsAndFunctionsLock;
        synchronized (object) {
            if (restrictToSelector != null) {
                if (this.fBuildingSelectors.length == 1) {
                    this.fBuildingSelectors = null;
                } else {
                    char[][] newBuildingSelectors = new char[this.fBuildingSelectors.length - 1][];
                    int j = 0;
                    int i = 0;
                    while (i < this.fBuildingSelectors.length) {
                        if (!CharOperation.equals(restrictToSelector, this.fBuildingSelectors[i])) {
                            newBuildingSelectors[j++] = this.fBuildingSelectors[i];
                        }
                        ++i;
                    }
                    this.fBuildingSelectors = newBuildingSelectors;
                }
                if (this.fBuiltSelectors == null) {
                    this.fBuiltSelectors = new char[1][];
                    this.fBuiltSelectors[0] = restrictToSelector;
                } else {
                    char[][] newBuiltSelectors = new char[this.fBuiltSelectors.length + 1][];
                    System.arraycopy(this.fBuiltSelectors, 0, newBuiltSelectors, 0, this.fBuiltSelectors.length);
                    this.fBuiltSelectors = newBuiltSelectors;
                    this.fBuiltSelectors[this.fBuiltSelectors.length - 1] = restrictToSelector;
                }
            } else {
                this.fBuildingAllFieldsAndFunctions = false;
            }
        }
    }

    @Override
    public InferredType getInferredType() {
        ClassScope classScope = this.scope.classScope();
        return classScope.inferredType;
    }

    private void buildFields(char[] restrictToSelector) {
        if (this.classScope == null) {
            return;
        }
        InferredType inferredType = this.classScope.inferredType;
        int size = inferredType.numberAttributes;
        FieldBinding[] fieldBindings = new FieldBinding[size + 1];
        HashtableOfObject knownFieldNames = new HashtableOfObject(size);
        boolean duplicate = false;
        int count = 0;
        int i = 0;
        while (i < size) {
            InferredAttribute field = inferredType.attributes[i];
            if (!(restrictToSelector != null && !CharOperation.equals(field.name, restrictToSelector) || restrictToSelector == null && CharOperation.contains(field.name, this.fBuildingSelectors) || CharOperation.contains(field.name, this.fBuiltSelectors))) {
                int modifiers = 0;
                if (field.isStatic) {
                    modifiers |= 8;
                }
                InferredType fieldType = field.type;
                TypeBinding fieldTypeBinding = null;
                Scope searchScope = null;
                if (fieldType != null) {
                    fieldTypeBinding = fieldType.resolveType(this.scope, field.node);
                } else if (field.node instanceof IAssignment) {
                    IExpression rhs = ((IAssignment)((Object)field.node)).getExpression();
                    if (rhs instanceof Expression && ((fieldTypeBinding = ((Expression)rhs).resolvedType) == null || fieldTypeBinding.isAnyType())) {
                        TypeBinding resolvedBinding;
                        IFunctionDeclaration containingFunction = null;
                        if (field.node instanceof Assignment && (containingFunction = ((Assignment)field.node).getContainingFunction()) != null && containingFunction instanceof AbstractMethodDeclaration) {
                            ((AbstractMethodDeclaration)((Object)containingFunction)).buildLocals(this.scope.compilationUnitScope());
                            searchScope = ((AbstractMethodDeclaration)((Object)containingFunction)).getScope();
                        }
                        if (searchScope == null) {
                            searchScope = this.scope;
                            while (searchScope != null && !(searchScope instanceof BlockScope)) {
                                searchScope = searchScope.parent;
                            }
                        }
                        if ((resolvedBinding = ((Expression)rhs).resolveType((BlockScope)searchScope)) != null) {
                            fieldTypeBinding = resolvedBinding;
                        }
                    }
                    if (fieldTypeBinding != null && SourceTypeBinding.isFunctionType(fieldTypeBinding)) {
                        MethodBinding[] funcBindings;
                        InferredMethod dupMeth;
                        MethodBinding assignedFuncBinding = null;
                        while (rhs instanceof IAssignment) {
                            rhs = ((IAssignment)rhs).getExpression();
                        }
                        if (rhs instanceof IFieldReference) {
                            MethodBinding[] funcBindings2;
                            TypeBinding receiverType;
                            char[] selector = ((IFieldReference)rhs).getToken();
                            IExpression receiver = ((IFieldReference)rhs).getReceiver();
                            if (receiver instanceof Expression && (receiverType = ((Expression)receiver).resolvedType) instanceof SourceTypeBinding && (funcBindings2 = ((SourceTypeBinding)receiverType).getMethods(selector)) != null && funcBindings2.length > 0) {
                                assignedFuncBinding = funcBindings2[0];
                            }
                        } else if (rhs instanceof SingleNameReference) {
                            Binding binding = ((SingleNameReference)rhs).binding;
                            if (binding instanceof MethodBinding) {
                                assignedFuncBinding = (MethodBinding)binding;
                            } else if (binding instanceof LocalVariableBinding && searchScope != null) {
                                assignedFuncBinding = searchScope instanceof BlockScope ? ((BlockScope)searchScope).findMethod(field.name, null, true) : searchScope.findMethod(null, field.name, null, null);
                            }
                        }
                        if (assignedFuncBinding != null && (dupMeth = inferredType.findMethod(field.name, null)) == null && ((funcBindings = this.getMethods(field.name)) == null || funcBindings.length == 0)) {
                            MethodBinding funcBinding = new MethodBinding(assignedFuncBinding, this);
                            funcBinding.setSelector(field.name);
                            this.addMethod(funcBinding);
                        }
                    }
                }
                if (fieldTypeBinding == null) {
                    fieldTypeBinding = TypeBinding.UNKNOWN;
                }
                FieldBinding fieldBinding = new FieldBinding(field, fieldTypeBinding, modifiers | 0x2000000, (ReferenceBinding)this);
                fieldBinding.id = count;
                if (knownFieldNames.containsKey(field.name)) {
                    duplicate = true;
                    FieldBinding previousBinding = (FieldBinding)knownFieldNames.get(field.name);
                    if (previousBinding != null) {
                        int f = 0;
                        while (f < i) {
                            InferredAttribute previousField = inferredType.attributes[f];
                            if (previousField.binding == previousBinding) {
                                this.scope.problemReporter().duplicateFieldInType(this, previousField);
                                previousField.binding = null;
                                break;
                            }
                            ++f;
                        }
                    }
                    knownFieldNames.put(field.name, null);
                    this.scope.problemReporter().duplicateFieldInType(this, field);
                    field.binding = null;
                } else {
                    knownFieldNames.put(field.name, fieldBinding);
                    fieldBindings[count++] = fieldBinding;
                }
            }
            ++i;
        }
        if (restrictToSelector == null) {
            FieldBinding prototype = new FieldBinding(TypeConstants.PROTOTYPE, (TypeBinding)TypeBinding.UNKNOWN, this.modifiers | 0x2000000, (ReferenceBinding)this);
            fieldBindings[count++] = prototype;
        }
        if (duplicate) {
            FieldBinding[] newFieldBindings = new FieldBinding[fieldBindings.length];
            size = count;
            count = 0;
            int i2 = 0;
            while (i2 < size) {
                FieldBinding fieldBinding = fieldBindings[i2];
                if (knownFieldNames.get(fieldBinding.name) != null) {
                    fieldBinding.id = count;
                    newFieldBindings[count++] = fieldBinding;
                }
                ++i2;
            }
            fieldBindings = newFieldBindings;
        }
        if (count != fieldBindings.length) {
            FieldBinding[] fieldBindingArray = fieldBindings;
            fieldBindings = new FieldBinding[count];
            System.arraycopy(fieldBindingArray, 0, fieldBindings, 0, count);
        }
        this.addFields(fieldBindings);
    }

    private void buildFunctions(char[] restrictToSelector) {
        int size;
        if (this.classScope == null) {
            return;
        }
        InferredType inferredType = this.classScope.inferredType;
        int n = size = inferredType.methods != null ? inferredType.methods.size() : 0;
        if (size == 0) {
            return;
        }
        int count = 0;
        MethodBinding[] methodBindings = new MethodBinding[size];
        int i = 0;
        while (i < size) {
            InferredMethod inferredMethod = (InferredMethod)inferredType.methods.get(i);
            if (!(restrictToSelector != null && !CharOperation.equals(inferredMethod.name, restrictToSelector) || restrictToSelector == null && CharOperation.contains(inferredMethod.name, this.fBuildingSelectors) || CharOperation.contains(inferredMethod.name, this.fBuiltSelectors))) {
                MethodBinding methodBinding;
                boolean doesNotHaveResolvedScope = inferredMethod.getFunctionDeclaration() instanceof AbstractMethodDeclaration && ((AbstractMethodDeclaration)((Object)inferredMethod.getFunctionDeclaration())).getScope() == null;
                MethodDeclaration methDec = (MethodDeclaration)inferredMethod.getFunctionDeclaration();
                if (!methDec.hasBinding() || !CharOperation.equals(methDec.getBinding().selector, inferredMethod.name)) {
                    MethodScope scope = new MethodScope(this.scope, methDec, false);
                    SourceTypeBinding declaringTypeBinding = null;
                    declaringTypeBinding = inferredMethod.inType != null && inferredMethod.inType.binding != null && !inferredMethod.isConstructor ? inferredMethod.inType.binding : this;
                    if (!methDec.hasBinding() || inferredMethod.isConstructor) {
                        methodBinding = scope.createMethod(inferredMethod, declaringTypeBinding);
                    } else {
                        methodBinding = new MethodBinding(methDec.getBinding(), declaringTypeBinding);
                        methodBinding.setSelector(inferredMethod.name);
                    }
                } else {
                    methodBinding = methDec.getBinding();
                }
                inferredMethod.methodBinding = methodBinding;
                methDec.setBinding(methodBinding);
                if (methodBinding != null) {
                    methodBindings[count++] = methodBinding;
                    if (doesNotHaveResolvedScope) {
                        this.scope.environment().defaultPackage.addBinding(methodBinding, methodBinding.selector, 8);
                    }
                }
            }
            ++i;
        }
        if (count != methodBindings.length) {
            MethodBinding[] methodBindingArray = methodBindings;
            methodBindings = new MethodBinding[count];
            System.arraycopy(methodBindingArray, 0, methodBindings, 0, count);
        }
        this.tagBits &= 0xFFFFFFFFFFFFBFFFL;
        this.addMethods(methodBindings);
    }

    @Override
    public int kind() {
        return 4;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        char[] uniqueKey = super.computeUniqueKey(isLeaf);
        if (uniqueKey.length == 2) {
            return uniqueKey;
        }
        if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(this.fileName) || Util.isMetadataFileName(new String(this.fileName))) {
            return uniqueKey;
        }
        int end = CharOperation.lastIndexOf('.', this.fileName);
        if (end != -1) {
            char[] topLevelType;
            int start = CharOperation.lastIndexOf('/', this.fileName) + 1;
            char[] mainTypeName = CharOperation.subarray(this.fileName, start, end);
            start = CharOperation.lastIndexOf('/', uniqueKey) + 1;
            if (start == 0) {
                start = 1;
            }
            if ((end = CharOperation.indexOf('<', uniqueKey, start)) == -1) {
                end = CharOperation.indexOf(';', uniqueKey, start);
            }
            if (!CharOperation.equals(topLevelType = CharOperation.subarray(uniqueKey, start, end), mainTypeName)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(uniqueKey, 0, start);
                buffer.append(mainTypeName);
                buffer.append('~');
                buffer.append(topLevelType);
                buffer.append(uniqueKey, end, uniqueKey.length - end);
                int length = buffer.length();
                uniqueKey = new char[length];
                buffer.getChars(0, length, uniqueKey, 0);
                return uniqueKey;
            }
        }
        return uniqueKey;
    }

    void faultInTypesForFieldsAndMethods() {
        ReferenceBinding enclosingType = this.enclosingType();
        if (enclosingType != null && enclosingType.isViewedAsDeprecated() && !this.isDeprecated()) {
            this.modifiers |= 0x200000;
        }
        this.fields();
        this.methods();
    }

    @Override
    public FieldBinding[] fields() {
        final HashMap fieldCache = new HashMap();
        this.performActionOnLinkedBindings(new LinkedBindingAction(){

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean performAction(SourceTypeBinding linkedBinding) {
                linkedBinding.buildFieldsAndMethods();
                if ((linkedBinding.tagBits & 8192L) == 0L) {
                    block14: {
                        failed = 0;
                        resolvedFields = linkedBinding.fields;
                        try {
                            if ((linkedBinding.tagBits & 4096L) == 0L) {
                                length = linkedBinding.fields.length;
                                if (length > 1) {
                                    ReferenceBinding.sortFields(linkedBinding.fields, 0, length);
                                }
                                linkedBinding.tagBits |= 4096L;
                            }
                            i = 0;
                            length = linkedBinding.fields.length;
                            while (i < length) {
                                if (SourceTypeBinding.access$0(linkedBinding, linkedBinding.fields[i]) == null) {
                                    if (resolvedFields == linkedBinding.fields) {
                                        resolvedFields = new FieldBinding[length];
                                        System.arraycopy(linkedBinding.fields, 0, resolvedFields, 0, length);
                                    }
                                    resolvedFields[i] = null;
                                    ++failed;
                                }
                                ++i;
                            }
                        }
                        finally {
                            if (failed <= 0) break block14;
                            newSize = resolvedFields.length - failed;
                            if (newSize == 0) {
                                linkedBinding.setFields(Binding.NO_FIELDS);
                                break block14;
                            }
                            newFields = new FieldBinding[newSize];
                            i = 0;
                            j = 0;
                            length = resolvedFields.length;
                            ** while (i < length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (resolvedFields[i] != null) {
                                newFields[j++] = resolvedFields[i];
                            }
                            ++i;
                            continue;
                        }
lbl38:
                        // 1 sources

                        linkedBinding.setFields(newFields);
                    }
                    linkedBinding.tagBits |= 8192L;
                }
                i = 0;
                while (i < linkedBinding.fields.length) {
                    if (linkedBinding.fields[i] != null) {
                        fieldCache.put(linkedBinding.fields[i].name, linkedBinding.fields[i]);
                    }
                    ++i;
                }
                return true;
            }
        });
        return fieldCache.values().toArray(new FieldBinding[0]);
    }

    @Override
    public MethodBinding getExactConstructor(final TypeBinding[] argumentTypes) {
        MethodBinding exactConstructor = (MethodBinding)this.performActionOnLinkedBindings(new LinkedBindingAction(){
            private MethodBinding fExactConstructorMatch = null;

            @Override
            public boolean performAction(SourceTypeBinding linkedBinding) {
                linkedBinding.buildFieldsAndMethods();
                this.fExactConstructorMatch = linkedBinding.getExactConstructor0(argumentTypes);
                return this.fExactConstructorMatch == null;
            }

            @Override
            public Object getFinalResult() {
                return this.fExactConstructorMatch;
            }
        });
        return exactConstructor;
    }

    private MethodBinding getExactConstructor0(TypeBinding[] argumentTypes) {
        if ((this.tagBits & 0x8000L) != 0L) {
            long range = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
            if (range >= 0L && (int)range <= (int)(range >> 32)) {
                MethodBinding method = this.methods[(int)range];
                return method;
            }
        } else {
            long range;
            if ((this.tagBits & 0x4000L) == 0L) {
                int length = this.methods.length;
                if (length > 1) {
                    ReferenceBinding.sortMethods(this.methods, 0, length);
                }
                this.tagBits |= 0x4000L;
            }
            if ((range = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods)) >= 0L && (int)range <= (int)(range >> 32)) {
                MethodBinding method = this.methods[(int)range];
                if (this.resolveTypesFor(method) == null || method.returnType == null) {
                    this.methods();
                    return this.getExactConstructor(argumentTypes);
                }
                return method;
            }
        }
        return null;
    }

    @Override
    public MethodBinding getExactMethod(final char[] selector, final TypeBinding[] argumentTypes, final CompilationUnitScope refScope) {
        MethodBinding exactMethod = null;
        if (selector != null) {
            final LinkedList<ReferenceBinding> typesToCheck = new LinkedList<ReferenceBinding>();
            final HashSet<ReferenceBinding> checkedTypes = new HashSet<ReferenceBinding>();
            typesToCheck.add(this);
            while (!typesToCheck.isEmpty() && exactMethod == null) {
                ReferenceBinding typeToCheck = (ReferenceBinding)typesToCheck.removeFirst();
                if (typeToCheck instanceof SourceTypeBinding) {
                    exactMethod = (MethodBinding)((SourceTypeBinding)typeToCheck).performActionOnLinkedBindings(new LinkedBindingAction(){
                        private MethodBinding fExactFunctionMatch;

                        @Override
                        public boolean performAction(SourceTypeBinding typeToCheckLinkedBinding) {
                            checkedTypes.add(typeToCheckLinkedBinding);
                            if (!SourceTypeBinding.this.fHasBuiltFieldsAndMethods && typeToCheckLinkedBinding.inferredTypeHasFunction(selector)) {
                                typeToCheckLinkedBinding.buildFieldsAndMethods(selector);
                            }
                            this.fExactFunctionMatch = typeToCheckLinkedBinding.getExactMethod0(selector, argumentTypes, refScope);
                            if (this.fExactFunctionMatch == null) {
                                boolean alreadyGoingToCheck = false;
                                ReferenceBinding superBinding = typeToCheckLinkedBinding.getSuperBinding0();
                                if (superBinding != null) {
                                    Iterator typesToCheckIter = typesToCheck.iterator();
                                    while (typesToCheckIter.hasNext()) {
                                        alreadyGoingToCheck = ((ReferenceBinding)typesToCheckIter.next()).isEquivalentTo(superBinding);
                                    }
                                    boolean alreadyChecked = false;
                                    if (!alreadyGoingToCheck) {
                                        alreadyChecked = checkedTypes.contains(superBinding);
                                    }
                                    if (!alreadyGoingToCheck && !alreadyChecked) {
                                        typesToCheck.add(superBinding);
                                    }
                                }
                            }
                            return this.fExactFunctionMatch == null;
                        }

                        @Override
                        public Object getFinalResult() {
                            return this.fExactFunctionMatch;
                        }
                    });
                    continue;
                }
                checkedTypes.add(typeToCheck);
                exactMethod = typeToCheck.getExactMethod(selector, argumentTypes, refScope);
                if (exactMethod != null) continue;
                boolean alreadyGoingToCheck = false;
                ReferenceBinding superBinding = typeToCheck.getSuperBinding();
                if (superBinding == null) continue;
                Iterator typesToCheckIter = typesToCheck.iterator();
                while (typesToCheckIter.hasNext()) {
                    alreadyGoingToCheck = ((ReferenceBinding)typesToCheckIter.next()).isEquivalentTo(superBinding);
                }
                boolean alreadyChecked = false;
                if (!alreadyGoingToCheck) {
                    alreadyChecked = checkedTypes.contains(superBinding);
                }
                if (alreadyGoingToCheck || alreadyChecked) continue;
                typesToCheck.add(superBinding);
            }
        }
        return exactMethod;
    }

    private MethodBinding getExactMethod0(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        if (selector == null || this.methods == null || this.methods.length == 0) {
            return null;
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            long range = ReferenceBinding.binarySearch(selector, this.methods);
            if (range >= 0L && (int)range <= (int)(range >> 32)) {
                MethodBinding method = this.methods[(int)range];
                return method;
            }
        } else {
            long range;
            if ((this.tagBits & 0x4000L) == 0L) {
                int length = this.methods.length;
                if (length > 1) {
                    ReferenceBinding.sortMethods(this.methods, 0, length);
                }
                this.tagBits |= 0x4000L;
            }
            if ((range = ReferenceBinding.binarySearch(selector, this.methods)) >= 0L) {
                int start = (int)range;
                int end = (int)(range >> 32);
                int imethod = start;
                while (imethod <= end) {
                    MethodBinding method = this.methods[imethod];
                    if (this.resolveTypesFor(method) == null || method.returnType == null) {
                        this.methods();
                        return this.getExactMethod0(selector, argumentTypes, refScope);
                    }
                    ++imethod;
                }
                boolean isSource15 = this.scope != null && this.scope.compilerOptions().sourceLevel >= 0x310000L;
                int i = start;
                while (i <= end) {
                    MethodBinding method1 = this.methods[i];
                    int j = end;
                    while (j > i) {
                        boolean paramsMatch;
                        MethodBinding method2 = this.methods[j];
                        boolean bl = paramsMatch = isSource15 ? method1.areParametersEqual(method2) : method1.areParametersEqual(method2);
                        if (paramsMatch) {
                            this.methods();
                            return this.getExactMethod0(selector, argumentTypes, refScope);
                        }
                        --j;
                    }
                    ++i;
                }
                return this.methods[start];
            }
        }
        return null;
    }

    @Override
    public FieldBinding getField(final char[] fieldName, final boolean needResolve) {
        FieldBinding field = null;
        if (fieldName != null) {
            field = (FieldBinding)this.performActionOnLinkedBindings(new LinkedBindingAction(){
                private FieldBinding fFieldMatch;

                @Override
                public boolean performAction(SourceTypeBinding linkedBinding) {
                    if (!SourceTypeBinding.this.fHasBuiltFieldsAndMethods && linkedBinding.inferredTypeHasField(fieldName)) {
                        linkedBinding.buildFieldsAndMethods(fieldName);
                    }
                    this.fFieldMatch = linkedBinding.getField0(fieldName, needResolve);
                    return this.fFieldMatch == null;
                }

                @Override
                public Object getFinalResult() {
                    return this.fFieldMatch;
                }
            });
        }
        return field;
    }

    public FieldBinding getFieldInHierarchy(char[] fieldName, boolean needResolve) {
        SourceTypeBinding currentType = this;
        while (currentType != null) {
            FieldBinding field = currentType.getField(fieldName, needResolve);
            if (field != null) {
                return field;
            }
            currentType = (SourceTypeBinding)currentType.getSuperBinding();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FieldBinding getField0(char[] fieldName, boolean needResolve) {
        if ((this.tagBits & 8192L) != 0L) {
            return ReferenceBinding.binarySearch(fieldName, this.fields);
        }
        if ((this.tagBits & 4096L) == 0L) {
            length = this.fields.length;
            if (length > 1) {
                ReferenceBinding.sortFields(this.fields, 0, length);
            }
            this.tagBits |= 4096L;
        }
        if ((field = ReferenceBinding.binarySearch(fieldName, this.fields)) == null) return null;
        result = null;
        try {
            var6_6 = result = this.resolveTypeFor(field);
            return var6_6;
        }
        finally {
            if (result != null) return var6_6;
            newSize = this.fields.length - 1;
            if (newSize == 0) {
                this.setFields(Binding.NO_FIELDS);
                return var6_6;
            }
            newFields = new FieldBinding[newSize];
            index = 0;
            i = 0;
            length = this.fields.length;
            ** while (i < length)
        }
lbl-1000:
        // 1 sources

        {
            f = this.fields[i];
            if (f != field) {
                newFields[index++] = f;
            }
            ++i;
            continue;
        }
lbl29:
        // 1 sources

        this.setFields(newFields);
        return var6_6;
    }

    @Override
    public MethodBinding[] getMethods(final char[] selector) {
        MethodBinding[] allFunctionMatches = Binding.NO_METHODS;
        if (selector != null) {
            allFunctionMatches = (MethodBinding[])this.performActionOnLinkedBindings(new LinkedBindingAction(){
                private MethodBinding[] fAllFunctionMatches = Binding.NO_METHODS;

                @Override
                public boolean performAction(SourceTypeBinding linkedBinding) {
                    if (!SourceTypeBinding.this.fHasBuiltFieldsAndMethods && linkedBinding.inferredTypeHasFunction(selector)) {
                        linkedBinding.buildFieldsAndMethods(selector);
                    }
                    MethodBinding[] functionMatches = linkedBinding.getMethods0(selector);
                    if (this.fAllFunctionMatches == null) {
                        this.fAllFunctionMatches = functionMatches;
                    } else {
                        MethodBinding[] combinedFunctionMatches = new MethodBinding[this.fAllFunctionMatches.length + functionMatches.length];
                        System.arraycopy(this.fAllFunctionMatches, 0, combinedFunctionMatches, 0, this.fAllFunctionMatches.length);
                        System.arraycopy(functionMatches, 0, combinedFunctionMatches, this.fAllFunctionMatches.length, functionMatches.length);
                        this.fAllFunctionMatches = combinedFunctionMatches;
                    }
                    return true;
                }

                @Override
                public Object getFinalResult() {
                    return this.fAllFunctionMatches;
                }
            });
        }
        return allFunctionMatches;
    }

    private MethodBinding[] getMethods0(char[] selector) {
        MethodBinding method;
        int end;
        int start;
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            long range = ReferenceBinding.binarySearch(selector, this.methods);
            if (range >= 0L) {
                int start2 = (int)range;
                int end2 = (int)(range >> 32);
                int length = end2 - start2 + 1;
                MethodBinding[] result = new MethodBinding[length];
                System.arraycopy(this.methods, start2, result, 0, length);
                return result;
            }
            return Binding.NO_METHODS;
        }
        long range = ReferenceBinding.binarySearch(selector, this.methods);
        if (range >= 0L) {
            start = (int)range;
            end = (int)(range >> 32);
            int i = start;
            while (i <= end) {
                method = this.methods[i];
                if (this.resolveTypesFor(method) == null || method.returnType == null) {
                    this.methods();
                    return this.getMethods(selector);
                }
                ++i;
            }
        } else {
            return Binding.NO_METHODS;
        }
        int length = end - start + 1;
        MethodBinding[] result = new MethodBinding[length];
        System.arraycopy(this.methods, start, result, 0, length);
        boolean isSource15 = this.scope != null && this.scope.compilerOptions().sourceLevel >= 0x310000L;
        int i = 0;
        length = result.length - 1;
        while (i < length) {
            method = result[i];
            int j = length;
            while (j > i) {
                boolean paramsMatch;
                boolean bl = paramsMatch = isSource15 ? method.areParametersEqual(result[j]) : method.areParametersEqual(result[j]);
                if (paramsMatch) {
                    this.methods();
                    return this.getMethods(selector);
                }
                --j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean isEquivalentTo(final TypeBinding otherType) {
        boolean isEquivalent;
        boolean bl = isEquivalent = this == otherType;
        if (!isEquivalent && otherType != null) {
            boolean cfr_ignored_0 = otherType instanceof SourceTypeBinding;
            isEquivalent = (Boolean)this.performActionOnLinkedBindings(new LinkedBindingAction(){
                private boolean fIsEquivalent = false;

                @Override
                public boolean performAction(SourceTypeBinding selfLinkedBinding) {
                    this.fIsEquivalent = selfLinkedBinding == otherType;
                    return !this.fIsEquivalent;
                }

                @Override
                public Object getFinalResult() {
                    return new Boolean(this.fIsEquivalent);
                }
            });
        }
        return isEquivalent;
    }

    @Override
    public ReferenceBinding[] memberTypes() {
        ReferenceBinding[] allMemberTypes = (ReferenceBinding[])this.performActionOnLinkedBindings(new LinkedBindingAction(){
            private ReferenceBinding[] fAllMemberTypes;

            @Override
            public boolean performAction(SourceTypeBinding linkedBinding) {
                if (this.fAllMemberTypes == null) {
                    this.fAllMemberTypes = linkedBinding.memberTypes;
                } else {
                    ReferenceBinding[] combinedMemberTypes = new ReferenceBinding[this.fAllMemberTypes.length + linkedBinding.memberTypes.length];
                    System.arraycopy(this.fAllMemberTypes, 0, combinedMemberTypes, 0, this.fAllMemberTypes.length);
                    System.arraycopy(linkedBinding.memberTypes, 0, combinedMemberTypes, this.fAllMemberTypes.length, linkedBinding.memberTypes.length);
                    this.fAllMemberTypes = combinedMemberTypes;
                }
                return true;
            }

            @Override
            public Object getFinalResult() {
                return this.fAllMemberTypes;
            }
        });
        return allMemberTypes;
    }

    public FieldBinding getUpdatedFieldBinding(FieldBinding targetField, ReferenceBinding newDeclaringClass) {
        Hashtable<ReferenceBinding, FieldBinding> fieldMap = new Hashtable<ReferenceBinding, FieldBinding>(5);
        FieldBinding updatedField = new FieldBinding(targetField, newDeclaringClass);
        fieldMap.put(newDeclaringClass, updatedField);
        return updatedField;
    }

    public MethodBinding getUpdatedMethodBinding(MethodBinding targetMethod, ReferenceBinding newDeclaringClass) {
        MethodBinding updatedMethod = new MethodBinding(targetMethod, newDeclaringClass);
        updatedMethod.createFunctionTypeBinding(this.scope);
        return updatedMethod;
    }

    @Override
    public boolean hasMemberTypes() {
        Boolean hasMemberTypes = (Boolean)this.performActionOnLinkedBindings(new LinkedBindingAction(){
            private boolean fHasMemberTypes = false;

            @Override
            public boolean performAction(SourceTypeBinding linkedBinding) {
                this.fHasMemberTypes = linkedBinding.memberTypes != null && linkedBinding.memberTypes.length > 0;
                return !this.fHasMemberTypes;
            }

            @Override
            public Object getFinalResult() {
                return new Boolean(this.fHasMemberTypes);
            }
        });
        return hasMemberTypes;
    }

    @Override
    public MethodBinding[] methods() {
        MethodBinding[] allFunctions = (MethodBinding[])this.performActionOnLinkedBindings(new LinkedBindingAction(){
            private MethodBinding[] fAllFunctions;

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean performAction(SourceTypeBinding linkedBinding) {
                block30: {
                    block29: {
                        linkedBinding.buildFieldsAndMethods();
                        if ((linkedBinding.tagBits & 32768L) != 0L) break block30;
                        if ((linkedBinding.tagBits & 16384L) == 0L) {
                            length = linkedBinding.methods.length;
                            if (length > 1) {
                                ReferenceBinding.sortMethods(linkedBinding.methods, 0, length);
                            }
                            linkedBinding.tagBits |= 16384L;
                        }
                        failed = 0;
                        resolvedMethods = linkedBinding.methods;
                        try {
                            i = 0;
                            length = linkedBinding.methods.length;
                            while (i < length) {
                                if (SourceTypeBinding.this.resolveTypesFor(linkedBinding.methods[i]) == null) {
                                    if (resolvedMethods == linkedBinding.methods) {
                                        resolvedMethods = new MethodBinding[length];
                                        System.arraycopy(linkedBinding.methods, 0, resolvedMethods, 0, length);
                                    }
                                    resolvedMethods[i] = null;
                                    ++failed;
                                }
                                ++i;
                            }
                            complyTo15 = linkedBinding.scope != null && linkedBinding.scope.compilerOptions().sourceLevel >= 0x310000L;
                            i = 0;
                            length = linkedBinding.methods.length;
                            while (i < length) {
                                block31: {
                                    method = resolvedMethods[i];
                                    if (method == null) break block31;
                                    selector = method.selector;
                                    methodDecl = null;
                                    j = i + 1;
                                    while (j < length) {
                                        block32: {
                                            block34: {
                                                block33: {
                                                    method2 = resolvedMethods[j];
                                                    if (method2 == null) break block32;
                                                    if (method == method2 || !CharOperation.equals(selector, method2.selector)) break;
                                                    if (!complyTo15 || method.returnType == null || method2.returnType == null) break block33;
                                                    params1 = method.parameters;
                                                    pLength = params1.length;
                                                    params2 = method2.parameters;
                                                    if (pLength != params2.length) break block32;
                                                    subMethod = method2;
                                                    equalParams = method.areParametersEqual(subMethod);
                                                    if (equalParams || method.returnType == subMethod.returnType && (equalParams || method.areParametersEqual(method2)) || pLength <= 0) break block34;
                                                    index = pLength;
                                                    while (--index >= 0) {
                                                        if (params1[index] != params2[index]) break;
                                                    }
                                                    if (index >= 0 && index < pLength) {
                                                        index = pLength;
                                                        while (--index >= 0) {
                                                            if (params1[index] != params2[index]) break;
                                                        }
                                                    }
                                                    if (index < 0) break block34;
                                                    break block32;
                                                }
                                                if (!method.areParametersEqual(method2)) break block32;
                                            }
                                            if (methodDecl == null && (methodDecl = method.sourceMethod()) != null && methodDecl.hasBinding()) {
                                                linkedBinding.scope.problemReporter().duplicateMethodInType(linkedBinding, methodDecl);
                                                methodDecl.setBinding(null);
                                                if (resolvedMethods == linkedBinding.methods) {
                                                    resolvedMethods = new MethodBinding[length];
                                                    System.arraycopy(linkedBinding.methods, 0, resolvedMethods, 0, length);
                                                }
                                                resolvedMethods[i] = null;
                                                ++failed;
                                            }
                                            if ((method2Decl = method2.sourceMethod()) != null && method2Decl.hasBinding()) {
                                                linkedBinding.scope.problemReporter().duplicateMethodInType(linkedBinding, method2Decl);
                                                method2Decl.setBinding(null);
                                                if (resolvedMethods == linkedBinding.methods) {
                                                    resolvedMethods = new MethodBinding[length];
                                                    System.arraycopy(linkedBinding.methods, 0, resolvedMethods, 0, length);
                                                }
                                                resolvedMethods[j] = null;
                                                ++failed;
                                            }
                                        }
                                        ++j;
                                    }
                                    if (method != null && method.returnType == null && methodDecl == null) {
                                        methodDecl = method.sourceMethod();
                                        if (methodDecl != null) {
                                            methodDecl.setBinding(null);
                                        }
                                        if (resolvedMethods == linkedBinding.methods) {
                                            resolvedMethods = new MethodBinding[length];
                                            System.arraycopy(linkedBinding.methods, 0, resolvedMethods, 0, length);
                                        }
                                        resolvedMethods[i] = null;
                                        ++failed;
                                    }
                                }
                                ++i;
                            }
                        }
                        finally {
                            if (failed <= 0) break block29;
                            newSize = resolvedMethods.length - failed;
                            if (newSize == 0) {
                                linkedBinding.setMethods(Binding.NO_METHODS);
                                break block29;
                            }
                            newMethods = new MethodBinding[newSize];
                            i = 0;
                            j = 0;
                            length = resolvedMethods.length;
                            ** while (i < length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (resolvedMethods[i] != null) {
                                newMethods[j++] = resolvedMethods[i];
                            }
                            ++i;
                            continue;
                        }
lbl104:
                        // 1 sources

                        linkedBinding.setMethods(newMethods);
                    }
                    linkedBinding.tagBits |= 32768L;
                }
                if (this.fAllFunctions == null) {
                    this.fAllFunctions = linkedBinding.methods;
                } else {
                    combinedFunctions = new MethodBinding[this.fAllFunctions.length + linkedBinding.methods.length];
                    System.arraycopy(this.fAllFunctions, 0, combinedFunctions, 0, this.fAllFunctions.length);
                    System.arraycopy(linkedBinding.methods, 0, combinedFunctions, this.fAllFunctions.length, linkedBinding.methods.length);
                    this.fAllFunctions = combinedFunctions;
                }
                return true;
            }

            @Override
            public Object getFinalResult() {
                return this.fAllFunctions;
            }
        });
        return allFunctions;
    }

    private FieldBinding resolveTypeFor(FieldBinding field) {
        if ((field.modifiers & 0x2000000) == 0) {
            return field;
        }
        if (this.isViewedAsDeprecated() && !field.isDeprecated()) {
            field.modifiers |= 0x200000;
        }
        if (this.hasRestrictedAccess()) {
            field.modifiers |= 0x40000;
        }
        return field;
    }

    public MethodBinding resolveTypesFor(MethodBinding method) {
        return this.resolveTypesFor(method, null);
    }

    public MethodBinding resolveTypesFor(MethodBinding method, AbstractMethodDeclaration methodDecl) {
        if ((method.modifiers & 0x2000000) == 0) {
            return method;
        }
        if (this.isViewedAsDeprecated() && !method.isDeprecated()) {
            method.modifiers |= 0x200000;
        }
        if (this.hasRestrictedAccess()) {
            method.modifiers |= 0x40000;
        }
        if (methodDecl == null) {
            methodDecl = method.sourceMethod();
        }
        if (methodDecl == null) {
            return null;
        }
        boolean foundArgProblem = false;
        Argument[] arguments = methodDecl.arguments;
        if (arguments != null) {
            int size = arguments.length;
            method.setParameters(Binding.NO_PARAMETERS);
            TypeBinding[] newParameters = new TypeBinding[size];
            int i = 0;
            while (i < size) {
                Argument arg = arguments[i];
                TypeBinding parameterType = TypeBinding.UNKNOWN;
                if (arg.type != null) {
                    parameterType = arg.type.resolveType(methodDecl.getScope(), true);
                } else if (arg.inferredType != null) {
                    ReferenceBinding argTypeBinding;
                    if (arg.inferredType.isAnonymous && arg.inferredType.binding == null && (argTypeBinding = methodDecl.getScope().findType(arg.inferredType.getName(), this.getPackage(), this.getPackage())) instanceof SourceTypeBinding) {
                        arg.inferredType.binding = (SourceTypeBinding)argTypeBinding;
                    }
                    parameterType = arg.inferredType.resolveType(methodDecl.getScope(), arg);
                }
                if (parameterType == null) {
                    parameterType = TypeBinding.ANY;
                }
                newParameters[i] = parameterType;
                if (arg.binding == null) {
                    arg.binding = new LocalVariableBinding(arg, parameterType, arg.modifiers, true);
                }
                ++i;
            }
            if (!foundArgProblem) {
                method.setParameters(newParameters);
            }
        }
        boolean foundReturnTypeProblem = false;
        if (!method.isConstructor()) {
            TypeReference returnType;
            TypeReference typeReference = returnType = methodDecl instanceof MethodDeclaration ? ((MethodDeclaration)methodDecl).returnType : null;
            if (returnType == null && !(methodDecl instanceof MethodDeclaration)) {
                methodDecl.getScope().problemReporter().missingReturnType(methodDecl);
                method.returnType = null;
                foundReturnTypeProblem = true;
            } else {
                TypeBinding methodType;
                TypeBinding typeBinding = methodType = returnType != null ? returnType.resolveType(methodDecl.getScope(), true) : null;
                if (methodType == null) {
                    TypeBinding typeBinding2 = methodType = methodDecl.inferredType != null ? methodDecl.inferredType.resolveType(methodDecl.getScope(), methodDecl) : TypeBinding.UNKNOWN;
                }
                if (methodType == null) {
                    foundReturnTypeProblem = true;
                } else {
                    method.returnType = methodType;
                }
            }
        }
        if (foundArgProblem) {
            methodDecl.setBinding(null);
            method.setParameters(Binding.NO_PARAMETERS);
            return null;
        }
        if (foundReturnTypeProblem) {
            return method;
        }
        method.modifiers &= 0xFDFFFFFF;
        return method;
    }

    public void setFields(FieldBinding[] fields) {
        this.tagBits &= 0xFFFFFFFFFFFFEFFFL;
        this.fields = fields;
    }

    public void setMethods(MethodBinding[] methods) {
        this.tagBits &= 0xFFFFFFFFFFFFBFFFL;
        this.methods = methods;
    }

    public int sourceEnd() {
        if (this.classScope.referenceContext != null) {
            return this.classScope.referenceContext.sourceEnd;
        }
        return this.classScope.inferredType.sourceEnd;
    }

    public int sourceStart() {
        if (this.classScope.referenceContext != null) {
            return this.classScope.referenceContext.sourceStart;
        }
        return this.classScope.inferredType.sourceStart;
    }

    @Override
    public ReferenceBinding getSuperBinding() {
        ReferenceBinding superBinding = (ReferenceBinding)this.performActionOnLinkedBindings(new LinkedBindingAction(){
            private ReferenceBinding fFoundSuperBinding = null;

            @Override
            public boolean performAction(SourceTypeBinding linkedBinding) {
                ReferenceBinding linkedSuperBinding = linkedBinding.getSuperBinding0();
                if (linkedSuperBinding != null && linkedSuperBinding != SourceTypeBinding.this && (this.fFoundSuperBinding == null || linkedSuperBinding.id != 1)) {
                    this.fFoundSuperBinding = linkedSuperBinding;
                }
                return this.fFoundSuperBinding == null || this.fFoundSuperBinding.id == 1;
            }

            @Override
            public Object getFinalResult() {
                return this.fFoundSuperBinding;
            }
        });
        return superBinding;
    }

    public ReferenceBinding getSuperBinding0() {
        return this.fSuperBinding;
    }

    public void setSuperBinding(ReferenceBinding newSuperBinding) {
        this.fSuperBinding = newSuperBinding;
    }

    public String toString() {
        int length;
        int i;
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("(id=");
        if (this.id == Integer.MAX_VALUE) {
            buffer.append("NoId");
        } else {
            buffer.append(this.id);
        }
        buffer.append(")\n");
        if (this.isDeprecated()) {
            buffer.append("deprecated ");
        }
        if (this.isPublic()) {
            buffer.append("public ");
        }
        if (this.isPrivate()) {
            buffer.append("private ");
        }
        if (this.isStatic() && this.isNestedType()) {
            buffer.append("static ");
        }
        if (this.isClass()) {
            buffer.append("class ");
        } else {
            buffer.append("interface ");
        }
        buffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        buffer.append("\n\textends ");
        buffer.append(this.fSuperBinding != null ? this.fSuperBinding.debugName() : "NULL TYPE");
        if (this.enclosingType() != null) {
            buffer.append("\n\tenclosing type : ");
            buffer.append(this.enclosingType().debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                buffer.append("\n/*   fields   */");
                i = 0;
                length = this.fields.length;
                while (i < length) {
                    buffer.append('\n').append(this.fields[i] != null ? this.fields[i].toString() : "NULL FIELD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != Binding.NO_METHODS) {
                buffer.append("\n/*   methods   */");
                i = 0;
                length = this.methods.length;
                while (i < length) {
                    buffer.append('\n').append(this.methods[i] != null ? this.methods[i].toString() : "NULL METHOD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != Binding.NO_MEMBER_TYPES) {
                buffer.append("\n/*   members   */");
                i = 0;
                length = this.memberTypes.length;
                while (i < length) {
                    buffer.append('\n').append(this.memberTypes[i] != null ? this.memberTypes[i].toString() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL MEMBER TYPES");
        }
        buffer.append("\n\n");
        return buffer.toString();
    }

    public AbstractMethodDeclaration sourceMethod(MethodBinding binding) {
        if (this.classScope == null) {
            return null;
        }
        InferredType inferredType = this.classScope.inferredType;
        InferredMethod inferredMethod = inferredType.findMethod(binding.selector, null);
        if (inferredMethod != null) {
            return (AbstractMethodDeclaration)((Object)inferredMethod.getFunctionDeclaration());
        }
        return null;
    }

    public void addMethod(MethodBinding binding) {
        this.tagBits &= 0xFFFFFFFFFFFFBFFFL;
        int length = this.methods.length;
        this.methods = new MethodBinding[length + 1];
        System.arraycopy(this.methods, 0, this.methods, 0, length);
        this.methods[length] = binding;
    }

    public void addField(FieldBinding binding) {
        this.tagBits &= 0xFFFFFFFFFFFFEFFFL;
        int length = this.fields.length;
        this.fields = new FieldBinding[length + 1];
        System.arraycopy(this.fields, 0, this.fields, 0, length);
        this.fields[length] = binding;
    }

    private void addMethods(MethodBinding[] newFunctionBindings) {
        this.tagBits &= 0xFFFFFFFFFFFFBFFFL;
        int length = this.methods.length;
        this.methods = new MethodBinding[length + newFunctionBindings.length];
        System.arraycopy(this.methods, 0, this.methods, 0, length);
        System.arraycopy(newFunctionBindings, 0, this.methods, length, newFunctionBindings.length);
    }

    private void addFields(FieldBinding[] newFieldBindings) {
        this.tagBits &= 0xFFFFFFFFFFFFEFFFL;
        int length = this.fields.length;
        this.fields = new FieldBinding[length + newFieldBindings.length];
        System.arraycopy(this.fields, 0, this.fields, 0, length);
        System.arraycopy(newFieldBindings, 0, this.fields, length, newFieldBindings.length);
    }

    @Override
    public void cleanup() {
        this.scope = null;
        this.classScope = null;
    }

    boolean isLinkedType(final ReferenceBinding searchBinding) {
        Boolean isBindingLinked = (Boolean)this.performActionOnLinkedBindings(new LinkedBindingAction(){
            private boolean fIsBindingLinked = false;

            @Override
            public boolean performAction(SourceTypeBinding linkedBinding) {
                this.fIsBindingLinked = searchBinding == linkedBinding;
                return !this.fIsBindingLinked;
            }

            @Override
            public Object getFinalResult() {
                return new Boolean(this.fIsBindingLinked);
            }
        });
        return isBindingLinked;
    }

    public void addLinkedBinding(SourceTypeBinding newLinkedBinding) {
        boolean isDuplicate = this.isLinkedType(newLinkedBinding);
        if (!isDuplicate) {
            SourceTypeBinding currNextType = this.fNextType;
            this.fNextType = newLinkedBinding;
            SourceTypeBinding newTypesLastNextType = newLinkedBinding;
            while (newTypesLastNextType.fNextType != newLinkedBinding) {
                newTypesLastNextType = newTypesLastNextType.fNextType;
            }
            newTypesLastNextType.fNextType = currNextType;
        }
    }

    public static boolean checkIfDuplicateType(SourceTypeBinding binding1, SourceTypeBinding binding2) {
        InferredType type2 = binding2.classScope.inferredType;
        if (binding1.classScope == null) {
            if (binding1.fSuperBinding == null && type2.getSuperType() != null) {
                return false;
            }
            if (binding1.fSuperBinding != null && type2.getSuperType() == null) {
                return false;
            }
            if (binding1.fSuperBinding != null && type2.getSuperType() != null && !CharOperation.equals(binding1.fSuperBinding.sourceName, type2.getSuperType().getName())) {
                return false;
            }
            if (binding1.fields.length != type2.attributes.length) {
                return false;
            }
            if (binding1.methods == null && type2.methods != null) {
                return false;
            }
            if (binding1.methods != null && type2.methods == null) {
                return false;
            }
            if (binding1.methods != null && type2.methods != null && binding1.methods.length != type2.methods.size()) {
                return false;
            }
        } else {
            InferredType type1 = binding1.classScope.inferredType;
            if (type1.getSuperType() == null && type2.getSuperType() != null) {
                return false;
            }
            if (type1.getSuperType() != null && type2.getSuperType() == null) {
                return false;
            }
            if (type1.getSuperType() != null && type2.getSuperType() != null && !CharOperation.equals(type1.getSuperType().getName(), type2.getSuperType().getName())) {
                return false;
            }
            if (type1.attributes.length != type2.attributes.length) {
                return false;
            }
            if (type1.methods == null && type2.methods != null) {
                return false;
            }
            if (type1.methods != null && type2.methods == null) {
                return false;
            }
            if (type1.methods != null && type2.methods != null && type1.methods.size() != type2.methods.size()) {
                return false;
            }
            StringBuffer checkSumString1 = new StringBuffer();
            StringBuffer checkSumString2 = new StringBuffer();
            int i = 0;
            while (i < type1.attributes.length) {
                checkSumString1.append(type1.attributes[i] == null ? "" : new String(type1.attributes[i].name));
                checkSumString2.append(type2.attributes[i] == null ? "" : new String(type2.attributes[i].name));
                ++i;
            }
            checksumCalculator.reset();
            checksumCalculator.update(checkSumString1.toString().getBytes());
            long checkSum1 = checksumCalculator.getValue();
            checksumCalculator.reset();
            checksumCalculator.update(checkSumString2.toString().getBytes());
            long checkSum2 = checksumCalculator.getValue();
            if (checkSum1 != checkSum2) {
                return false;
            }
            checkSumString1 = new StringBuffer();
            checkSumString2 = new StringBuffer();
            if (type1.methods != null && type2.methods != null) {
                int i2 = 0;
                while (i2 < type1.methods.size()) {
                    checkSumString1.append(new String(((InferredMethod)type1.methods.get((int)i2)).name));
                    checkSumString2.append(new String(((InferredMethod)type2.methods.get((int)i2)).name));
                    ++i2;
                }
            }
            checksumCalculator.reset();
            checksumCalculator.update(checkSumString1.toString().getBytes());
            checkSum1 = checksumCalculator.getValue();
            checksumCalculator.reset();
            checksumCalculator.update(checkSumString2.toString().getBytes());
            checkSum2 = checksumCalculator.getValue();
            if (checkSum1 != checkSum2) {
                return false;
            }
        }
        return true;
    }

    @Override
    public TypeBinding reconcileAnonymous(TypeBinding other) {
        int i;
        if (!(other instanceof SourceTypeBinding)) {
            return null;
        }
        SourceTypeBinding otherBinding = (SourceTypeBinding)other;
        if (!otherBinding.isAnonymousType()) {
            return null;
        }
        if (otherBinding.methods != null) {
            i = 0;
            while (i < otherBinding.methods.length) {
                MethodBinding methodBinding = otherBinding.methods[i];
                MethodBinding exactMethod = this.getExactMethod(methodBinding.selector, methodBinding.parameters, null);
                if (exactMethod == null) {
                    return null;
                }
                ++i;
            }
        }
        if (otherBinding.fields != null) {
            i = 0;
            while (i < otherBinding.fields.length) {
                FieldBinding fieldBinding = otherBinding.fields[i];
                FieldBinding myField = this.getFieldInHierarchy(fieldBinding.name, true);
                if (myField == null) {
                    return null;
                }
                ++i;
            }
        }
        return this;
    }

    @Override
    public char[] readableName() {
        return this.qualifiedSourceName();
    }

    @Override
    public char[] qualifiedSourceName() {
        char[] qualifiedSourceName = (char[])this.performActionOnLinkedBindings(new LinkedBindingAction(){
            private char[] fQualifiedSourceName = null;

            @Override
            public boolean performAction(SourceTypeBinding linkedBinding) {
                if (!linkedBinding.isAnonymousType()) {
                    this.fQualifiedSourceName = linkedBinding.qualifiedSourceName0();
                }
                return this.fQualifiedSourceName == null;
            }

            @Override
            public Object getFinalResult() {
                return this.fQualifiedSourceName;
            }
        });
        if (qualifiedSourceName == null) {
            qualifiedSourceName = this.qualifiedSourceName0();
        }
        return qualifiedSourceName;
    }

    private char[] qualifiedSourceName0() {
        return super.qualifiedSourceName();
    }

    @Override
    public boolean isSuperclassOf(ReferenceBinding otherType) {
        boolean isSuperTypeOf = false;
        if (otherType instanceof SourceTypeBinding) {
            final LinkedList<ReferenceBinding> compareAgainstSupersOfList = new LinkedList<ReferenceBinding>();
            compareAgainstSupersOfList.add(otherType);
            final HashSet<ReferenceBinding> compareAgainstSupersOfSet = new HashSet<ReferenceBinding>();
            compareAgainstSupersOfSet.add(otherType);
            final HashSet<SourceTypeBinding> alreadyComparedAgainstSupersOf = new HashSet<SourceTypeBinding>();
            while (!compareAgainstSupersOfList.isEmpty() && !isSuperTypeOf) {
                SourceTypeBinding checkSupersOf = (SourceTypeBinding)compareAgainstSupersOfList.removeFirst();
                compareAgainstSupersOfSet.remove(checkSupersOf);
                alreadyComparedAgainstSupersOf.add(checkSupersOf);
                isSuperTypeOf = (Boolean)checkSupersOf.performActionOnLinkedBindings(new LinkedBindingAction(){
                    private boolean fIsSuperTypeOf = false;

                    @Override
                    public boolean performAction(SourceTypeBinding otherLinkedBinding) {
                        ReferenceBinding otherLinkedSuperBinding = otherLinkedBinding.getSuperBinding0();
                        if (otherLinkedSuperBinding != null && !alreadyComparedAgainstSupersOf.contains(otherLinkedSuperBinding)) {
                            this.fIsSuperTypeOf = otherLinkedSuperBinding.isEquivalentTo(SourceTypeBinding.this);
                            if (!compareAgainstSupersOfSet.contains(otherLinkedSuperBinding)) {
                                compareAgainstSupersOfList.add(otherLinkedSuperBinding);
                                compareAgainstSupersOfSet.add(otherLinkedSuperBinding);
                            }
                        }
                        return !this.fIsSuperTypeOf;
                    }

                    @Override
                    public Object getFinalResult() {
                        return new Boolean(this.fIsSuperTypeOf);
                    }
                });
            }
        } else {
            isSuperTypeOf = super.isSuperclassOf(otherType);
        }
        return isSuperTypeOf;
    }

    private boolean inferredTypeHasFunction(char[] functionName) {
        InferredType currentType;
        InferredType inferredType = currentType = this.classScope != null ? this.classScope.inferredType : null;
        if (currentType != null && currentType.methods != null && currentType.methods.size() > 0) {
            int i = 0;
            while (i < currentType.methods.size()) {
                InferredMethod method = (InferredMethod)currentType.methods.get(i);
                if (method != null && CharOperation.equals(method.name, functionName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean inferredTypeHasField(char[] fieldName) {
        InferredAttribute[] attributes;
        InferredType currentType;
        InferredType inferredType = currentType = this.classScope != null ? this.classScope.inferredType : null;
        if (currentType != null && (attributes = currentType.attributes) != null && currentType.numberAttributes > 0) {
            int i = 0;
            while (i < currentType.numberAttributes) {
                if (attributes[i] != null && CharOperation.equals(attributes[i].name, fieldName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isFunctionType(TypeBinding binding) {
        return binding.isFunctionType() || binding instanceof FunctionTypeBinding || CharOperation.equals(binding.sourceName(), InferredType.FUNCTION_NAME);
    }

    Object performActionOnLinkedBindings(LinkedBindingAction action) {
        SourceTypeBinding currBinding = this;
        boolean keepProcessing = true;
        do {
            keepProcessing = action.performAction(currBinding);
        } while ((currBinding = currBinding.fNextType) != this && keepProcessing);
        return action.getFinalResult();
    }

    static /* synthetic */ FieldBinding access$0(SourceTypeBinding sourceTypeBinding, FieldBinding fieldBinding) {
        return sourceTypeBinding.resolveTypeFor(fieldBinding);
    }

    static abstract class LinkedBindingAction {
        LinkedBindingAction() {
        }

        public abstract boolean performAction(SourceTypeBinding var1);

        public Object getFinalResult() {
            return null;
        }
    }
}

