/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.ui.views.contextswitch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.contextswitch.KernelContextSwitchAnalysis;
import org.eclipse.tracecompass.incubator.internal.kernel.ui.views.contextswitch.ContextSwitchEntry;
import org.eclipse.tracecompass.incubator.internal.kernel.ui.views.contextswitch.ContextSwitchPresentationProvider;
import org.eclipse.tracecompass.incubator.internal.kernel.ui.views.contextswitch.ContextSwitchTimeEvent;
import org.eclipse.tracecompass.incubator.internal.kernel.ui.views.contextswitch.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ContextSwitchView
extends AbstractTimeGraphView {
    public static final String ID = "org.eclipse.tracecompass.incubator.contextswitch.ui.view";
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private final Comparator<ITimeGraphEntry> fAscendingTimeGraphEntryComparator = new Comparator<ITimeGraphEntry>(){

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            int left = ((ContextSwitchEntry)o1).getId();
            int right = ((ContextSwitchEntry)o2).getId();
            return Integer.compare(left, right);
        }
    };

    public ContextSwitchView(String id, TimeGraphPresentationProvider pres) {
        super(id, pres);
    }

    public ContextSwitchView() {
        super(ID, (TimeGraphPresentationProvider)new ContextSwitchPresentationProvider());
    }

    protected void buildEntryList(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, @NonNull IProgressMonitor monitor) {
        long startTime;
        ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.contextswitch");
        if (ssq == null) {
            return;
        }
        HashMap<Integer, TimeGraphEntry> entryMap = new HashMap<Integer, TimeGraphEntry>();
        ContextSwitchEntry traceEntry = null;
        long start = startTime = ssq.getStartTime();
        this.setStartTime(Math.min(this.getStartTime(), startTime));
        boolean complete = false;
        while (!complete) {
            if (monitor.isCanceled()) {
                return;
            }
            complete = ssq.waitUntilBuilt(500L);
            if (ssq.isCancelled()) {
                return;
            }
            long end = ssq.getCurrentEndTime();
            if (start == end && !complete) continue;
            long endTime = end + 1L;
            this.setEndTime(Math.max(this.getEndTime(), endTime));
            if (traceEntry == null) {
                traceEntry = new ContextSwitchEntry(trace, startTime, endTime);
                List<ContextSwitchEntry> entryList = Collections.singletonList(traceEntry);
                this.addToEntryList(parentTrace, entryList);
            } else {
                traceEntry.updateEndTime(endTime);
            }
            List cpuQuarks = ssq.getQuarks(new String[]{"CPUs", "*"});
            for (Integer cpuQuark : cpuQuarks) {
                TimeGraphEntry entry = (TimeGraphEntry)entryMap.get(cpuQuark);
                if (entry == null) {
                    String cpuId = ssq.getAttributeName(cpuQuark.intValue());
                    entry = new ContextSwitchEntry(trace, String.valueOf(Messages.ContextSwitchPresentationProvider_CPU) + cpuId, startTime, endTime, Integer.parseInt(cpuId));
                    entryMap.put(cpuQuark, entry);
                    traceEntry.addChild(entry);
                    continue;
                }
                entry.updateEndTime(endTime);
            }
            traceEntry.sortChildren(this.fAscendingTimeGraphEntryComparator);
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            long resolution = Math.max(1L, (endTime - ssq.getStartTime()) / (long)this.getDisplayWidth());
            for (ITimeGraphEntry child : traceEntry.getChildren()) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (!(child instanceof TimeGraphEntry)) continue;
                this.populateTimeGraphEntry(monitor, start, endTime, resolution, (TimeGraphEntry)child);
            }
            start = end;
        }
    }

    private void populateTimeGraphEntry(@NonNull IProgressMonitor monitor, long start, long endTime, long resolution, @NonNull TimeGraphEntry entry) {
        List<ITimeEvent> eventList = this.getEventList(entry, start, endTime, resolution, monitor);
        if (eventList != null) {
            for (ITimeEvent event : eventList) {
                entry.addEvent(event);
            }
        }
        this.redraw();
    }

    protected List<ITimeEvent> getEventList(TimeGraphEntry entry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        long bucketLength = 20L * resolution;
        if (!(entry instanceof ContextSwitchEntry)) {
            return null;
        }
        ContextSwitchEntry contextSwitchEntry = (ContextSwitchEntry)entry;
        ITmfStateSystem sS = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)contextSwitchEntry.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.contextswitch");
        if (sS == null) {
            return null;
        }
        int nbCPU = sS.getQuarks(new String[]{"CPUs", "*"}).size();
        if (nbCPU == 0) {
            return null;
        }
        long realStart = Math.max(startTime, sS.getStartTime());
        long realEnd = Math.min(endTime, sS.getCurrentEndTime());
        if (realEnd <= realStart) {
            return null;
        }
        KernelContextSwitchAnalysis kernelContextSwitchSS = (KernelContextSwitchAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)contextSwitchEntry.getTrace(), KernelContextSwitchAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.contextswitch");
        if (kernelContextSwitchSS == null) {
            return null;
        }
        Map cs = kernelContextSwitchSS.getContextSwitchesRange(realStart, realEnd);
        if (cs.isEmpty()) {
            return null;
        }
        Long totalCxtSwtInRange = (Long)cs.get(KernelContextSwitchAnalysis.TOTAL);
        if (totalCxtSwtInRange == null) {
            throw new IllegalStateException("A non-empty map of context switches should at least contain the total number (0)");
        }
        if (!contextSwitchEntry.hasId()) {
            long deltat = realEnd - realStart;
            double deltaPerCPU = totalCxtSwtInRange.longValue();
            contextSwitchEntry.setMean((int)((deltaPerCPU /= (double)nbCPU) * (double)bucketLength / (double)deltat));
            return Collections.emptyList();
        }
        ArrayList<ITimeEvent> eventList = null;
        eventList = new ArrayList<ITimeEvent>();
        long queryStart = realStart;
        long queryEnd = queryStart + bucketLength;
        while (queryStart <= realEnd) {
            Long nbOfContextSwitchForCPU;
            if (monitor.isCanceled()) {
                return null;
            }
            Map map = kernelContextSwitchSS.getContextSwitchesRange(queryStart, queryEnd);
            if (map.containsKey(contextSwitchEntry.getId()) && (nbOfContextSwitchForCPU = (Long)map.get(contextSwitchEntry.getId())) != null) {
                ContextSwitchTimeEvent event = new ContextSwitchTimeEvent((ITimeGraphEntry)entry, queryStart, bucketLength, nbOfContextSwitchForCPU.intValue());
                eventList.add((ITimeEvent)event);
            }
            queryStart = queryEnd;
            queryEnd += bucketLength;
        }
        ContextSwitchView.classifyEvents(eventList);
        if (monitor.isCanceled()) {
            return null;
        }
        return eventList;
    }

    private static void classifyEvents(List<ITimeEvent> eventList) {
        if (eventList == null || eventList.isEmpty()) {
            return;
        }
        double mean = Double.NaN;
        long lowRateThreshold = (long)((double)ClassificationFactors.LOW.fFactor.floatValue() * mean);
        long moderateRateThreshold = (long)((double)ClassificationFactors.MODERATE.fFactor.floatValue() * mean);
        long highRateThreshold = (long)((double)ClassificationFactors.HIGH.fFactor.floatValue() * mean);
        if (lowRateThreshold <= 0L) {
            lowRateThreshold = 1L;
        }
        if (moderateRateThreshold <= lowRateThreshold) {
            moderateRateThreshold = lowRateThreshold + 1L;
        }
        if (highRateThreshold <= moderateRateThreshold) {
            highRateThreshold = moderateRateThreshold + 1L;
        }
        for (ITimeEvent event : eventList) {
            long contextSwitchRate;
            if (!(event instanceof ContextSwitchTimeEvent)) continue;
            ContextSwitchTimeEvent csEvent = (ContextSwitchTimeEvent)event;
            if (Double.isNaN(mean)) {
                mean = ((ContextSwitchEntry)event.getEntry()).getMean();
            }
            csEvent.fRate = (contextSwitchRate = (long)csEvent.getValue()) == 0L ? ContextSwitchTimeEvent.ContextSwitchRate.NONE : (contextSwitchRate <= lowRateThreshold ? ContextSwitchTimeEvent.ContextSwitchRate.LOW : (contextSwitchRate <= moderateRateThreshold ? ContextSwitchTimeEvent.ContextSwitchRate.MODERATE : (contextSwitchRate <= highRateThreshold ? ContextSwitchTimeEvent.ContextSwitchRate.HIGH : ContextSwitchTimeEvent.ContextSwitchRate.CRITICAL)));
        }
    }

    private static enum ClassificationFactors {
        LOW(Float.valueOf(0.5f)),
        MODERATE(Float.valueOf(1.0f)),
        HIGH(Float.valueOf(1.5f)),
        CRITICAL(Float.valueOf(2.0f));

        Float fFactor;

        private ClassificationFactors(Float f) {
            this.fFactor = f;
        }
    }
}

