/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.FileEntry;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchEditorOpener;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchResultLabelProvider2;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.wst.jsdt.internal.ui.search.TextSearchTableContentProvider;

public class NLSSearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private TextSearchTableContentProvider fContentProvider;
    private NLSSearchEditorOpener fEditorOpener = new NLSSearchEditorOpener();

    public NLSSearchResultPage() {
        super(1);
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        try {
            IEditorPart editor = this.fEditorOpener.openMatch(match);
            if (editor != null && activate) {
                editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
            }
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(currentOffset, currentLength);
            }
        }
        catch (JavaScriptModelException e1) {
            throw new PartInitException(e1.getStatus());
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        throw new IllegalStateException("Doesn't support tree mode.");
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof FileEntry) {
                    return 0;
                }
                return 1;
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new NLSSearchResultLabelProvider2(this));
        this.fContentProvider = new TextSearchTableContentProvider();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
    }

    public Object getAdapter(Class adapter) {
        if (IShowInTargetList.class.equals((Object)adapter)) {
            return JavaSearchResultPage.SHOW_IN_TARGET_LIST;
        }
        return null;
    }
}

