/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;

public class SizeofCalculator {
    private static final SizeofCalculator defaultInstance = new SizeofCalculator();
    private static final SizeAndAlignment SIZE_1 = new SizeAndAlignment(1L, 1);
    public final SizeAndAlignment size_2;
    public final SizeAndAlignment size_4;
    public final SizeAndAlignment size_8;
    public final SizeAndAlignment size_16;
    public final SizeAndAlignment sizeof_pointer;
    public final SizeAndAlignment sizeof_int;
    public final SizeAndAlignment sizeof_long;
    public final SizeAndAlignment sizeof_long_long;
    public final SizeAndAlignment sizeof_int128;
    public final SizeAndAlignment sizeof_short;
    public final SizeAndAlignment sizeof_bool;
    public final SizeAndAlignment sizeof_wchar_t;
    public final SizeAndAlignment sizeof_float;
    public final SizeAndAlignment sizeof_complex_float;
    public final SizeAndAlignment sizeof_double;
    public final SizeAndAlignment sizeof_complex_double;
    public final SizeAndAlignment sizeof_long_double;
    public final SizeAndAlignment sizeof_complex_long_double;
    public final SizeAndAlignment sizeof_float128;
    public final SizeAndAlignment sizeof_complex_float128;
    public final SizeAndAlignment sizeof_decimal32;
    public final SizeAndAlignment sizeof_decimal64;
    public final SizeAndAlignment sizeof_decimal128;
    private final IASTTranslationUnit ast;

    public static SizeAndAlignment getSizeAndAlignment(IType type) {
        IASTNode point = CPPSemantics.getCurrentLookupPoint();
        SizeofCalculator calc = point == null ? SizeofCalculator.getDefault() : ((ASTTranslationUnit)point.getTranslationUnit()).getSizeofCalculator();
        return calc.sizeAndAlignment(type);
    }

    public static SizeofCalculator getDefault() {
        return defaultInstance;
    }

    public SizeofCalculator(IASTTranslationUnit ast) {
        this.ast = ast;
        int maxAlignment = 32;
        HashMap<String, String> sizeofMacros = new HashMap<String, String>();
        IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = ast.getBuiltinMacroDefinitions();
        int n = iASTPreprocessorMacroDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorMacroDefinition macro = iASTPreprocessorMacroDefinitionArray[n2];
            String name = macro.getName().toString();
            if ("__BIGGEST_ALIGNMENT__".equals(name)) {
                try {
                    maxAlignment = Integer.parseInt(macro.getExpansion());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (name.startsWith("__SIZEOF_")) {
                sizeofMacros.put(name, macro.getExpansion());
            }
            ++n2;
        }
        this.size_2 = new SizeAndAlignment(2L, Math.min(2, maxAlignment));
        this.size_4 = new SizeAndAlignment(4L, Math.min(4, maxAlignment));
        this.size_8 = new SizeAndAlignment(8L, Math.min(8, maxAlignment));
        this.size_16 = new SizeAndAlignment(16L, Math.min(16, maxAlignment));
        this.sizeof_pointer = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_POINTER__", maxAlignment);
        this.sizeof_int = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_INT__", maxAlignment);
        this.sizeof_long = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_LONG__", maxAlignment);
        this.sizeof_long_long = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_LONG_LONG__", maxAlignment);
        this.sizeof_int128 = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_INT128__", maxAlignment);
        this.sizeof_short = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_SHORT__", maxAlignment);
        SizeAndAlignment size = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_BOOL__", maxAlignment);
        if (size == null) {
            size = SIZE_1;
        }
        this.sizeof_bool = size;
        this.sizeof_wchar_t = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_WCHAR_T__", maxAlignment);
        this.sizeof_float = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_FLOAT__", maxAlignment);
        this.sizeof_complex_float = this.getSizeOfPair(this.sizeof_float);
        this.sizeof_double = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_DOUBLE__", maxAlignment);
        this.sizeof_complex_double = this.getSizeOfPair(this.sizeof_double);
        this.sizeof_long_double = SizeofCalculator.getSize(sizeofMacros, "__SIZEOF_LONG_DOUBLE__", maxAlignment);
        this.sizeof_complex_long_double = this.getSizeOfPair(this.sizeof_long_double);
        this.sizeof_float128 = this.size_16;
        this.sizeof_complex_float128 = this.getSizeOfPair(this.sizeof_float128);
        this.sizeof_decimal32 = this.size_4;
        this.sizeof_decimal64 = this.size_8;
        this.sizeof_decimal128 = this.size_16;
    }

    private SizeofCalculator() {
        this.size_2 = new SizeAndAlignment(2L, 2);
        this.size_4 = new SizeAndAlignment(4L, 4);
        this.size_8 = new SizeAndAlignment(8L, 8);
        this.size_16 = new SizeAndAlignment(16L, 16);
        this.sizeof_pointer = null;
        this.sizeof_int = null;
        this.sizeof_long = null;
        this.sizeof_long_long = null;
        this.sizeof_int128 = this.size_16;
        this.sizeof_short = null;
        this.sizeof_bool = SIZE_1;
        this.sizeof_wchar_t = null;
        this.sizeof_float = null;
        this.sizeof_complex_float = null;
        this.sizeof_double = null;
        this.sizeof_complex_double = null;
        this.sizeof_long_double = null;
        this.sizeof_complex_long_double = null;
        this.sizeof_float128 = this.size_16;
        this.sizeof_complex_float128 = this.getSizeOfPair(this.sizeof_float128);
        this.sizeof_decimal32 = this.size_4;
        this.sizeof_decimal64 = this.size_8;
        this.sizeof_decimal128 = this.size_16;
        this.ast = null;
    }

    public SizeAndAlignment sizeAndAlignment(IType type) {
        if ((type = SemanticUtil.getNestedType(type, 9)) instanceof IFunctionType) {
            return this.sizeAndAlignment(((IFunctionType)type).getReturnType());
        }
        if (type instanceof IBasicType) {
            return this.sizeAndAlignment((IBasicType)type);
        }
        if (type instanceof ICPPReferenceType) {
            return this.sizeAndAlignment(((ICPPReferenceType)type).getType());
        }
        if (type instanceof IPointerType) {
            if (type instanceof ICPPPointerToMemberType) {
                return null;
            }
            return this.sizeof_pointer;
        }
        if (type instanceof IEnumeration) {
            return this.sizeAndAlignment((IEnumeration)type);
        }
        if (type instanceof IArrayType) {
            return this.sizeAndAlignment((IArrayType)type);
        }
        if (type instanceof ICompositeType) {
            return this.sizeAndAlignment((ICompositeType)type);
        }
        return null;
    }

    public SizeAndAlignment sizeAndAlignmentOfPointer() {
        return this.sizeof_pointer;
    }

    private SizeAndAlignment sizeAndAlignment(IBasicType type) {
        IBasicType.Kind kind = type.getKind();
        switch (kind) {
            case eBoolean: {
                return this.sizeof_bool;
            }
            case eChar: {
                return SIZE_1;
            }
            case eInt: {
                return type.isShort() ? this.sizeof_short : (type.isLong() ? this.sizeof_long : (type.isLongLong() ? this.sizeof_long_long : this.sizeof_int));
            }
            case eInt128: {
                return this.sizeof_int128;
            }
            case eFloat: {
                return type.isComplex() ? this.sizeof_complex_float : this.sizeof_float;
            }
            case eDouble: {
                return type.isComplex() ? (type.isLong() ? this.sizeof_complex_long_double : this.sizeof_complex_double) : (type.isLong() ? this.sizeof_long_double : this.sizeof_double);
            }
            case eFloat128: {
                return type.isComplex() ? this.sizeof_complex_float128 : this.sizeof_float128;
            }
            case eDecimal32: {
                return this.sizeof_decimal32;
            }
            case eDecimal64: {
                return this.sizeof_decimal64;
            }
            case eDecimal128: {
                return this.sizeof_decimal128;
            }
            case eWChar: {
                return this.sizeof_wchar_t;
            }
            case eChar16: {
                return this.size_2;
            }
            case eChar32: {
                return this.size_4;
            }
            case eNullPtr: {
                return this.sizeof_pointer;
            }
        }
        return null;
    }

    private SizeAndAlignment sizeAndAlignment(IEnumeration type) {
        IType underlyingType = TypeTraits.underlyingType(type);
        if (underlyingType instanceof IBasicType) {
            return this.sizeAndAlignment((IBasicType)underlyingType);
        }
        return null;
    }

    private SizeAndAlignment sizeAndAlignment(IArrayType type) {
        IValue value = type.getSize();
        if (value == null) {
            return null;
        }
        Number numElements = value.numberValue();
        if (numElements == null) {
            return null;
        }
        IType elementType = type.getType();
        SizeAndAlignment info = this.sizeAndAlignment(elementType);
        if (numElements.longValue() == 1L) {
            return info;
        }
        if (info == null) {
            return null;
        }
        return new SizeAndAlignment(info.size * numElements.longValue(), info.alignment);
    }

    private SizeAndAlignment sizeAndAlignment(ICompositeType type) {
        IField[] fields;
        SizeAndAlignment info;
        int n;
        int n2;
        Object[] objectArray;
        long size = 0L;
        int maxAlignment = 1;
        if (type instanceof ICPPClassType) {
            if (this.ast != null) {
                CPPSemantics.pushLookupPoint(this.ast);
            }
            try {
                ICPPClassType classType = (ICPPClassType)type;
                objectArray = classType.getBases();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object base = objectArray[n];
                    if (base.isVirtual()) {
                        return null;
                    }
                    IBinding baseClass = base.getBaseClass();
                    if (!(baseClass instanceof IType)) {
                        return null;
                    }
                    info = this.sizeAndAlignment((IType)((Object)baseClass));
                    if (info == null) {
                        return null;
                    }
                    size += (long)info.alignment - (size - 1L) % (long)info.alignment - 1L + info.size;
                    if (maxAlignment < info.alignment) {
                        maxAlignment = info.alignment;
                    }
                    ICPPMethod[] iCPPMethodArray = classType.getDeclaredMethods();
                    int n3 = iCPPMethodArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICPPMethod method = iCPPMethodArray[n4];
                        if (method.isVirtual()) {
                            return null;
                        }
                        ++n4;
                    }
                    ++n;
                }
                fields = classType.getDeclaredFields();
            }
            finally {
                if (this.ast != null) {
                    CPPSemantics.popLookupPoint();
                }
            }
        } else {
            fields = type.getFields();
        }
        boolean union = type.getKey() == 2;
        objectArray = fields;
        n2 = fields.length;
        n = 0;
        while (n < n2) {
            Object field = objectArray[n];
            if (!field.isStatic()) {
                IType fieldType = field.getType();
                info = fieldType instanceof ICPPReferenceType ? this.sizeof_pointer : this.sizeAndAlignment(fieldType);
                if (info == null) {
                    return null;
                }
                if (union) {
                    if (size < info.size) {
                        size = info.size;
                    }
                } else {
                    if (size > 0L) {
                        size += (long)info.alignment - (size - 1L) % (long)info.alignment - 1L;
                    }
                    size += info.size;
                }
                if (maxAlignment < info.alignment) {
                    maxAlignment = info.alignment;
                }
            }
            ++n;
        }
        if (size == 0L) {
            size = 1L;
        }
        size += (long)maxAlignment - (size - 1L) % (long)maxAlignment - 1L;
        return new SizeAndAlignment(size, maxAlignment);
    }

    private static SizeAndAlignment getSize(Map<String, String> macros, String name, int maxAlignment) {
        String value = macros.get(name);
        if (value == null) {
            return null;
        }
        try {
            int size = Integer.parseInt(value);
            return new SizeAndAlignment(size, Math.min(size, maxAlignment));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private SizeAndAlignment getSizeOfPair(SizeAndAlignment sizeAndAlignment) {
        return sizeAndAlignment == null ? null : new SizeAndAlignment(sizeAndAlignment.size * 2L, sizeAndAlignment.alignment);
    }

    public static class SizeAndAlignment {
        public final long size;
        public final int alignment;

        public SizeAndAlignment(long size, int alignment) {
            this.size = size;
            this.alignment = alignment;
        }
    }
}

