/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.progress.IDisposableAction;
import org.eclipse.e4.ui.progress.IProgressConstants;
import org.eclipse.e4.ui.progress.internal.GroupInfo;
import org.eclipse.e4.ui.progress.internal.IJobProgressManagerListener;
import org.eclipse.e4.ui.progress.internal.JobInfo;
import org.eclipse.e4.ui.progress.internal.JobTreeElement;
import org.eclipse.e4.ui.progress.internal.ProgressManagerUtil;
import org.eclipse.e4.ui.progress.internal.TaskInfo;

@Creatable
@Singleton
public class FinishedJobs
extends EventManager {
    final IJobProgressManagerListener listener;
    private final Set<JobTreeElement> keptjobinfos = new LinkedHashSet<JobTreeElement>();
    private HashMap<Object, Long> finishedTime = new HashMap();
    private static final JobTreeElement[] EMPTY_INFOS = new JobTreeElement[0];

    public FinishedJobs() {
        this.listener = new IJobProgressManagerListener(){

            @Override
            public void addJob(JobInfo info) {
                FinishedJobs.this.removeDuplicates(info);
            }

            @Override
            public void addGroup(GroupInfo info) {
                FinishedJobs.this.removeDuplicates(info);
            }

            @Override
            public void refreshJobInfo(JobInfo info) {
                FinishedJobs.this.checkTasks(info);
            }

            @Override
            public void refreshGroup(GroupInfo info) {
            }

            @Override
            public void refreshAll() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeJob(JobInfo info) {
                if (FinishedJobs.keep(info)) {
                    Set set = FinishedJobs.this.keptjobinfos;
                    synchronized (set) {
                        FinishedJobs.this.removeDuplicates(info);
                        FinishedJobs.this.add(info);
                    }
                }
            }

            @Override
            public void removeGroup(GroupInfo group) {
            }

            @Override
            public boolean showsDebug() {
                return false;
            }
        };
    }

    static boolean keep(JobInfo info) {
        Job job = info.getJob();
        if (job != null) {
            Object prop = job.getProperty(ProgressManagerUtil.KEEP_PROPERTY);
            if (prop instanceof Boolean && ((Boolean)prop).booleanValue()) {
                return true;
            }
            prop = job.getProperty(ProgressManagerUtil.KEEPONE_PROPERTY);
            if (prop instanceof Boolean && ((Boolean)prop).booleanValue()) {
                return true;
            }
            IStatus status = job.getResult();
            if (status != null && status.getSeverity() == 4) {
                return true;
            }
        }
        return false;
    }

    void addListener(KeptJobsListener l) {
        this.addListenerObject(l);
    }

    void removeListener(KeptJobsListener l) {
        this.removeListenerObject(l);
    }

    private void removeDuplicates(GroupInfo info) {
        Object[] objects;
        Object[] objectArray = objects = info.getChildren();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof JobInfo) {
                this.removeDuplicates((JobInfo)object);
            }
            ++n2;
        }
    }

    private void removeDuplicates(JobTreeElement info) {
        JobTreeElement[] toBeRemoved = this.findJobsToRemove(info);
        if (toBeRemoved != null) {
            JobTreeElement[] jobTreeElementArray = toBeRemoved;
            int n = toBeRemoved.length;
            int n2 = 0;
            while (n2 < n) {
                JobTreeElement element = jobTreeElementArray[n2];
                this.remove(element);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(JobInfo info) {
        boolean fire = false;
        Set<JobTreeElement> set = this.keptjobinfos;
        synchronized (set) {
            if (!this.keptjobinfos.contains(info)) {
                this.keptjobinfos.add(info);
                long now = System.currentTimeMillis();
                this.finishedTime.put(info, now);
                GroupInfo parent = info.getParent();
                if (parent != null && !this.keptjobinfos.contains(parent)) {
                    this.keptjobinfos.add(parent);
                    this.finishedTime.put(parent, now);
                }
                fire = true;
            }
        }
        if (fire) {
            Object[] l;
            Object[] objectArray = l = this.getListeners();
            int n = l.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                KeptJobsListener jv = (KeptJobsListener)element;
                jv.finished(info);
                ++n2;
            }
        }
    }

    static void disposeAction(JobTreeElement jte) {
        Object prop;
        JobInfo ji;
        Job job;
        if (jte.isJobInfo() && (job = (ji = (JobInfo)jte).getJob()) != null && (prop = job.getProperty(IProgressConstants.ACTION_PROPERTY)) instanceof IDisposableAction) {
            ((IDisposableAction)prop).dispose();
        }
    }

    private JobTreeElement[] findJobsToRemove(JobTreeElement info) {
        Object prop;
        Job myJob;
        if (info.isJobInfo() && (myJob = ((JobInfo)info).getJob()) != null && (prop = myJob.getProperty(ProgressManagerUtil.KEEPONE_PROPERTY)) instanceof Boolean && ((Boolean)prop).booleanValue()) {
            JobTreeElement[] all;
            ArrayList<JobTreeElement> found = null;
            JobTreeElement[] jobTreeElementArray = all = this.getKeptElements();
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                Job job;
                JobTreeElement jte = jobTreeElementArray[n2];
                if (jte != info && jte.isJobInfo() && (job = ((JobInfo)jte).getJob()) != null && job != myJob && job.belongsTo((Object)myJob)) {
                    if (found == null) {
                        found = new ArrayList<JobTreeElement>();
                    }
                    found.add(jte);
                }
                ++n2;
            }
            if (found != null) {
                return found.toArray(new JobTreeElement[found.size()]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTasks(JobInfo info) {
        TaskInfo tinfo;
        if (FinishedJobs.keep(info) && (tinfo = info.getTaskInfo()) != null) {
            int n;
            int n2;
            Object[] objectArray;
            JobTreeElement[] toBeRemoved = null;
            boolean fire = false;
            JobTreeElement element = (JobTreeElement)tinfo.getParent();
            Set<JobTreeElement> set = this.keptjobinfos;
            synchronized (set) {
                if (element == info && !this.keptjobinfos.contains(tinfo)) {
                    toBeRemoved = this.findJobsToRemove(element);
                    this.keptjobinfos.add(tinfo);
                    this.finishedTime.put(tinfo, System.currentTimeMillis());
                }
            }
            if (toBeRemoved != null) {
                objectArray = toBeRemoved;
                n2 = toBeRemoved.length;
                n = 0;
                while (n < n2) {
                    Object jobTreeElement = objectArray[n];
                    this.remove((JobTreeElement)jobTreeElement);
                    ++n;
                }
            }
            if (fire) {
                objectArray = this.getListeners();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object listener = objectArray[n];
                    KeptJobsListener jv = (KeptJobsListener)listener;
                    jv.finished(info);
                    ++n;
                }
            }
        }
    }

    public void removeErrorJobs() {
        JobTreeElement[] infos;
        JobTreeElement[] jobTreeElementArray = infos = this.getKeptElements();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status;
            JobInfo info1;
            Job job;
            JobTreeElement info = jobTreeElementArray[n2];
            if (info.isJobInfo() && (job = (info1 = (JobInfo)info).getJob()) != null && (status = job.getResult()) != null && status.getSeverity() == 4) {
                JobTreeElement topElement = info1.getParent();
                if (topElement == null) {
                    topElement = info1;
                }
                this.remove(topElement);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(JobTreeElement jte) {
        int n;
        boolean fire = false;
        boolean removed = false;
        Set<JobTreeElement> set = this.keptjobinfos;
        synchronized (set) {
            if (this.keptjobinfos.remove(jte)) {
                JobTreeElement[] jobTreeElements;
                removed = true;
                this.finishedTime.remove(jte);
                FinishedJobs.disposeAction(jte);
                JobTreeElement[] jobTreeElementArray = jobTreeElements = this.getKeptElements();
                int n2 = jobTreeElements.length;
                n = 0;
                while (n < n2) {
                    JobTreeElement jobTreeElement = jobTreeElementArray[n];
                    JobTreeElement parent = (JobTreeElement)jobTreeElement.getParent();
                    if (parent != null && (parent == jte || parent.getParent() == jte)) {
                        if (this.keptjobinfos.remove(jobTreeElement)) {
                            FinishedJobs.disposeAction(jobTreeElement);
                        }
                        this.finishedTime.remove(jobTreeElement);
                    }
                    ++n;
                }
                fire = true;
            }
        }
        if (fire) {
            Object[] l;
            Object[] objectArray = l = this.getListeners();
            n = l.length;
            int n3 = 0;
            while (n3 < n) {
                Object element = objectArray[n3];
                KeptJobsListener jv = (KeptJobsListener)element;
                jv.removed(jte);
                ++n3;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobTreeElement[] getKeptElements() {
        Set<JobTreeElement> set = this.keptjobinfos;
        synchronized (set) {
            if (this.keptjobinfos.isEmpty()) {
                return EMPTY_INFOS;
            }
            return this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
        }
    }

    public Date getFinishDate(JobTreeElement jte) {
        Long value = this.finishedTime.get(jte);
        if (value != null) {
            return new Date(value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKept(JobTreeElement element) {
        Set<JobTreeElement> set = this.keptjobinfos;
        synchronized (set) {
            return this.keptjobinfos.contains(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object[] l;
        int n;
        Set<JobTreeElement> set = this.keptjobinfos;
        synchronized (set) {
            JobTreeElement[] all;
            JobTreeElement[] jobTreeElementArray = all = this.getKeptElements();
            int n2 = all.length;
            n = 0;
            while (n < n2) {
                JobTreeElement element = jobTreeElementArray[n];
                FinishedJobs.disposeAction(element);
                ++n;
            }
            this.keptjobinfos.clear();
            this.finishedTime.clear();
        }
        Object[] objectArray = l = this.getListeners();
        n = l.length;
        int n3 = 0;
        while (n3 < n) {
            Object element = objectArray[n3];
            KeptJobsListener jv = (KeptJobsListener)element;
            jv.removed(null);
            ++n3;
        }
    }

    static interface KeptJobsListener {
        public void finished(JobTreeElement var1);

        public void removed(JobTreeElement var1);
    }
}

