/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;

public interface RandomVectorScorer {
    public float score(int var1) throws IOException;

    public static RandomVectorScorer createFloats(RandomAccessVectorValues<float[]> vectors, VectorSimilarityFunction similarityFunction, float[] query) {
        if (query.length != vectors.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + query.length + " differs from field dimension: " + vectors.dimension());
        }
        return node -> similarityFunction.compare(query, (float[])vectors.vectorValue(node));
    }

    public static RandomVectorScorer createBytes(RandomAccessVectorValues<byte[]> vectors, VectorSimilarityFunction similarityFunction, byte[] query) {
        if (query.length != vectors.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + query.length + " differs from field dimension: " + vectors.dimension());
        }
        return node -> similarityFunction.compare(query, (byte[])vectors.vectorValue(node));
    }
}

