/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.complete;

import org.eclipse.jdt.internal.codeassist.complete.CompletionNode;
import org.eclipse.jdt.internal.codeassist.complete.CompletionNodeFound;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

public class CompletionOnReferenceExpressionName
extends ReferenceExpression
implements CompletionNode {
    public CompletionOnReferenceExpressionName(Scanner scanner) {
        super(scanner);
    }

    public TypeBinding resolveType(BlockScope scope) {
        CompilerOptions compilerOptions = scope.compilerOptions();
        this.constant = Constant.NotAConstant;
        TypeBinding lhsType = this.lhs.resolveType(scope);
        if (this.typeArguments != null) {
            int length = this.typeArguments.length;
            boolean typeArgumentsHaveErrors = compilerOptions.sourceLevel < 0x310000L;
            this.resolvedTypeArguments = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                TypeReference typeReference = this.typeArguments[i];
                this.resolvedTypeArguments[i] = typeReference.resolveType(scope, true);
                if (this.resolvedTypeArguments[i] == null) {
                    typeArgumentsHaveErrors = true;
                }
                if (typeArgumentsHaveErrors && typeReference instanceof Wildcard) {
                    scope.problemReporter().illegalUsageOfWildcard(typeReference);
                }
                ++i;
            }
            if (typeArgumentsHaveErrors || lhsType == null) {
                throw new CompletionNodeFound();
            }
        }
        if (lhsType != null && lhsType.isValidBinding()) {
            throw new CompletionNodeFound((ASTNode)this, (Binding)lhsType, (Scope)scope);
        }
        throw new CompletionNodeFound();
    }

    public StringBuffer printExpression(int tab, StringBuffer output) {
        output.append("<CompletionOnReferenceExpressionName:");
        this.lhs.print(0, output);
        output.append("::");
        if (this.typeArguments != null) {
            output.append('<');
            int max = this.typeArguments.length - 1;
            int j = 0;
            while (j < max) {
                this.typeArguments[j].print(0, output);
                output.append(", ");
                ++j;
            }
            this.typeArguments[max].print(0, output);
            output.append('>');
        }
        output.append(this.selector);
        return output.append('>');
    }
}

